#!/usr/bin/env bash

if ((`id -u` != 0)) 
then
  echo error: You need to be root to stop NTP!
  exit 1
fi

#remove line who disable sanity limit
no_sanity_limit=`grep "tinker panic 0" /etc/ntp.conf`
if [ -n "$no_sanity_limit" ]; then
     sed -i '/tinker panic 0/d' /etc/ntp.conf
fi

#Erase all time servers from /etc/ntp.conf
sed -i '/^server/ d' /etc/ntp.conf 
sed -i '/^restrict/ d' /etc/ntp.conf
echo "server 127.127.1.0" >> /etc/ntp.conf
echo "restrict default kod nomodify notrap nopeer noquery" >> /etc/ntp.conf
echo "restrict -6 default kod nomodify notrap nopeer noquery" >> /etc/ntp.conf

#Restart ntpd
if [ ! -f /opt/Avaya/.ova ]; then
    systemctl restart ntpd

    #If NTP failed to start, display error message.
    if [ "`pgrep ntpd`" = "" ]; then
        echo Error: could not restart NTP service
        exit 1
    fi
else
    # For virtualization need at least one valid time sync option.
    echo "restrict 127.0.0.1 ignore" >> /etc/ntp.conf
    systemctl enable ntpd
    systemctl restart ntpd
    if [ ! -z "`which vmware-toolbox-cmd`" ]; then
        vmware-toolbox-cmd timesync enable
    fi
fi
