#!/bin/sh

lockfile=/var/lock/tcpdump_script.LOCK

COMMAND=$1
BASE_DIR="/opt/Avaya/logs/tcpdump_pkgs"
BASE_FILENAME=$BASE_DIR"/tcpdump_capture"
BASE_PID_FILENAME="/opt/Avaya/.tcpdump_pid"
TIMESTAMP_FILE=$BASE_DIR"/tcpdumpLastTimeStamp"

if [ "$COMMAND" == "stop" ]; then
    if [ -f $BASE_PID_FILENAME ]; then
        PID=$(<$BASE_PID_FILENAME)
        if [ -n "$PID" ]; then
            kill -KILL "$PID"
        fi
        rm -f $BASE_PID_FILENAME
        echo `date +%F-%H-%M`>> $TIMESTAMP_FILE
    fi
elif [ "$COMMAND" == "start" ]; then
    if [ -f $BASE_PID_FILENAME ]; then
            exit
    fi

    mkdir $BASE_DIR

    rm -f $BASE_FILENAME*
    rm -f $TIMESTAMP_FILE

    INTERFACE=$2
    MAX_FILE_SIZE=$3
    MAX_FILE_NUM=$4

    if [ "$INTERFACE" == "all" ]; then
        tcpdump -XX -pni any -s 0 -C "$MAX_FILE_SIZE" -W "$MAX_FILE_NUM" -w "$BASE_FILENAME""_"`date +%Y-%m-%d-%H-%M`".pcap" -Z root > /dev/null 2>&1 &
    else
        tcpdump -XX -pni "$INTERFACE" -s 0 -C "$MAX_FILE_SIZE" -W "$MAX_FILE_NUM" -w "$BASE_FILENAME""_"`date +%Y-%m-%d-%H-%M`".pcap" -Z root > /dev/null 2>&1 &
    fi

    echo "$!">> "$BASE_PID_FILENAME"
elif [ "$COMMAND" == "restart" ]; then
   if [ -f $BASE_PID_FILENAME ]; then
        PID=$(<$BASE_PID_FILENAME)
        if [ -n "$PID" ]; then
            kill -KILL "$PID"
        fi
        rm -f $BASE_PID_FILENAME    
    fi

    mkdir $BASE_DIR

    rm -f $BASE_FILENAME*
    rm -f $TIMESTAMP_FILE

    INTERFACE=$2
    MAX_FILE_SIZE=$3
    MAX_FILE_NUM=$4

    if [ "$INTERFACE" == "all" ]; then
        tcpdump -XX -pni any -s 0 -C "$MAX_FILE_SIZE" -W "$MAX_FILE_NUM" -w "$BASE_FILENAME""_"`date +%Y-%m-%d-%H-%M`".pcap" -Z root > /dev/null 2>&1 &
    else
        tcpdump -XX -pni "$INTERFACE" -s 0 -C "$MAX_FILE_SIZE" -W "$MAX_FILE_NUM" -w "$BASE_FILENAME""_"`date +%Y-%m-%d-%H-%M`".pcap" -Z root > /dev/null 2>&1 &
    fi

    echo "$!">> "$BASE_PID_FILENAME"
fi
