
ERROR=0

if [ ! -d /var/cache/avaya/apps ]; then
    echo "Error: Web control failed install"
    ERROR=1
else
    cd /var/cache/avaya/apps

    for i in *.rpm; do
        rpm --nosignature -K $i &> /dev/null
        if [ $? -ne 0 ]; then
            echo "Error: Failed file checksums, possible media corruption - file: $i"
            ERROR=1
        fi
    done
    
    PACKAGES=( VmPro-Mapi VmPro-Client windows-sharing cli cli-commands vmpro oneXportal webcontrol watchdog vmpro-wavs-TTY vmpro-wavs-ch vmpro-wavs-da vmpro-wavs-el vmpro-wavs-en vmpro-wavs-es vmpro-wavs-eso vmpro-wavs-fr vmpro-wavs-frc vmpro-wavs-it vmpro-wavs-jp vmpro-wavs-nl vmpro-wavs-no vmpro-wavs-pt vmpro-wavs-ptb vmpro-wavs-sv vmpro-wavs-zhh )

    if [ -f /opt/Avaya/ABE_release ]; then
        PACKAGES=( ${PACKAGES[@]} ipoffice ms webcontrol-plugin-serveredition TTSEnglish  TAPI AvayaIPOfficeSoftConsole DLink AdminLite ipphonebin )
    elif [ -f /opt/Avaya/APPL_release -o -f /opt/Avaya/APC_release ]; then
        PACKAGES=( ${PACKAGES[@]} webcontrol-plugin-appl )
    fi
    
    for i in ${PACKAGES[@]}; do
        rpm -q $i &> /dev/null
        if [ $? -ne 0 ]; then
            echo "Error: Package: $i not installed"
            ERROR=1
        fi
    done

    _WEBCONTROL_PROTOCOL="http"
    _WEBCONTROL_PORT="7070"
    if [ -f /etc/sysconfig/webcontrol ];then
        . /etc/sysconfig/webcontrol
        if [ -n "$WEBCONTROL_PROTOCOL" ];then
            _WEBCONTROL_PROTOCOL="$WEBCONTROL_PROTOCOL"
        fi
        if [ -n "$WEBCONTROL_PORT" ];then
            _WEBCONTROL_PORT="$WEBCONTROL_PORT"
        fi
    fi



    cd /tmp/
    wget --no-check-certificate $_WEBCONTROL_PROTOCOL://127.0.0.1:$_WEBCONTROL_PORT -O ./index.html &> /dev/null 
    
    if [ $? -ne 0 ]; then
        echo "Error: Web control is not functional"
        ERROR=1
    fi
    
    # Pick up a random thing from a valid html to check if it is proper
    grep -nr username ./index.html &> /dev/null
    
    if [ $? -ne 0 ]; then
        echo "Error: Web control is serving an invalid page"
        ERROR=1
    fi
fi

SYSINFO="/opt/Avaya/system_info/system_info.txt"
if [ -f $SYSINFO ]; then 
    grep "MATERIAL_CODE=[0-9]" $SYSINFO 
    if [ $? -ne 0 ]; then
        echo "Error: MATERIAL_CODE not found inside $SYSINFO"
    fi
fi
if [ $ERROR -ne 0 ]; then
    echo "Archiving logs"
    mkdir -p /var/www/html/logs
    rm -f /var/www/html/logs/*
    /opt/Avaya/scripts/logs_archive.sh "noSEC" &> /dev/null

    IP=`LANGUAGE=en_US.UTF-8 ifconfig eth0 | grep "inet" | tr -s ' ' | cut -d ' ' -f3 | grep -o "[0-9\.]*"`

    cd /var/www/html/logs
    for i in *; do
        echo "Please report log archive: http://$IP:8000/logs/$i"
    done
else
    echo "Install is ok"
fi
