#!/bin/bash


SCRIPTS_PATH=/opt/Avaya/scripts
. ${SCRIPTS_PATH}/config $1
LOCKFILE="/tmp/clish_$1.LOCK"
LOCKFILE_ALL="/tmp/clish_all.LOCK"

TEMP_DIR=/tmp/clish_$1

log_file="/home/webcontrol/upgrade_log.txt"

download_rpms=()
rpm_dir=""

function get_rpms()
{
	section="apps"
	repo_list=(`sed -n -e  "
	          /$section/ {
		       N;N
		       s/.*baseurl *= *\(.*\)/\1/p
			}" ${UPDATES_FILE}`)
    repo=${repo_list[0]}
	
    local_repo=`echo $repo | sed -n -e "s/file:\/\/\(.*\)/\1/p"`

    if [ -d "$local_repo" ];then
        rpm_dir=$local_repo
        download_rpms=(`ls "$local_repo" | grep "${rpm_names[0]}-.*$2.*.rpm"`)
    else
        if [ -d "$TEMP_DIR" ];then
            rm -rf "$TEMP_DIR"
        fi
        mkdir "$TEMP_DIR"
        pushd "$TEMP_DIR"

        wget $repo -q -O index.html

        if [ ! -f index.html ];then
            echo "wget error"
            popd
            rm -rf "$TEMP_DIR"
            exit 3
        fi
        rpm_dir="$TEMP_DIR/rpms"

        download_rpms=(`grep -oi href=\"[^\"]*.rpm\" ./index.html | xargs -i expr match {} "[hH][rR][eE][fF]=.*\(${rpm_names[0]}-.*$2.*.rpm\)"`)
	
        if [ ${#download_rpms[@]} -eq 0 ];then
            echo "This software version is not available in the repository"
            popd
            rm -rf "$TEMP_DIR"
            exit 4
        fi
        mkdir rpms
        pushd rpms
        for ((i=0;i<${#download_rpms[@]};i++)); do
            echo ${download_rpms[${i}]}
            link="$repo/${download_rpms[${i}]}"
            wget $link -q
            if [ ! -f ${download_rpms[${i}]} ];then
                echo "Error getting file from remote repository"
                popd
                popd
                rm -rf "$TEMP_DIR"
                exit 5
            fi
        done
        popd
        popd
    fi
}

if [ ! -e ${UPDATES_FILE} ];then 
		echo "Please setup an os repository first"
		exit 1
fi

if ! lockfile -1 -r7 "$LOCKFILE";then
    echo "Resource is temporary busy.Please try again"
    exit 1
fi
if ! lockfile -1 -r7 "$LOCKFILE_ALL";then
    echo "Resource is temporary busy.Please try again"
    exit 1
fi

if [ "$1" == "os" ];then
	sudo yum update
	if [ "$?" -ne "0" ]; then
		echo "Error upgrading system"
        rm -rf "$LOCKFILE"
        rm -rf "$LOCKFILE_ALL"
  		exit 1
    fi
		
    echo `date` > ${LAST_UPDATE_FILE}
	rm -rf "$LOCKFILE"
    rm -rf "$LOCKFILE_ALL"
else
	current_vers=`rpm -q ${rpm_names[0]} | sed -n -e "s/${rpm_names[0]}-\(.*\)/\1/p"`
	if [ "$current_vers" == "$2" ];then
		echo "New version is equal to the installed one; nothing to do"
        rm -rf "$LOCKFILE"
        rm -rf "$LOCKFILE_ALL"
		exit 0
	fi

	get_rpms $1 $2
    if [ "$?" -ne "0" ]; then
        rm -rf "$LOCKFILE"
        rm -rf "$LOCKFILE_ALL"
        exit 1
    fi

	echo "This operation will terminate the process. Continue?"
	read response

	if [ "$response" == "n" ];then
		echo "Aborting update process"
		rm -rf "$LOCKFILE"
        rm -rf "$LOCKFILE_ALL"
		exit 2
	fi

	nohup ${SCRIPTS_PATH}/update_process.sh $1 $2 $download_rpms $rpm_dir > $log_file &
fi
