#!/bin/bash
# Update hosts file when ip address changes
# Usage: $0
HOSTNAME=`hostname`
ETH0_IP=`ip addr show eth0 | grep "\<inet\>" | awk '{ print $2 }' | awk -F "/" '{ print $1 }'`
HOSTS_CONFIG_FILE=/etc/hosts
if [ -f /opt/Avaya/APC_release ]; then
    ETH0_IP=`ip addr show eth0.1 | grep "\<inet\>" | awk '{ print $2 }' | awk -F "/" '{ print $1 }'`
fi

if grep -q "^127.0.0.1" $HOSTS_CONFIG_FILE; then
    sed "s/127.0.0.1.*/127.0.0.1\t\tlocalhost/g" -i $HOSTS_CONFIG_FILE
else
    echo -e "127.0.0.1\t\tlocalhost" >> $HOSTS_CONFIG_FILE
fi

if [ ! -z "$ETH0_IP" ]; then
    if grep -qe ".*$HOSTNAME$" $HOSTS_CONFIG_FILE; then
        # already set, removing the line and add again
        sed "/.*$HOSTNAME.*/d" -i $HOSTS_CONFIG_FILE
        echo -e "$ETH0_IP\t\t$HOSTNAME" >> $HOSTS_CONFIG_FILE
    else
        echo -e "$ETH0_IP\t\t$HOSTNAME" >> $HOSTS_CONFIG_FILE
    fi
else 
    echo "Couldn't set hosts file, interface is down ..."
fi


