#!/bin/sh

i=0
for arg in "$@" ; do
	recList[i]=$arg
        i=$i+1
done

STARTTIME=$(date +%s)

## Validate Arguments:
if [ $# -lt 1 ]; then
    echo "Missing arguments. At least 1 Record ID needs to be provided to delete."
	echo "Usage : $0 <Record ID 1>...<Record ID N>"
    exit 1
fi

# Disable Trigger for faster delete
su -l postgres -c "psql -d mediamanager -c \"ALTER TABLE mediarecords DISABLE TRIGGER ALL;\"";
su -l postgres -c "psql -d mediamanager -c \"ALTER TABLE mediainfo DISABLE TRIGGER ALL;\"";
su -l postgres -c "psql -d mediamanager -c \"ALTER TABLE mediainfocc DISABLE TRIGGER ALL;\"";

for recordid in "${recList[@]}"
	do
	#recordid=$1
	echo "Delete Record ID $recordid"
	

	getIDs=$(su -l postgres -c "psql -A -t -U postgres -h localhost -d mediamanager -c \"select mediainfo_id, mediainfocc_id, archivedrec_archiveid from mediarecords where recordid='$recordid'\"";)

	echo "Get ID $getIDs"
	IFS='|'
	i=0

	for var in $getIDs
	do
		arr[i]=$var
		i=$i+1
	done

	mediaInfoID=${arr[0]}
	mediaInfoCCID=${arr[1]}
	archiveID=${arr[2]}

	if su -l postgres -c "psql -U postgres -h localhost -d mediamanager -c \"delete from mediarecords where recordid='$recordid'\"";then
		if [ ! -z "$mediaInfoID" ]
			then
			su -l postgres -c "psql -U postgres -h localhost -d mediamanager -c \"delete from mediainfo where id='$mediaInfoID'\"";
		fi

		if [ ! -z "$mediaInfoCCID" ]
			then
			su -l postgres -c "psql -U postgres -h localhost -d mediamanager -c \"delete from mediainfocc where id='$mediaInfoCCID'\"";
		fi

		if [ ! -z "$archiveID" ]
			then
					su -l postgres -c "psql -U postgres -h localhost -d mediamanager -c \"delete from archivedrecords where archiveid='$archiveID'\"";
			fi

	fi

	## Get Exit status
	Delete_Status="${?}"
	echo "Delete Record Exit status - ${Delete_Status}"

	if [ "$Delete_Status" == 5 ] ; then
		echo "Record Deletion failed."		
	elif [ "$Delete_Status" == 0 ] ; then	
		echo "Record Deletion Succeeded. Exit Status $Delete_Status"
	else
		echo "Record Deletion failed. Exit Status $Delete_Status"
	fi

done

# Enable Trigger again.
su -l postgres -c "psql -d mediamanager -c \"ALTER TABLE mediarecords ENABLE TRIGGER ALL;\"";
su -l postgres -c "psql -d mediamanager -c \"ALTER TABLE mediainfo ENABLE TRIGGER ALL;\"";
su -l postgres -c "psql -d mediamanager -c \"ALTER TABLE mediainfocc ENABLE TRIGGER ALL;\"";

ENDTIME=$(date +%s)
echo "Deletion Process took $(($ENDTIME - $STARTTIME)) seconds."
