#!/bin/bash

resources_file=/opt/Avaya/.resources.txt
if [ ! -e $resources_file ]; then
    echo 'Resources file missing.'
    exit
fi

ipoffice_config_file=/etc/sysconfig/ipoffice
if [ ! -e $ipoffice_config_file ]; then
    echo 'IPOffice config file missing.'
    exit
fi

config_file=/usr/Avaya/MediaServer/config/softMediaServer.cfg
if [ ! -e $config_file ]; then
    echo 'Media Server config file missing.'
    exit
fi

# Get system ram capacity
ram_capacity=`awk -F'=' '/RAM_MB/{print $NF;}' $resources_file`
# Get ipoffice mode
ipoffice_mode=`awk -F'=' '/export IPOFFICE_BE_MODE/{print $NF;}' $ipoffice_config_file`

# Primary system - OneX installed
if [ "\"Primary\"" = "$ipoffice_mode" ]; then
    if [ $ram_capacity -lt 3000 ]; then
        max_users=50
    elif [ $ram_capacity -lt 4000 ]; then
        max_users=200
    elif [ $ram_capacity -lt 5000 ]; then
        max_users=500
    elif [ $ram_capacity -lt 7000 ]; then
        max_users=1000
    elif [ $ram_capacity -lt 12000 ]; then
        max_users=1500
    elif [ $ram_capacity -lt 16000 ]; then
        max_users=2500
    else
        max_users=3500
    fi
else
    if [ $ram_capacity -lt 3000 ]; then
        max_users=1000
    elif [ $ram_capacity -lt 4000 ]; then
        max_users=1500
    elif [ $ram_capacity -lt 12000 ]; then
        max_users=2500
    else
        max_users=3500
    fi
fi

if [ $max_users -lt 1000 ]; then
    max_channels=$((20 + 2 * max_users))
else
    max_channels=$((1020 + max_users))
fi

# Change jade max channels config
sed -i "s/\(maxChannels=\).*$/\1$max_channels/" $config_file

# Change ipoffice max endpoints
max_endpoints=`grep "export IPOFFICE_MAX_NUM_ENDPOINTS" $ipoffice_config_file`

if [ -z "$max_endpoints" ]; then
    echo "export IPOFFICE_MAX_NUM_ENDPOINTS="$max_channels >> $ipoffice_config_file
else
    sed -i "s/\(export IPOFFICE_MAX_NUM_ENDPOINTS=\).*$/\1$max_channels/" $ipoffice_config_file
fi

exit 0
