#!/bin/bash

. /opt/Avaya/scripts/config_files/apps_logging_config

COREPATH=${APPS_MISC_COREDUMPS_DIR_NAME}
MAXFILES=64
LOCK_FILE=/var/lock/core_cleaner.LOCK
SIGUSR1_TRAPPED=false
CLEANER_RUNNING=false
CORE_ARCHIVED=false

trap 'archive_ipoffice_core' SIGUSR1

archive_ipoffice_core() {
    local APP="ipoffice"
    local BIN="/usr/bin/ipoffice"
    local OUTPUT="/tmp/backtrace.out"
    local IPO_OUTPUT=""
    local COREARCH_DIR="/tmp/avaya/coredumps"
    if [ ! -d $COREARCH_DIR ]; then
        mkdir -p $COREARCH_DIR
    fi
    if $CLEANER_RUNNING
    then
        SIGUSR1_TRAPPED=true
    else
        SIGUSR1_TRAPPED=false
        CORE_ARCHIVED=true
        (
            flock -x 200
            files=$(ls /var/www/html/coredumps/core.ipoffice* 2> /dev/null | wc -l)
            if [ "$files" != "0" ]; then
                echo bt > /tmp/gdb_cmd
                cwd=`pwd`
                saveIFS="$IFS"
                if [ -f /opt/Avaya/ABE_release ]; then
                    RELEASE_VER=`cat /opt/Avaya/ABE_release | grep ABE_VERSION | cut -d';' -f1 | sed 's/[\\]//g' | sed 's/(/./g' | sed 's/)//g'`
                elif [ -f /opt/Avaya/APPL_release ]; then
                    RELEASE_VER=`cat /opt/Avaya/APPL_release | grep ABE_VERSION | cut -d';' -f1 | sed 's/[\\]//g' | sed 's/(/./g' | sed 's/)//g'`
                elif [ -f /opt/Avaya/APC_release ]; then
                    RELEASE_VER=`cat /opt/Avaya/APC_release | grep APC_VERSION | cut -d';' -f1 | sed 's/[\\]//g' | sed 's/(/./g' | sed 's/)//g'`
                fi
                IPOFFICE_BIN_VER=`rpm -qf /etc/init.d/ipoffice --qf "%{VERSION}-%{RELEASE}\n" | cut -d. -f1-3`
                IPO_VER="IPOFFICE_VERSION=${IPOFFICE_BIN_VER}"
                IPO_MD5SUM=`md5sum $BIN`
                MD5SUM_ONLY=`echo $IPO_MD5SUM | cut -d' ' -f1`
                cd /var/www/html/coredumps
                rpm -q $APP > info.txt
                IFS=$saveIFS
                for i in core.$APP.*
                do
                    echo "i: $i"
                    if [ ! -e $i ]
                    then
                        echo "No $APP coredumps."
                        continue
                    fi
                    CORE_ARCH_NAME="arc_$i.tar.gz"
                    if [ ! -f $CORE_ARCH_NAME ]; then
                        while fuser -s $i
                        do
                            sleep 1
                        done
                        gdb --batch $BIN $i -x /tmp/gdb_cmd > $OUTPUT
                        if [ -f /opt/Avaya/ABG_release ]; then
                            ARCH_NAME_PATH="$COREARCH_DIR""/arc_${i//ipoffice/B5800}.tar.gz"
                            ARCH_NAME="arc_${i//ipoffice/B5800}.tar.gz"
                            tar -czf $ARCH_NAME_PATH $i info.txt
                            chmod 644 $ARCH_NAME_PATH
                        else
                            if [ ! -z "${RELEASE_VER}" ]; then
                                IFS=$'\n'
                                GDB_TRACE=($(<$OUTPUT))
                                SELECT_TRACE=0
                                STACK_TRACE=""
                                IFS=$saveIFS
                                for j in "${GDB_TRACE[@]}"
                                do
                                    if [ "$SELECT_TRACE" != "0" ]; then
                                        ((SELECT_TRACE++))
                                    fi
                                    TERMINATION_INFO=`echo $j | grep "Program terminated"`
                                    if [ ! -z "${TERMINATION_INFO}" ]; then
                                        CORE_INFO=$TERMINATION_INFO
                                        ((SELECT_TRACE++))
                                    fi
                                    if [ $SELECT_TRACE -gt 2 ]; then
                                        TRACE=(${j// / })
                                        FADDR=""
                                        for x in ${TRACE[@]}
                                        do
                                            if [[ "$x" == 0x* ]]; then
                                                if [ -z "$FADDR" ]; then
                                                    FADDR=$x
                                                    break
                                                fi
                                            fi
                                        done
                                        if [ ! -z "$FADDR" ]; then
                                            if [ -z "${STACK_TRACE}" ]; then
                                                STACK_TRACE="${FADDR}"
                                            else
                                                STACK_TRACE="${STACK_TRACE}, ${FADDR}"
                                            fi
                                        fi
                                    fi
                                done
                                CORE_PID="${i//[^0-9]/}"
                            fi
                            echo "${RELEASE_VER}" > profile.ipoffice_core.$CORE_PID.txt
                            echo "${IPO_VER}" >> profile.ipoffice_core.$CORE_PID.txt
                            MD5SUM_IPOFFICE="MD5SUM=$MD5SUM_ONLY"
                            echo "${MD5SUM_IPOFFICE}" >> profile.ipoffice_core.$CORE_PID.txt
                            CORE_DATE="CORE_DATE=""`ls -al $i|tr -s \ |cut -d" " -f6`""_""`ls -al $i|tr -s \ |cut -d" " -f7`""_""`ls -al $i|tr -s \ |cut -d" " -f8`"
                            echo "${CORE_DATE}" >> profile.ipoffice_core.$CORE_PID.txt
                            STATUS="TERMINATION_STATUS=$CORE_INFO"
                            echo "${STATUS}" >> profile.ipoffice_core.$CORE_PID.txt
                            TRACE_MESSAGE="STACK_TRACE=$STACK_TRACE"
                            echo "${TRACE_MESSAGE}" >> profile.ipoffice_core.$CORE_PID.txt
                            ARCH_NAME_PATH="$COREARCH_DIR""/arc_$i.tar.gz"
                            ARCH_NAME="arc_$i.tar.gz"
                            IPO_OUTPUT="/tmp/backtrace_""$CORE_PID"".out"
                            echo "${CORE_PID}" > $IPO_OUTPUT
                            tar -czf $ARCH_NAME_PATH $i info.txt
                            chmod 644 $ARCH_NAME_PATH
                        fi
                        mv $ARCH_NAME_PATH $ARCH_NAME
                    fi
                done
                rm -f info.txt
                IFS=$saveIFS
                cd $cwd
                rm -f /tmp/gdb_cmd
            fi
            flock -u 200
        ) 200>$LOCK_FILE
    fi
}

if [ -d $COREPATH ]
then
cd $COREPATH
CLEANER_RUNNING=true
archive_ipoffice_core
CLEANER_RUNNING=false
while true;
do
    CLEANER_RUNNING=true
    for i in core.{acmsComms,acmsdispatcher,aSoftMS,msmlCon,initacms}.*
    do
        if [ -f "$i" ];then
            if fuser -s "$i"; then
                sleep 1
            else
                tar -czf "arc_$i.tar.gz" "$i" 
                rm -f "$i"
            fi
        fi
    done
    if $CORE_ARCHIVED
    then
        CORE_ARCHIVED=false
        # cooldown for 60, we are running hot :)
        sleep 60
        for i in core.ipoffice.*
        do
            if [ -f "$i" ]; then
                if fuser -s "$i"; then
                    sleep 1
                else
                    CORE_ARCH_NAME="arc_$i.tar.gz"
                    if [ -f "$CORE_ARCH_NAME" ]; then
                        rm -f "$i"
                    else
                        archive_ipoffice_core
                    fi
                fi
            fi
        done
    fi
    #deletes older core archives if there are more than 64 archives
    DELNO=$((`ls -1 arc_core*.tar.gz 2> /dev/null | wc -l`-$MAXFILES))
    if [ $DELNO -gt 0 ]; then
       rm -f `ls -1t arc_core*.tar.gz | head -n $(($DELNO))`
    fi
    CLEANER_RUNNING=false
    if $SIGUSR1_TRAPPED
    then
        archive_ipoffice_core
    fi
    chmod 644 *
    # we can be interrupted here - sleeping for half an hour
    sleep 1800 & wait ${!}
done
fi

