#!/usr/bin/env bash

if (($# != 0))
then
  echo Wrong number of parameters.
  echo Usage: createDST.sh
fi
timezone=`date --rfc-3339='seconds'`
if [ "`expr index "$timezone" '\+'`" != "0" ]
then
    sep=+
    sign=-
  else
    sep=-
fi
    timezone=${timezone##*$sep}
#Hours difference between UTC and localtime
timezone_h=${timezone%:*}

#skip 0 character from the beginning of string
timezone_h=${timezone_h#0}

#Minutes difference between UTC and localtime
timezone_m=${timezone#*:}

#skip 0 character from the beginning of string
timezone_m=${timezone_m#0}

#Get UTC offset in seconds
((timezone = 3600 * timezone_h + 60 * timezone_m))
#Create dst.out
echo $sign$timezone > /tmp/dst.out
#Set TZ env variable value, because we might use glibc function tzset().
export TZ=:/etc/localtime
