#!/bin/bash
percentage=2
hdd_total=`df --total /var/log/ | grep "total" | tr -s ' ' | cut -d' ' -f2`
max_usage=`echo $((($percentage * $hdd_total)/100)) | bc -l`

function compute_syslogtotal(){
    du -s /var/log/rsyslog | cut -f1 | paste -sd+ | bc
}

deleted=0
while [ "$(compute_syslogtotal)" -ge "$max_usage" ]; do
    list_days=(`find /var/log/rsyslog/*/* -type d | cut -d'/' -f6 | sort -u`)
    folders_delete=(`find /var/log/rsyslog/ -type d -name "${list_days[0]}"`)
    for path in ${folders_delete[@]}; do
        rm -rf $path
        deleted=1
    done
done

if [ "$deleted" ==  "1" ]; then
    /sbin/service rsyslog restart
fi
