#!/bin/bash

usage="Usage:\n
$0 [-h] [-p n] [-i n] [ -g]\n
Polls at regular intervals the number of open file descriptors for ipoffice. If the number exceeds a threshold it will print all the open resources for ipoffice in /opt/Avaya/ipoffice/fd_warn_log.<pidofipoffice>.txt. \n
After the treshold is exceeded it will only print again, overwriting the file if the number of fd is incresed ( at the end only the maximum fd at the polling interval will remain in the log file).\n 
Parameters:
	-h  prints this message
	-p [MANDATORY] the pid of ipoffice; when this pid will not exist or not belong to ipoffice the script will be terminated
	-i [optional] polling interval; default 60 [seconds]
	-g [optional] the threshold as percentage; default 80 meaning 80% of the maximum allowed fds"

polling_interval=60
percentage=80
while getopts :hp:i:g: option
do
	case "${option}" in
		h) echo "$usage" 
		exit;;
		p) ipo_pid=${OPTARG};;
		i) polling_interval=${OPTARG};;
		g) percetage=${OPTARG};;		
	esac
done

if [ -z "$ipo_pid" ];
then
	echo "===Error: pid not valid. see help with -h option==="
	echo "$usage"
	exit
fi

FD_WARN_LOG="/opt/ipoffice/fd_warn_log.$ipo_pid.txt"

max_allowed_fds=$(ulimit -HSn)
warn_threshold=$(($max_allowed_fds * $percentage / 100))
max_observed_fds=0

cd /proc/$ipo_pid/fd
while [ "$ipo_pid" == "$(pidof ipoffice)" ]
do
	fd_no=$(ls -l | wc -l)	
	
	if [[ $fd_no -gt $warn_threshold && $fd_no -gt $max_observed_fds ]];
	then
		lsof -p $ipo_pid > $FD_WARN_LOG
		echo "Log printed on $(date). File descriptors in use at that moment: $fd_no. The $percentage % of $max_allowed_fds threshold was exceeded." >> $FD_WARN_LOG
		max_observed_fds=$fd_no
	fi
	
	sleep $polling_interval
done
