#!/bin/bash
FREE_SPACE=0
# we are going to take into account only free space availlable on /dev/sda 
# reported by the parted utility in MB 

FREE_SPACE=`echo -e "unit MB\n print free\n quit\n" | parted /dev/sda | grep "Free Space$" | tail -n 1 | awk '{ print $3 }' | grep -o '[0-9].[0-9]*'`

# remove the fractional part (e.g 1.02 to 1 )
FREE_SPACE=$( printf "%.0f" $FREE_SPACE )

# define the lower limit for unallocated free space in MB
LIMIT=100

if [ $FREE_SPACE -lt $LIMIT ]; then
    #There is not enough unalocated free space availlable.
    FREE_SPACE=0
fi

# free space in MB
echo "$FREE_SPACE"

