#!/bin/bash

path="/var/log"

LOG_FILE="top_processes.log"
PATH_LOG_FILE=${path}/$LOG_FILE

TIME=0
SLEEP=1
INTERVAL=1
NUMBER_OF_PROCESSES=15
#execute top command every $SLEEP second for the first 10 seconds 
#after 10 seconds top command will be executed at $((SLEEP+INTERVAL)) seconds
#after 60 seconds top command will be executed at 60 seconds

CONDITION="true"
if [ -f /opt/Avaya/APC_release ]; then
SLEEP=60
fi


while [ "$CONDITION" == "true" ]; 
do
        trap 'CONDITION="false"' USR1
        top -d 1 -b -n 2 | grep 'top - ' -A$((6 + $NUMBER_OF_PROCESSES)) >>${PATH_LOG_FILE}
        sleep $SLEEP &
	wait
        TIME=$((TIME + SLEEP))

        if [ $TIME -gt 10 ] && [ $SLEEP -lt 60 ]
        then
                SLEEP=$((SLEEP+INTERVAL))
        fi
done

