#!/bin/bash
prodname=`dmidecode -s system-product-name`

if [[ ! "$prodname" =~ [a-Z] ]]; then
    str1=`dmidecode --type 11 | grep "String 5"` 
    str2=`dmidecode --type 11 | grep "String 4"`
    str3=`dmidecode --type 11 | grep "String 3"`
    if [[ "$str1" =~ "8122" || "$str2" =~ "8122" ]]; then #R620
        echo "PowerEdge R620"
    elif [[ "$str1" =~ "8109" || "$str2" =~ "8109" ]]; then #R210
        echo "PowerEdge R210"
    elif [[ "$str1" =~ "8134" || "$str2" =~ "8134" || "$str1" =~ "8135" || "$str2" =~ "8135" ]]; then 
        echo "PowerEdge R630"
    elif [[ "$str3" =~ "06A5" ]]; then
        echo "PowerEdge R230"
    elif [[ "$str3" =~ "0716" ]]; then
        echo "PowerEdge R640"
    else
        echo "$prodname"
    fi
else
    echo "$prodname"
fi
