#!/bin/bash
if [ -f /etc/sysconfig/onexportal ]; then
     . /etc/sysconfig/onexportal
fi

log() {
    if [ -n $LOG_FILE ]
    then
        echo "[$(date)] $1" >> $LOG_FILE
    fi
    # echo "[$(date)] $1"
}
LOG_DIR="/opt/Avaya/scripts/logs"
mkdir -p $LOG_DIR
LOG_FILE=$LOG_DIR/keystore.log
touch $LOG_FILE
keystore_path="/opt/Avaya/oneXportal/openfire/resources/security"

if [ ! -d $keystore_path ]; then
    echo "$keystore_path does not exist" >> $LOG_FILE
    exit
fi

# one cannot import a pem formated certificate into a java keystore. Need to convert pem file into a PKCS12 keystore first
input_pem_file="/opt/Avaya/certs/server.pem"
input_chain_file="/opt/Avaya/certs/ca/chain.pem"
output_p12_file="$keystore_path/keystore.p12"
if [ -f $input_pem_file ]; then
    if [ -f $input_chain_file ]; then
		log "converting PEM to pkcs12 (including chain)"
        openssl pkcs12 -export -out $output_p12_file -inkey $input_pem_file -in $input_pem_file -certfile $input_chain_file -passout pass:changeit
    else
		log "converting PEM to pkcs12 (no chain)"
        openssl pkcs12 -export -out $output_p12_file -inkey $input_pem_file -in $input_pem_file -passout pass:changeit
    fi
else
    log "input_pem does not exist at ${input_pem_file}"
fi

# keytool is part of the Java JVM set of tools
# the keypassword in the keystore must be the same as the keystore password itself (changeit). The Java JRE assumes this is the case.
keytool_path="$JAVA_HOME/bin/keytool"
if [ -f $keytool_path ]; then

   log "removing onex alias from keystore "$keystore_path/keystore
   $keytool_path -delete -alias onex -keystore $keystore_path/keystore -storepass changeit &> /dev/null

   alias=`$keytool_path -list -v -keystore $keystore_path/keystore -storepass changeit | grep "_rsa" | awk '{print $3}'`
   log "removing alias=$alias from keystore $keystore_path/keystore"
   $keytool_path -delete -alias $alias -keystore $keystore_path/keystore -storepass changeit &> /dev/null
   
   log "importing into openfire keystore output_p12_file"
   $keytool_path -importkeystore -destkeystore $keystore_path/keystore -srcstoretype PKCS12 -srckeystore $output_p12_file -srcstorepass changeit -deststorepass changeit -srckeypass changeit -srcalias 1 -destalias onex -noprompt &> /dev/null
   
   chown onexp:onexp $keystore_path/keystore
   chown onexp:onexp $keystore_path/keystore.p12
   chmod 755 $keystore_path/keystore
else
    echo "java path does not exist" >> $LOG_FILE
fi


# ############## certificate to be used by one-X desktop clients ##############
# make a backup of current certificate
if [ -f $ONEX_PATH/apache-tomcat/webapps/pa.bin ]; then
	mv -f $ONEX_PATH/apache-tomcat/webapps/pa.bin $ONEX_PATH/apache-tomcat/webapps/pa_bin.backup
else
	echo "pa.bin not present"
fi

# remove existing pkcs12 certificate if any.
rm -f $ONEX_PATH/apache-tomcat/webapps/pa.12

#import cert in pkcs12 certificate keystore
if [ -f $input_pem_file ]; then
    if [ -f $input_chain_file ]; then
        openssl pkcs12 -export -out $ONEX_PATH/apache-tomcat/webapps/pa.12 -inkey $input_pem_file -in $input_pem_file -certfile $input_chain_file -passout pass:admin@12345
    else
        openssl pkcs12 -export -out $ONEX_PATH/apache-tomcat/webapps/pa.12 -inkey $input_pem_file -in $input_pem_file -passout pass:admin@12345
    fi
else 
    echo "input_pem does not exist" >> $LOG_FILE
fi

# the keypassword in the keystore must be the same as the keystore password itself (admin@12345). The Java JRE assumes this is the case.
keytool_path="$JAVA_HOME/bin/keytool"
if [ -f $keytool_path ]; then
   $keytool_path -importkeystore -destkeystore $ONEX_PATH/apache-tomcat/webapps/pa.bin -srcstoretype PKCS12 -srckeystore $ONEX_PATH/apache-tomcat/webapps/pa.12 -srcstorepass admin@12345 -deststorepass admin@12345 -srckeypass admin@12345 -srcalias 1 -destalias onex -noprompt &> /dev/null
else
    echo "java path does not exist" >> $LOG_FILE
fi

chmod 644 $ONEX_PATH/apache-tomcat/webapps/pa.bin $output_p12_file
chown onexp:onexp $ONEX_PATH/apache-tomcat/webapps/pa.bin

#cleanup - remove the unnecessary file.
rm -f $ONEX_PATH/apache-tomcat/webapps/pa_bin.backup

