#!/bin/bash

if [ -f /etc/sysconfig/csipo ]; then
     . /etc/sysconfig/csipo
fi
if [ -f /etc/sysconfig/webcontrol ]; then
     . /etc/sysconfig/webcontrol
fi

keystore_path="/opt/witness/keystore"
if [ ! -d $keystore_path ]; then
    echo "$keystore_path does not exist" >> $WEBCONTROL_LOG_DIR/api.log
    exit
fi

avaya_certs_path="/opt/Avaya/certs/"
input_pem_file="$avaya_certs_path/server.pem"
input_chain_file="$avaya_certs_path/ca/chain.pem"
output_p12_file="$keystore_path/keystore.p12"
java_keystore="$keystore_path/keystore.jks"

if [ -f $input_pem_file ]; then
    openssl pkcs12 -export -out $output_p12_file -inkey $input_pem_file -in $input_pem_file -passout pass:Contact5tor3
else
    echo "input_pem does not exist at ${input_pem_file}" >> /opt/webcontrol/log/api.log
fi

if [ -f $java_keystore ]; then
    mv -f $java_keystore $java_keystore.backup
else
    echo "keystore.jks not present"
fi

if [ -f $avaya_certs_path/ca/root-ca.pem ]
then
    keytool -import -keystore $java_keystore -alias root -file $avaya_certs_path/ca/root-ca.pem -deststorepass Contact5tor3 -noprompt
fi

if [ -f $input_chain_file ]; then
    index="0"
    csplit -z $input_chain_file '/^-----BEGIN CERTIFICATE-----$/' '{*}' --prefix=$avaya_certs_path/ca/inter > /dev/null
    for cert in `find $avaya_certs_path/ca -maxdepth 1 -name "inter*" | sort`; do
        if [ $index -eq "0" ]; then
            alias="inter"
        else
            alias="inter$index"
        fi

        keytool -import -keystore $java_keystore -alias $alias -file $cert -deststorepass Contact5tor3 -noprompt
        index=$((index+1))
    done
    rm -f $avaya_certs_path/ca/inter*
fi

keytool -importkeystore -destkeystore $java_keystore -srcstoretype PKCS12 -srckeystore $output_p12_file -srcstorepass Contact5tor3 -deststorepass Contact5tor3 -srckeypass Contact5tor3 -srcalias 1 -destalias tomcat -noprompt &> /dev/null

#cleanup - remove the unnecessary files.
rm -f $output_p12_file
rm -f $java_keystore.backup

