
#!/bin/sh

. /opt/Avaya/scripts/config_files/apps_logging_config


####################################################
#
#  empty the log files, but don't remove them, because
#  the applications might not regenerate them
#
#####################################################

function do_empty() {
        # $1 = the file or folder path
        if [ -d $1 -o -f $1 ]; then
                find $1 -type f | xargs truncate --size 0  # truncate may yield failure, but that won't stop the script
        fi
}

set -x

do_empty $WATCHDOG_LOG_PATH_NAME
do_empty $WATCHDOG_TEST_LOG_PATH_NAME

do_empty $WEBCONTROL_LOG_DIR_NAME

do_empty $AUDIT_LOG_PATH_NAME

do_empty $IPOFFICE_SERVICE_LOG_PATH_NAME
do_empty $ISA_LOG_PATH_NAME
do_empty $GEN_CERTS_LOG_PATH_NAME
do_empty $IPOFFICE_LOG_PATH_NAME # not used

do_empty $APC_THERMAL_LOG_DIR_NAME
do_empty $APC_THERMAL_ERROR_LOG_PATH_NAME

do_empty $HEARTBEAT_LOG_DIR_NAME
do_empty $HEARTBEAT_ERROR_LOG_PATH_NAME


# pair with 'logs_archive.sh'
do_empty "/var/log/rsyslog" 
do_empty "/var/log/messages" 
do_empty "/var/log/configure_rsyslog_output.log" 
do_empty `ls /var/log/messages.*`

# from logrotate
do_empty "/var/log/secure" 
do_empty "/var/log/maillog" 
do_empty "/var/log/spooler" 
do_empty "/var/log/boot.log" 
do_empty "/var/log/cron"

# from other apps
do_empty "/var/log/One-X"
do_empty `locate /var/log/rsyslog/127.0.0.1/*/ipovmpro_local0.log`
do_empty "/var/log/OpenFire"

