#!/usr/bin/env bash

if ((`id -u` != 0)) 
then
	echo error: You need to be root to set the Time Zone!
	exit 1
fi

if (($# != 1))
then
	echo usage: setTimeZone timezone
	echo See /usr/share/zoneinfo/
	exit 2
fi

if [ ! -f /usr/share/zoneinfo/$1 ]
then
	echo Time zone must have the form Continent/City, e.g. Europe/Bucharest
	echo See /usr/share/zoneinfo/
	exit 3
fi

scripts_path=/opt/Avaya/scripts
timedatectl set-timezone $1
#Remove old settings
rm -f /etc/localtime
#Point to the new timezone
ln -s /usr/share/zoneinfo/$1 /etc/localtime
#Edit /etc/sysconfig/clock
#gawk -F = \
#     -v tz=\"$1\" \
#     '{
#	     if (index ($1,"#") != 1)
#		{
#			if ($1 == "ZONE")
#				$2=FS tz
#			else
#				$2=FS$2 
#		}
#		print $1$2 > "awk.txt"
#      }' \
#     /etc/sysconfig/clock
#Update /etc/sysconfig/clock
#mv awk.txt /etc/sysconfig/clock
#Remove tmp file
#rm -f awk.txt
#Create file dst.out. It should only contain the UTC offset.
#The UTC offset will contain the DST offset, too (when summer time is in effect).
$scripts_path/createDST.sh
