#!/usr/bin/perl

# Usage:    set_dhcp_ipaddr.pl <intf> [<peerdns>]
# Purpose:  Delete static IP address from network interface <intf> and configure it as DHCP client
# Works on:     CentOS 6.1, CentOS 5.2, CentOS 4.6

use warnings;
use File::Copy;

open(my $fLog, '>>', '/opt/ipoffice/network_changes.log');
my $datestring = localtime();
my $strParam = "";
foreach my $argnum (0 .. $#ARGV) {
  $strParam =  "$strParam $ARGV[$argnum]";
}
print $fLog "$datestring: set_dhcp_ipaddr-> $strParam\n";
close $fLog;

if ($ARGV[0] =~ '\\.')
{
	$interfIdParts = split(".", $ARGV[0]);
	$interfId = $interfIdParts[0];
}
else {
	$interfId = $ARGV[0];
}
my($newHwAddr) = `LANGUAGE=en_US.UTF-8 ifconfig -a $interfId | grep -oE "ether [0-9ABCDEFabcdef:]*" | cut -d' '  -f2`;
$filename1 = "/etc/sysconfig/network-scripts/ifcfg-$ARGV[0]";
$filename2 = "new-ifcfg-$ARGV[0]";
$filename3 = "$filename1.bkup";
$bootproto = "BOOTPROTO=dhcp\n";
$controlled = "NM_CONTROLLED=\"no\"\n";
$device = "DEVICE=\"$ARGV[0]\"\n";
$onboot = "ONBOOT=yes\n";

if ($ARGV[0] =~ '\\.')
{
    $vlan = "VLAN=yes\n";
    $hwaddr = "";
}
else
{
    $vlan = "";
    if ( "$newHwAddr" ne "" )
    {
        $hwaddr = "HWADDR=$newHwAddr\n";
    }
    else
    {
        $hwaddr = "";
    }
}


if ( ! $ARGV[1] eq "") 
{
    $peerdns ="PEERDNS=$ARGV[1]\n";
}
else
{
    $peerdns = "";
}


$cfgFileWasUpdated = 0;
unless (-e $filename1)
{
    $cfgFileWasUpdated = 1;
    if (open(file1, ">$filename1"))
    {
        print file1 <<EOF;
DEVICE=$ARGV[0]
$vlan
BOOTPROTO=dhcp
ONBOOT=yes
$hwaddr
EOF
        close file1;
  }
}

if (open(file1, $filename1) && open(file2, ">$filename2"))
{
    $cfgFileWasUpdated = 1;
    while($line = <file1>)
    {
        if ($line !~ /^\s*((IPADDR)|(NETMASK)|(NETWORK)|(BROADCAST)|(PREFIXLEN)|(GATEWAY))\s*=/)
        {
            if ($line =~ /^\s*DEVICE\s*=/)
            {
                $line = $device;
                $device = '';
            }
			if ($line =~ /^\s*VLAN\s*=/)
            {
                $line = $vlan;
                $vlan = '';
            }
			if ($line =~ /^\s*BOOTPROTO\s*=/)
            {
                $line = $bootproto;
                $bootproto = '';
            }
            elsif ($line =~ /^\s*NM_CONTROLLED\s*=/)
            {
                $line = $controlled;
                $controlled = '';
            }
            elsif ($line =~ /^\s*HWADDR\s*=/)
            {
                $line = $hwaddr;
                $hwaddr = '';
            }
            elsif ($line =~ /^\s*PEERDNS\s*=/)
            {
                $line = $peerdns;
                $peerdns = '';
            }
            elsif ($line =~ /^\s*ONBOOT\s*=/)
            {
                $line = $onboot;
                $onboot = '';
            }
            if ($line ne "\n")
            {
                print file2 $line;
            }
        }
    }
    print file2 $vlan;
    print file2 $device;
    print file2 $bootproto;
    print file2 $hwaddr;
    print file2 $controlled;
    print file2 $onboot;
    print file2 $peerdns;
    close(file1);
    close(file2);
    unlink($filename3);
    move($filename2, $filename1);
}

# Start DHCP client(s)
if (system("service network restart") != 0)
{
    print STDERR "service network restart has failed.\n";
}
system("/opt/Avaya/scripts/update_hostsfile.sh");
