#!/usr/bin/perl

# Usage:    set_static_ipaddr.pl <intf> <ipaddr> <mask> [<peerdns>] [<gateway>] 
# Purpose:  Configure network interface <intf> with static address <ipaddr>, mask <mask> and optional peerdns <peerdns> & gateway <gateway>
# Works on:     CentOS 6.1, CentOS 5.2, CentOS 4.6

use warnings;
use File::Copy;

open(my $fLog, '>>', '/opt/ipoffice/network_changes.log');
my $datestring = localtime();
my $strParam = "";
foreach my $argnum (0 .. $#ARGV) {
  $strParam =  "$strParam $ARGV[$argnum]";
}
print $fLog "$datestring: set_static_ipaddr-> $strParam\n";
close $fLog;

if ($ARGV[0] =~ '(.*)\\.')
{
	$interfId = $1;
}
else {
	$interfId = $ARGV[0];
}

my($newHwAddr) = `LANGUAGE=en_US.UTF-8 ifconfig -a $ARGV[0] | grep -oE "ether [0-9ABCDEFabcdef:]*" | cut -d' ' -f2`;


$filename1 = "/etc/sysconfig/network-scripts/ifcfg-$ARGV[0]";
$filename2 = "new-ifcfg-$ARGV[0]";
$filename3 = "$filename1.bkup";

$networkfile = "/etc/sysconfig/network";
$newnetworkfile = "/etc/sysconfig/network.new";

$bootproto = "BOOTPROTO=none\n";
$ipaddr = "IPADDR=$ARGV[1]\n";
$netmask = "NETMASK=$ARGV[2]\n";
$controlled = "NM_CONTROLLED=\"no\"\n";
$device = "DEVICE=\"$ARGV[0]\"\n";
$onboot = "ONBOOT=yes\n";


if ($ARGV[0] =~ '\\.')
{
    $vlan = "VLAN=yes\n";
    #Do not set HWADDR for vlan interfaces.
    #If hwaddr is set for vlan interface and not physical interface, udev will change the interface name at startup
    $hwaddr = "";
}
else
{
    $vlan = "";


    if ( "$newHwAddr" ne "" )
    {
        $hwaddr = "HWADDR=$newHwAddr\n";
    }
    else
    {
        $hwaddr = "";
    }
}

if ((! $ARGV[3] eq "") && ($ARGV[3] ne "0")) 
{
    $peerdns ="PEERDNS=$ARGV[3]\n";
}
else
{
    $peerdns = "";
}


if ( ! $ARGV[4] eq "") 
{
    $gateway = "GATEWAY=$ARGV[4]\n";
    $gatewaydev = "GATEWAYDEV=$ARGV[0]\n";

}
else
{
    $gateway = "";
    $gatewaydev = "";
}

$setgateway="yes";
if (defined $ARGV[4])
{
    if ( $ARGV[4] eq "0" ) 
    {
        $setgateway ="no"
    }
}
# Process arguments for other config options
my($ip) = "$ARGV[1]";
my($netm) = "$ARGV[2]";

# Convert strings to numbers
my($byte1, $byte2, $byte3, $byte4) = $ip =~ m/([0-9]*)\.([0-9]*)\.([0-9]*)\.([0-9]*)$/;
my($mbyte1, $mbyte2, $mbyte3, $mbyte4) = $netm =~ m/([0-9]*)\.([0-9]*)\.([0-9]*)\.([0-9]*)$/;

$ip_val = ($byte1 << 24) + ($byte2 << 16) + ($byte3 << 8) + $byte4;
$netm_val = ($mbyte1 << 24) + ($mbyte2 << 16) + ($mbyte3 << 8) + $mbyte4;

# Get PREFIXLEN 
my($temp) = sprintf("%32b", $netm_val);

# Strip out ending 0s
$temp =~ s/0*$//g;

$temp = length $temp;

# We have the prefix length
my($prefixlen) = "PREFIXLEN=$temp\n";


# Get BROADCAST: we're handling IPv4, but we use 64-bit Perl so we need to lose 32-bits from the negated netmask value.
$temp = $ip_val | (~$netm_val) & 0xFFFFFFFF;

my($broadcast) = sprintf("BROADCAST=%d.%d.%d.%d\n", ($temp >> 24), ($temp >> 16)&0xFF, ($temp >> 8)&0xFF, ($temp)&0xFF);

# Step 4. Get NETWORK
$temp = $ip_val & $netm_val;

my($network) = sprintf("NETWORK=%d.%d.%d.%d\n", ($temp >> 24), ($temp >> 16)&0xFF, ($temp >> 8)&0xFF, ($temp)&0xFF);


$cfgFileWasUpdated = 0;
unless (-e $filename1)
{
    $cfgFileWasUpdated = 1;
    if (open(file1, ">$filename1"))
    {
		print file1 $vlan;
		print file1 $device;
        print file1 "BOOTPROTO=none\n";
        print file1 $hwaddr;
        print file1 $ipaddr;
        print file1 $netmask;
        print file1 $network;
        print file1 $onboot;
        close file1;
  }
}

if (open(file1, $filename1) && open(file2, ">$filename2"))
{
    $cfgFileWasUpdated = 1;
    while($line = <file1>)
    {
        if ($line =~ /^\s*VLAN\s*=/)
        {
            $line = $vlan;
            $vlan = '';
        }
		if ($line =~ /^\s*DEVICE\s*=/)
        {
            $line = $device;
            $device = '';
        }
		if ($line =~ /^\s*BOOTPROTO\s*=/)
        {
            $line = $bootproto;
            $bootproto = '';
        }
        elsif ($line =~ /^\s*IPADDR\s*=/)
        {
            $line = $ipaddr;
            $ipaddr = '';
        }
        elsif ($line =~ /^\s*NETMASK\s*=/)
        {
            $line = $netmask;
            $netmask = '';
        }
        elsif ($line =~ /^\s*BROADCAST\s*=/)
        {
            $line = $broadcast;
            $broadcast = '';
        }
        elsif ($line =~ /^\s*NETWORK\s*=/)
        {
            $line = $network;
            $network = '';
        }
        elsif ($line =~ /^\s*NM_CONTROLLED\s*=/)
        {
             $line = $controlled;
             $controlled = '';
        }
        elsif ($line =~ /^\s*HWADDR\s*=/)
        {
             $line = $hwaddr;
             $hwaddr = '';
        }
        elsif ($line =~ /^\s*GATEWAY\s*=/)
        {        
             $line = '';
        }
        elsif ($line =~ /^\s*PEERDNS\s*=/)
        {        
             $line = $peerdns;
             $peerdns = '';
        }
        elsif ($line =~ /^\s*PREFIX\s*=/)
        {
            $line = '';
        }
        elsif ($line =~ /^\s*PREFIXLEN\s*=/)
        {
            $line = '';
        }
        elsif ($line =~ /^\s*ONBOOT\s*=/)
        {
            $line = $onboot;
            $onboot = '';
        }
        elsif ($line =~ /^\s*DEFROUTE\s*=/)
        {
            $line = "\n";
        }
        
        if ($line ne "\n")
        {
            print file2 $line 
        }
    }

    print file2 $vlan;
    print file2 $device;
	print file2 $bootproto;
	print file2 $hwaddr;
    print file2 $ipaddr;
    print file2 $netmask;
    print file2 $controlled;
    print file2 $onboot;
    print file2 $peerdns;

    close(file1);
    close(file2);
    unlink($filename3);
    move($filename2, $filename1);
}

system("/opt/Avaya/scripts/remove_routes.sh");
if ($cfgFileWasUpdated != 0)
{
    system("/opt/Avaya/scripts/update_hostsfile.sh");
}
if ($cfgFileWasUpdated != 0)
{
    # Restart the network interface
    system("systemctl restart network");
}
if (open(file1, $networkfile) && open(file2, ">$newnetworkfile") && ($setgateway eq "yes"))
{
    system("/opt/Avaya/scripts/add_persistent_route.pl 0.0.0.0 0.0.0.0 $ARGV[4]");
    $cfgFileWasUpdated = 1;
}
chmod 0664, $networkfile;

