#!/usr/bin/perl

# Usage:    set_static_ipaddrv6.pl <intf> <ipaddr> <mask> [<gateway>] - for set ip
# Usage:    set_static_ipaddrv6.pl <intf> del - for delete ip and disable ipv6 
# Purpose:  Configure network interface <intf> with static address <ipaddr>, mask <mask> and optional gateway <gateway>
# Works on:     CentOS 6.1, CentOS 5.2, CentOS 4.6

use warnings;
use File::Copy;

if ($ARGV[0] =~ '(.*)\\.')
{
	$interfId = $1;
}
else {
	$interfId = $ARGV[0];
}


$filename1 = "/etc/sysconfig/network-scripts/ifcfg-$ARGV[0]";
$filename2 = "new-ifcfg-$ARGV[0]";
$filename3 = "$filename1.bkup";

$enable_ipv6 = "NETWORKING_IPV6=yes\n";
$networkfile = "/etc/sysconfig/network";
$newnetworkfile = "/etc/sysconfig/network.new";

$eth_ipv6_module = "net.ipv6.conf.${ARGV[0]}.disable_ipv6";
$modulefile = "/etc/sysctl.conf";
$newmodulefile = "/etc/sysctl.conf.new";

if ( $ARGV[1] eq "del" ) 
{
    $ipv6addr = "";
    $ipv6_init = "";
    $eth_ipv6_module_line = "net.ipv6.conf.${ARGV[0]}.disable_ipv6 = 1\n";
} else 
{
    $ipv6_init = "IPV6INIT=yes\n";
    $ipv6addr = "IPV6ADDR=$ARGV[1]";
    $ipv6addr = "${ipv6addr}/${ARGV[2]}\n";
    $eth_ipv6_module_line = "net.ipv6.conf.${ARGV[0]}.disable_ipv6 = 0\n";
}

if ( ! $ARGV[3] eq "") 
{
    $gateway6 = "IPV6_DEFAULTGW=$ARGV[3]\n";
    $setgateway="yes";
}
else
{
    $setgateway="no";
    $gateway6 = "";
}

$cfgFileWasUpdated = 0;
unless (-e $filename1)
{
    $cfgFileWasUpdated = 1;
    if (open(file1, ">$filename1"))
    {
        print file1 $ipv6addr;
        close file1;
  }
}

if (open(file1, $filename1) && open(file2, ">$filename2"))
{
    $cfgFileWasUpdated = 1;
    while($line = <file1>)
    {
        if ($line =~ /^\s*IPV6ADDR\s*=/)
        {
            $line = $ipv6addr;
            $ipv6addr = '';
        } 
        elsif ($line =~ /^\s*IPV6INIT\s*=/) {
            $line = $ipv6_init;
            $ipv6_init = '';
        }
        
        if ($line ne "\n")
        {
            print file2 $line 
        }
    }

    print file2 $ipv6_init;
    print file2 $ipv6addr;

    close(file1);
    close(file2);
    unlink($filename3);
    move($filename2, $filename1);
}

if (open(file1, $modulefile) && open(file2, ">$newmodulefile"))
{
    while($line = <file1>)
    {
        if ($line =~ $eth_ipv6_module)
        {
            $line = $eth_ipv6_module_line;
            $eth_ipv6_module_line = '';
        }
        print file2 $line;
    }
    print file2 $eth_ipv6_module_line;
    close(file2);
    close(file1);
    move($newmodulefile, $modulefile);
}
    # Restart the network interface
    system("sysctl -p > /dev/null");
    system("ifdown $ARGV[0]");
    system("ifup $ARGV[0]");

if (open(file1, $networkfile) && open(file2, ">$newnetworkfile") && ($setgateway eq "yes"))
{
    while($line = <file1>)
    {
        if ($line =~ /^\s*NETWORKING_IPV6\s*=/)
        {
            $line = $enable_ipv6;
            $enable_ipv6 = '';
        }
        elsif ($line =~ /^\s*IPV6_DEFAULTGW\s*=/)
        {
            $line = $gateway6;
            $gateway6 = '';
        } 

        print file2 $line;
    }
    print file2 $gateway6;
    print file2 $enable_ipv6;
    close(file2);
    close(file1);
    move($newnetworkfile, $networkfile);
}
chmod 0664, $networkfile;
