#!/bin/bash

SCRIPTS_PATH=/opt/Avaya/scripts
OUTPUT_FILE=/tmp/output.$$

. ${SCRIPTS_PATH}/config $1 

#Application status
echo ${delimiter} > ${OUTPUT_FILE}
echo -e "Application status:\n" >> ${OUTPUT_FILE}
${SCRIPTS_PATH}/status.sh $1 >> ${OUTPUT_FILE}
echo -e "\n" >> ${OUTPUT_FILE}

#Application autostart
echo ${delimiter} >> ${OUTPUT_FILE}
for ((i=0;i<${#services[@]};i++)); do
	echo "Autostart for ${display_names[${i}]}" >> ${OUTPUT_FILE}
	startup=`/usr/bin/systemctl list-unit-files | grep ${services[${i}]} | grep "enabled"`
	if [ -z "${startup}" ]; then
		echo "Off" >> ${OUTPUT_FILE}
	else 
		echo "On" >> ${OUTPUT_FILE}
	fi
done

#Version
echo ${delimiter} >> ${OUTPUT_FILE}
for ((i=0;i<${#versions[@]};i++)); do
	echo "Version for ${display_names[${i}]}: ${versions[${i}]}" >> ${OUTPUT_FILE}
done
echo -e "\n" >> ${OUTPUT_FILE}

#Watchdog output for this application
watchdog_alarms >> ${OUTPUT_FILE}

echo ${delimiter} >> ${OUTPUT_FILE}
echo "Press q to quit" >> ${OUTPUT_FILE}
LESSSECURE=1 less ${OUTPUT_FILE}
rm -rf ${OUTPUT_FILE}





