#!/bin/bash

SCRIPTS_PATH=/opt/Avaya/scripts
. ${SCRIPTS_PATH}/config
OUTPUT_FILE=/tmp/output.$$

function display_info()
{
	. ${SCRIPTS_PATH}/config $1	
	for ((i=0;i<${#display_names[@]};i++)); do
		if [ ${#services[@]} -eq 0 ];then
			boot_start="-"
		else
			startup=`/usr/bin/systemctl list-unit-files | grep ${services[${i}]} | grep "enabled"`
			if [ -z "${startup}" ]; then
				boot_start="Off"
			else 
				boot_start="On"
			fi
		fi
		echo -e "Application \n\t ${display_names[${i}]} \n\t Version: ${versions[${i}]} \n\t Boot at startup: $boot_start"
	done
}


echo ${delimiter} > ${OUTPUT_FILE}
echo "Services Repository: " >> ${OUTPUT_FILE}
if [ ! -e ${UPDATES_FILE} ];then 
		echo "-"  >> ${OUTPUT_FILE}
else
	 echo `sed -n "
	      /\[apps\]/ {
	           N;N
		   s/.*baseurl *= *\(.*\)/\n\1\n/p
		}" ${UPDATES_FILE}` >> ${OUTPUT_FILE}

fi
echo "OS Repository: " >> ${OUTPUT_FILE}
if [ ! -e ${UPDATES_FILE} ];then 
		echo "-"  >> ${OUTPUT_FILE}
else
	echo `sed -n "
		/system/ {
			N;N
			s/.*baseurl *= *\(.*\)/\n\1\n/p		
		}" ${UPDATES_FILE}` >> ${OUTPUT_FILE}
fi

echo ${delimiter} >> ${OUTPUT_FILE}

display_info all  >> ${OUTPUT_FILE}
display_info watchdog >> ${OUTPUT_FILE}
display_info cli >> ${OUTPUT_FILE}
display_info cli_commands >> ${OUTPUT_FILE}

echo ${delimiter} >> ${OUTPUT_FILE}
echo "Operating system: `cat /etc/redhat-release`" >> ${OUTPUT_FILE}
echo "Kernel version: `uname -r`" >> ${OUTPUT_FILE}
if [ ! -e ${LAST_UPDATE_FILE} ];then
	echo "Last updated: -" >> ${OUTPUT_FILE}
else
	echo "Last updated: `cat ${LAST_UPDATE_FILE}`" >> ${OUTPUT_FILE}
fi 
 
echo ${delimiter} >> ${OUTPUT_FILE}
echo "Press q to quit" >> ${OUTPUT_FILE}
LESSSECURE=1 less ${OUTPUT_FILE}
rm -rf ${OUTPUT_FILE}
