#!/bin/bash


function display_versions()
{
	for ((i=0;i<${#rpm_names[@]};i++)); do
		echo ${delimiter}
		echo -e "Existing version: \n"

		current_vers=`rpm -q ${rpm_names[${i}]} | sed -n -e "s/${rpm_names[${i}]}-\(.*\)/\1/p"`
		echo ${current_vers} 

		echo ${delimiter}
		echo -e "Available versions for ${rpm_names[${i}]} \n" 
		
		VER=(`sed -n \
			-e "s/.*${rpm_names[${i}]}-\([0-9|\.|\-]*[0-9]\).*/\1\n/p" $1`)
		element_count=${#VER[@]}
		for ((i=0;i<$element_count;i++)); do
			echo -e ${VER[${i}]} "\n"
		done 
	done
	
}

SCRIPTS_PATH=/opt/Avaya/scripts
TEMP_DIR=/tmp/clish_$1
LOCKFILE="/tmp/clish_$1.LOCK"

if ! lockfile -1 -r7 "$LOCKFILE";then
    echo "Resource is temporary busy.Please try again"
    exit 1
fi

if [ "$1" == "os" ];then
    yum list updates
else
	. ${SCRIPTS_PATH}/config $1
	
	if [ ! -e ${UPDATES_FILE} ];then 
		echo "Please setup an application repository first"
	else
        if [ -d "$TEMP_DIR" ];then
            rm -rf "$TEMP_DIR"
        fi
        mkdir "$TEMP_DIR"
        pushd "$TEMP_DIR"

		section="apps"
		repo_list=(`sed -n -e  "
		     /$section/ {
		             N;N
			     s/.*baseurl *= *\(.*\)/\1/p
			    }" ${UPDATES_FILE}`)
					 
        repo=${repo_list[0]}
        local_repo=`echo $repo | sed -n -e "s/file:\/\/\(.*\)/\1/p"`

        if [ -d "$local_repo" ];then
            ls "$local_repo" > index.html
        else
            wget $repo -q -O index.html
            if [ ! -f index.html ];then
                echo "wget error"
                popd
                rm -rf "$TEMP_DIR"
                rm -rf "$LOCKFILE"
                exit 1
            fi
        fi
		
		display_versions ./index.html
		popd
        rm -rf "$TEMP_DIR"
	fi
fi

rm -rf "$LOCKFILE"

