#!/bin/bash
# script that disables/enables ssh authentication based on the presence of a file

REFERRAL_AUTHENTICATION_FILE="/opt/Avaya/.referral_auth"
STARTUP_XML_FILE="/etc/clish/startup.xml"
CLOSE_ACTION="<ACTION builtin=\"clish_close\"\/>"
SEARCH_PATTERN="clish_close"
CLOSE_CONFIG=`cat $STARTUP_XML_FILE | grep $SEARCH_PATTERN`

if [ -f $REFERRAL_AUTHENTICATION_FILE ] 
then
	#refferal authentication file present then login should be allowed 	
	if [ -n "$CLOSE_CONFIG" ]
	then
		#remove restriction if present and add prompt message
		sed -i 's/'"$CLOSE_ACTION"'/<ACTION>echo "Welcome `whoami` it is `date`"<\/ACTION>/g' $STARTUP_XML_FILE 
	fi
else
	#referral authentication file doesn't exist so access should be restricted
	if [ -z "$CLOSE_CONFIG" ]
	then
		#restrict access
		sed -i 's/<ACTION>echo "Welcome `whoami` it is `date`"<\/ACTION>/'"$CLOSE_ACTION"'/g' $STARTUP_XML_FILE
	fi
		 
fi
	
