#!/bin/bash

SCRIPTS_PATH=/opt/Avaya/scripts
. ${SCRIPTS_PATH}/config $1
LOCKFILE="/tmp/clish_$1.LOCK"
LOCKFILE_ALL="/tmp/clish_all.LOCK"
TEMP_DIR=/tmp/clish_$1

download_rpms=$3
rpm_dir=$4
current_vers=`rpm -q ${rpm_names[0]} | sed -n -e "s/${rpm_names[0]}-\(.*\)/\1/p"`
	
j=0
for ((i=0;i<${#services[@]};i++)); do
    if [ ! -z "`sudo systemctl status ${services[${i}]} | grep running`" ];then
        start_services[${j}]=${services[${i}]}
        j=$[$j+1]
    fi
    sudo systemctl stop ${services[${i}]}
    temp=0
    while [ -z "`sudo systemctl stop ${services[${i}]} | grep dead`" -a $temp -lt 15 ];do
        sleep 1
        temp=$[$temp+1]
    done
    if [ $temp -eq 15 ];then
        sudo service ${services[${i}]} forcestop
    fi
done

			
pushd $rpm_dir
current_vers_array=(`echo ${current_vers} | tr '.' ' ' | tr '-' ' ' `)
new_vers_array=(`echo $2 | tr '.' ' ' | tr '-' ' ' `)
			
for ((i=0;i<${#current_vers_array[@]};i++)); do
	if [ ${current_vers_array[${i}]} -lt ${new_vers_array[${i}]} ];then
		type="upgrade"
		break
	elif [ ${current_vers_array[${i}]} -gt ${new_vers_array[${i}]} ];then
		type="downgrade"
		break
	fi
done

if [ "$type" == "upgrade" ];then
	echo "Upgrading..."
	for ((i=0;i<${#download_rpms[@]};i++)); do
		rpmname=${download_rpms[${i}]}
		rpmname=${rpmname%%-*}
		if [ "$rpmname" = "ms" ]; then
		    rpmopt="--nodeps"
		else
		    rpmopt=""
		fi
		sudo rpm -U $rpmopt ${download_rpms[${i}]}
	done
else
	echo "Downgrading..."
	echo ${#download_rpms[@]}
	for ((i=0;i<${#download_rpms[@]};i++)); do
		rpmname=${download_rpms[${i}]}
		rpmname=${rpmname%%-*}
		if [ "$rpmname" = "ms" ]; then
		    rpmopt="--nodeps"
		else
		    rpmopt=""
		fi
		sudo rpm -U $rpmopt --oldpackage ${download_rpms[${i}]}
	done
fi
popd

for ((i=0;i<${#start_services[@]};i++)); do
        sudo systemctl start ${start_services[${i}]}
done

rm -rf "$TEMP_DIR"
rm -rf "$LOCKFILE"
rm -rf "$LOCKFILE_ALL"

