#!/bin/bash

#
# Populate a report file for upgrade ws operation
#

while getopts :f:i:p:o:v:s:t:e:r: option
do
     case "${option}" in
           f) filename=${OPTARG};;
           i) info=${OPTARG};;
           p) pid=${OPTARG};;
           o) operation=${OPTARG};;
           v) version=${OPTARG};;
           s) spkg=${OPTARG};;
           t) sftime=${OPTARG};;
           e) errorevent=${OPTARG};;
           r) rli=${OPTARG};;
           \?) echo "Invalid option: -$OPTARG" >&2
               exit;;
     esac
done

if [ -z "$filename" ]; then
    exit;
fi

exp='^[-~!@#$%^&*+]+[a-zA-Z]*$'

if [[ $filename =~ $exp || $info =~ $exp || $pid =~ $exp || $operation =~ $exp || $version =~ $exp || $spkg =~ $exp || $sftime =~ $exp || $errorevent =~ $exp || $rli =~ $exp ]]; then
    echo "Invalid argument!"
    exit;
fi

# IPOffice server type
# IP Address configured via ipoffice sysconfig file
if [ "$info" == "infoserver" -a -f "$filename" ]; then
    st=$(/bin/cat /etc/sysconfig/ipoffice | grep 'export IPOFFICE_PHYSICAL_DESCR' | cut -d'=' -f2 | sed 's/\"//g')
    echo "Server Type: $st" >> $filename

    ipadd=$(/bin/cat /etc/sysconfig/ipoffice | grep "export IPOFFICE_LAN" | cut -d'=' -f2)
    for intf in $ipadd; do
        if [ -f "/etc/sysconfig/network-scripts/ifcfg-$intf" ]; then
            LAN=$(/sbin/ifconfig $intf | grep "inet" | tr -s ' ' | cut -d ' ' -f3 | grep -o "[0-9\.]*")
            if [ -n "$LAN" ]; then
                if [ "$intf" == "eth0" -o "$intf" == "eth0.1" ]; then
                    lannumber=1
                elif [ "$intf" == "eth1" ]; then
                    lannumber=2
                fi
                echo "IP Address LAN$lannumber: $LAN" >> $filename
            fi
        fi
    done
fi

# Get remote location information(remote ip address and upgade type<web services/dvd>)
if [ -n "$rli" -a -f "$rli" -a -f "$filename" ]; then
    bu=$(/bin/cat ${rli} | grep baseurl | head -n 1)
    utype=$(/bin/echo ${bu} | grep http)
    if [ -n "$utype" ]; then
        utype="Web Services"
    else
        utype=""
    fi
    idx=$(/usr/bin/expr index ${bu} "@")
    bu=${bu:$idx}
    idx=$(/usr/bin/expr index "$bu" ":")
    ipadd=${bu:0:$idx-1}
    echo "Upgrade type: $utype" >> $filename
    echo "Upgrade from: $ipadd" >> $filename
fi

# Get version running for IPOffice server
if [ "$version" == "upgrade" -a -f "$filename" ]; then
    cv=$(/bin/cat /etc/sysconfig/ipoffice | grep 'export IPOFFICE_FULL_VERSION' | cut -d'=' -f2 | sed 's/\"//g')
    echo "Upgraded Server Version: $cv" >> $filename
elif [ "$version" == "prior_upgrade" -a -f "$filename" ]; then
    cv=$(/bin/cat /etc/sysconfig/ipoffice | grep 'export IPOFFICE_FULL_VERSION' | cut -d'=' -f2 | sed 's/\"//g')
    echo "Initial Server Version: $cv" >> $filename
fi

if [ -n "$pid" -a -n "$operation" -a -f "$filename" ]; then
    if [ "$operation" == "1" ]; then
      echo "DownloadID: $pid" >> $filename
    else
      echo "UpgradeID:  $pid" >> $filename
    fi
fi

# When script started/finished to run
if [ -n "$sftime" -a -f "$filename" ]; then
    istime=$(/bin/echo ${sftime} | grep started)
    iftime=$(/bin/echo ${sftime} | grep done)
    if [ -n "$istime" ]; then
        sftime=${sftime/Script started on/Upgrade started:}
        echo "${sftime}" >> $filename
    elif [ -n "$iftime" ]; then
        sftime=${sftime/Script done on/Upgrade completed:}
        echo "${sftime}" >> $filename
    fi
fi

# Size of packages downloaded/upgraded
if [ -n "$spkg" -a -f "$filename" ]; then
    echo "$spkg" >> $filename
fi

# Log error event to report file
if [ -n "$errorevent" -a -f "$filename" ]; then
    echo "$errorevent" >> $filename
fi
