#!/bin/bash
#validate password for switching clish view
#usage: validate_pass.sh [admin|config]

user=""
password=""
function checkLinuxPassword() {
    correct=$(</etc/shadow awk -v user=$1 -F : 'user == $1 {print $2}')
    if [ ! -z "$correct" ]; then
        prefix=${correct%"${correct#\$*\$*\$}"}
        supplied=$(echo "$2" | perl -e '$_ = <STDIN>; chomp; print crypt($_, $ARGV[0])' "$prefix")
        if [ "$supplied" = "$correct" ]; then
            echo "0"
        else
            echo "1"
        fi
    else
        echo "1"
    fi
}

if [ "$1" == "admin" ]; then
    if [ -f /opt/Avaya/.referral_auth ]; then
        read -p "Please enter Service User:" user
        read -s -p "Please enter $user password:" password
        password=`echo $password | sed 's/ /\\ /g'`
        retries=0
        while [ $retries -lt 3 ]; do
            output=`curl -k -A "Avaya-WebAdmin" -u "$user":"$password" https://127.0.0.1:8443/ws/security/authenticate 2> /dev/null`
            echo "$output" > tmp.xml
            if ! grep -q "<error_code>136</error_code>" tmp.xml; then
                break
            else
                sleep 3
                let retries=$retries+1
            fi
        done
        if [ ! -z "$output" ]; then
            authok=`echo "$output" | grep "Incorrect credentials"`
        else
            authok="Failed"
        fi
        wcp_admin_rights=256
        current_rights=0
        if [ -z "$authok" ]; then
            current_rights=`xmllint --shell tmp.xml <<<"cat //response/data/ws_object/reference_list/ref[@name=\"Services\"]/service[@name=\"External\"]/AccessRights/text()" |grep -v "/ >"`
            if [ -z $current_rights ]; then
                current_rights=0
            fi
            rm -f tmp.xml
            if [ $(($wcp_admin_rights & $current_rights)) -eq $wcp_admin_rights ]; then
                echo -e "\nLogin successful\n"
                exit 0
            else
                echo -e "\nUser doesn't have access rights\n"
                exit 1
            fi
        else
            if [ "$authok" == "Failed" ]; then
                echo -e "\nCouldn't connect to host.\n"
                
            else
                echo -e "\nIncorrect credentials\n"
            fi
            rm -f tmp.xml
            echo "Logging in as Linux User"
            retCode=$(checkLinuxPassword $user $password)
            if [[ "$retCode" == "0" ]]; then 
                echo "Login Successful."
            else
                echo "Failed login."
            fi
            exit $retCode
        fi
    else
        echo "Logging in as Linux User"
        read -p "Please enter Linux User:" user
        read -s -p "Please enter $user password:" password
        retCode=$(checkLinuxPassword $user $password)
        if [[ "$retCode" == "0" ]]; then
            echo -e "\nLogin Successful."
        else
            echo -e "\nFailed login."
        fi
        exit $retCode
    fi
elif [ "$1" == "root" ]; then
    echo "Please enter password:"

    read -s inputpass
    retCode=$(checkLinuxPassword root $inputpass)
    if [[ "$retCode" == "0" ]]; then
        echo -e "\nLogin Successful."
    else
        echo -e "\nFailed login."
    fi
    exit $retCode
else

    echo "Please enter password:"

    read -s inputpass
    cryptpass=$(perl -e 'print crypt($ARGV[0], "password")' $inputpass)
    read pass < /opt/Avaya/cli_config/$1

    if [ "$cryptpass" == "$pass" ];then 
	exit 0
    else
	echo "Incorrect password"
	exit 1
    fi
fi
