﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using DeviceMgr;
using System.Net;

namespace ProxyExample
{
	public class Examples
	{
		private readonly Config config = new Config();
		private readonly string address = "10.85.1.70";
		private readonly string userName = "root";
		private readonly string password = "pass";

		/// <summary>
		/// The method uses Internet Explorer's proxy settings for all communication. This will work
		/// when the software can assume that the configured Internet Explorer's proxy settings are
		/// correct.
		/// </summary>
		public void UseIEProxySettings()
		{
			ConnectionInfo connectionInfo = CreateConnectionInfo();
			ParameterList parameterList = CreateParameterList();

			IAsyncResult asyncResult = config.BeginGet(connectionInfo, parameterList, null, null);
			Result result = config.EndGet(asyncResult, out parameterList);

			Print(parameterList);
		}

		/// <summary>
		/// This method lets me configure my own proxy that the SDK will use in all its requests. It
		/// does however not let me specify the credentials of the proxy.
		/// </summary>
		public void UseProxySettings()
		{
			ConnectionInfo connectionInfo = CreateConnectionInfo();
			ParameterList parameterList = CreateParameterList();

			// This method lets me configure the proxy the SDK will use. It allows me to specify a proxy
			// address, port, a bypass list and whether to bypass local. However it does not allow me to
			// set any credentials
			Settings.UseProxySettings("myProxyAddress", 80, string.Empty, true);

			IAsyncResult asyncResult = config.BeginGet(connectionInfo, parameterList, null, null);
			Result result = config.EndGet(asyncResult, out parameterList);

			Print(parameterList);
		}

		/// <summary>
		/// This method creates a custom proxy, and instructs the WebRequest class to use that proxy
		/// whenever a request is being made. This way you can specify credentials, and the requests
		/// made from the SDK will respect those credentials.
		/// </summary>
		public void CreateMyOwnProxySettings()
		{
			ConnectionInfo connectionInfo = CreateConnectionInfo();
			ParameterList parameterList = CreateParameterList();

			// Create your own proxy and set it as the default proxy on the WebRequest class.
			WebProxy myCustomProxy = new WebProxy("myProxyAddress", 80);
			myCustomProxy.Credentials = new NetworkCredential("userName", "password");
			WebRequest.DefaultWebProxy = myCustomProxy;

			IAsyncResult asyncResult = config.BeginGet(connectionInfo, parameterList, null, null);
			Result result = config.EndGet(asyncResult, out parameterList);

			Print(parameterList);
		}

		#region Helper methods

		private ConnectionInfo CreateConnectionInfo()
		{
			return new ConnectionInfo(address, userName, password);
		}

		private static ParameterList CreateParameterList()
		{
			ParameterList parameterList = new ParameterList();
			parameterList.Add(new Parameter("Properties.System.SerialNumber", null));
			return parameterList;
		}

		private static void Print(ParameterList parameterList)
		{
			if (parameterList == null)
			{
				Console.WriteLine("Error: Unable to read the parameter");
			}
			else
			{
				foreach (Parameter parameter in parameterList)
				{
					Console.WriteLine(parameter.Name + ": " + parameter.Value);
				}
			}
		}

		#endregion
	}
}
