using System;
using System.IO;
using AxisMediaParserLib;
using System.Runtime.InteropServices;
using System.Threading;
using AXISFILEWRITERLib;


// This sample shows how to use the AXISMediaParser and AXIsFileWriter component to record to asf-file at motion.
class Program
{
    // Connection presets for MJPEG
    // private const string Url = "axmphttp://10.85.158.214/mjpg/1/video.mjpg";

    // Connection presets for different MPEG-4 protocols
    // private const string Url = "axrtsphttp://10.85.158.214/mpeg4/1/media.amp";
    // private const string Url = "axrtpm://10.91.9.2/mpeg4/1/media.amp";
    private const string Url = "axrtpu://192.168.100.112/axis-media/media.amp?videocodec=h264";
    // private const string Url = "axrtsp://10.91.9.2/mpeg4/1/media.amp";
    // Connection preset for H.264
   // private const string Url = "axrtsphttp://10.85.158.55/axis-media/media.amp?videocodec=h264";


	private const string UserName = "root";
	private const string Password = "pass";
	private const string FilePath = "C:\\Axis\\Rec_";   // file in current directory to save to
	private const int Duration = 10000;                      // Time to parse media stream into file

  //Used for declaring when we are in recording state.
  static bool isRecording = false;
  // Stores the mediatype information
  static byte[] mediaTypeBuffer;
  static AutoResetEvent[] autoEvents = new AutoResetEvent[2];
  // Event that is set when a motion occurs
  static AutoResetEvent motionHandle = new AutoResetEvent(false);
  // Event that is set when the application exits
  static AutoResetEvent exitHandle = new AutoResetEvent(false);
  //Thread that initializes and ends a recording.
  static Thread recordThread;
  static AxisMediaParserClass parser = new AxisMediaParserClass();
  // Create the AXIS File Writer COM object
  static AxisFileWriterClass writer = new AxisFileWriterClass();
  // Stores the config Frame which must be added to every recording.
  static byte[] configFrame;
  static bool sentConfigFrame = false;

	static void Main(string[] args)
	{
      autoEvents[0] = motionHandle;
      autoEvents[1] = exitHandle;
      recordThread = new Thread(record);
      // Start the recording thread loop
      recordThread.Start();
      try
      {
          // Register for events like OnVideoSample, OnAudioSample, OnTriggerData and OnError
          parser.OnVideoSample += OnVideoSample;
          parser.OnAudioSample += OnAudioSample;
          parser.OnError += OnError;
          parser.OnTriggerData += OnTrigger;

          // Set connection and media properties
          parser.MediaURL = Url;
          parser.MediaUsername = UserName;
          parser.MediaPassword = Password;

          // Connect to the device
          Console.WriteLine("Connecting to {0}", parser.MediaURL);
          int cookieID;
          int numberOfStreams;
          object buffer;
          parser.Connect(out cookieID, out numberOfStreams, out buffer);

          // Save media type to our class variable. We need it when a recording is started.
          mediaTypeBuffer = (byte[])buffer;


          // Start the media stream and registered event handlers will be called
          parser.Start();

          // Run application until we get user input
          System.Console.ReadLine();
          // Signal exitHandle to exit recordingthread.
          exitHandle.Set();

          // Stops the recording and closes the asf-files.
          writer.EndRecording();

          // Stop the stream
          parser.Stop();

          // Unregister event handlers
          parser.OnVideoSample -= OnVideoSample;
          parser.OnAudioSample -= OnAudioSample;
          parser.OnError -= OnError;
          parser.OnTriggerData -= OnTrigger;

          // Inform the GC that COM object no longer will be used
          Marshal.FinalReleaseComObject(parser);
          parser = null;
      }
      catch (COMException e)
      {
          Console.WriteLine("Exception for {0}, {1}", parser.MediaURL, e.Message);
      }
      Console.WriteLine("Stream stopped");
	}

	// Event handler callback for video samples buffers
	static void OnVideoSample(int cookieID, int sampleType,
		int sampleFlags, ulong startTime, ulong stopTime, object SampleArray)
	{
		  // Cast the buffer object to a byte array
		  byte[] bufferBytes = (byte[])SampleArray;
      if ((sampleType == (int)AMP_VIDEO_SAMPLE_TYPE.AMP_VST_MPEG4_VIDEO_CONFIG) ||
          (sampleType == (int)AMP_VIDEO_SAMPLE_TYPE.AMP_VST_H264_VIDEO_CONFIG))
      {
          configFrame = new byte[bufferBytes.Length];
          configFrame = bufferBytes;
      }
      if (isRecording)
      {
          if (!sentConfigFrame)
          {
              writer.WriteStreamSample((ushort)AFW_STREAM_TYPE.AFW_ST_VIDEO, startTime, 0, configFrame);
              sentConfigFrame = true;
          }
          Console.WriteLine("OnVideoSample - {0} bytes", bufferBytes.Length);
          writer.WriteStreamSample((ushort)AFW_STREAM_TYPE.AFW_ST_VIDEO, startTime, 0, bufferBytes);
      }
	}

	// Event handler callback for audio samples buffers
  static void OnAudioSample(int cookieID, int sampleType,
	int sampleFlags, ulong startTime, ulong stopTime, object SampleArray)
	{
		  // Cast the buffer object to a byte array
		  byte[] bufferBytes = (byte[])SampleArray;
      if (isRecording)
      {
	      Console.WriteLine("OnAudioSample - {0} bytes", bufferBytes.Length);
        writer.WriteStreamSample((ushort)AFW_STREAM_TYPE.AFW_ST_AUDIO, startTime, 0, bufferBytes);
      }
	}

	// Event handler callback from AxisMediaParser in case of errors during stream parsing
	private static void OnError(int errorCode)
	{
		Console.WriteLine("OnError - Code 0x{0:X}", errorCode);
	}

	// Event handler callback for video trigger data
	static void OnTrigger(int CookieID, ulong StartTime, uint UserTime,
		short UserTimeFract, uint UnitTime, short UnitTimeFract, bool UnitTimeInvalid, string TriggerData)
	{
		  Console.WriteLine("OnTriggerData - {0}", TriggerData);
      //Parse the Motion trigger
      string motionTrigger = TriggerData.Substring(TriggerData.IndexOf("M0:") + 3, 1);
      if (motionTrigger.Equals("1"))
      {
          motionHandle.Set();
      }
	}
    static void record()
    {
        try
        {
            while (true)
            {
                bool exit = false;
                // Wait until one of motionHandle and exitHandle gets signaled.
                if (WaitHandle.WaitAny(autoEvents) == 1)
                {
                    //Exit the thread if exitHandle has been called.
                    break;
                }
                // Init the Writer with media type buffer and output file path. 
                writer.BeginRecord(FilePath + DateTime.Now.ToShortTimeString().Replace(":","_") 
                  + "_" + DateTime.Now.Second.ToString() + ".asf", mediaTypeBuffer);
                // Request a new I-frame to make the recording playable asap
                parser.SendRenewStream(0); 
                isRecording = true;
                // Record for 10 seconds or until exitHandle is signaled.
                exit = exitHandle.WaitOne(10000, false);
                
                motionHandle.Reset();
                isRecording = false;
                sentConfigFrame = false;
                if (exit) break;
            }
        }
        catch (COMException e)
        {
            Console.WriteLine("Exception: {0}", e.Message);
        }
    }
}


