// Contains the event handlers that may be sent by the COM objects.

// Callback.cpp : implementation file
//

#include "stdafx.h"
#include "LiveViewPlayer.h"
#include "AxisMediaParserEvents.h"
#include "LiveViewDlg.h"


// CAxisMediaParserEvents

IMPLEMENT_DYNAMIC(CAxisMediaParserEvents, CCmdTarget)


CAxisMediaParserEvents::CAxisMediaParserEvents()
{
	EnableAutomation();
}

CAxisMediaParserEvents::~CAxisMediaParserEvents()
{
}


void CAxisMediaParserEvents::OnFinalRelease()
{
	// When the last reference for an automation object is released
	// OnFinalRelease is called.  The base class will automatically
	// deletes the object.  Add additional cleanup required for your
	// object before calling the base class.

	CCmdTarget::OnFinalRelease();
}


BEGIN_MESSAGE_MAP(CAxisMediaParserEvents, CCmdTarget)
END_MESSAGE_MAP()


BEGIN_DISPATCH_MAP(CAxisMediaParserEvents, CCmdTarget)
	DISP_FUNCTION_ID(CAxisMediaParserEvents, "OnError", AMP_OnError, OnError, VT_EMPTY, VTS_I4)
	DISP_FUNCTION_ID(CAxisMediaParserEvents, "OnTriggerData", AMP_OnTriggerData, OnTriggerData, VT_EMPTY, VTS_I4 VTS_UI8 VTS_UI4 VTS_I2 VTS_UI4 VTS_I2 VTS_BOOL VTS_BSTR)
	DISP_FUNCTION_ID(CAxisMediaParserEvents, "OnVideoSample", AMP_OnVideoSample, OnVideoSample, VT_EMPTY, VTS_I4 VTS_I4 VTS_I4 VTS_UI8 VTS_UI8 VTS_VARIANT)
	DISP_FUNCTION_ID(CAxisMediaParserEvents, "OnAudioSample", AMP_OnAudioSample, OnAudioSample, VT_EMPTY, VTS_I4 VTS_I4 VTS_I4 VTS_UI8 VTS_UI8 VTS_VARIANT)
END_DISPATCH_MAP()

// Note: we add support for IID_IEvents to support typesafe binding
//  from VBA.  This IID must match the GUID that is attached to the 
//  dispinterface in the .IDL file.

// {2617B8F8-7181-4D3B-9421-54446C113075}
static const IID IID_IEvents =
{ 0x2617B8F8, 0x7181, 0x4D3B, { 0x94, 0x21, 0x54, 0x44, 0x6C, 0x11, 0x30, 0x75 } };

BEGIN_INTERFACE_MAP(CAxisMediaParserEvents, CCmdTarget)
	INTERFACE_PART(CAxisMediaParserEvents, IID_IEvents, Dispatch)
	INTERFACE_PART(CAxisMediaParserEvents, __uuidof(IAxisMediaParserEvents), Dispatch)
END_INTERFACE_MAP()


// CAxisMediaParserEvents message handlers

void CAxisMediaParserEvents::OnError(long ErrorCode)
{
	TRACE("CAxisMediaParserEvents::OnError() called with error 0x%X\n", ErrorCode);
}

void CAxisMediaParserEvents::OnTriggerData(LONG lCookieID, UINT64 dw64StartTime, DWORD dwUserTime, SHORT UserTimeFract, DWORD dwUnitTime, SHORT UnitTimeFract, BOOL bUnitTimeInvalid, LPCTSTR lpszTriggerData)
{
	// Set new trigger data to dialog control variable
	m_pLiveViewDlg->m_strTriggerData = lpszTriggerData;

	// Update GUI-thread
	PostMessage(m_pLiveViewDlg->GetSafeHwnd(), WM_MY_UPDATE, 0, 0);
}

void CAxisMediaParserEvents::OnVideoSample(LONG lCookieID, LONG lSampleType, LONG lSampleFlags, UINT64 dw64StartTime, UINT64 dw64StopTime, VARIANT &SampleArray)
{
	try
	{
		// Let viewer render video sample
		m_pLiveViewDlg->m_viewer.RenderVideoSample(lSampleFlags, dw64StartTime, dw64StopTime, SampleArray);

		// Set number of frames received to dialog control variable
		m_pLiveViewDlg->m_dwNumFrames++;

		// Update GUI-thread
		PostMessage(m_pLiveViewDlg->GetSafeHwnd(), WM_MY_UPDATE, 0, 0);
	}
	catch (COleDispatchException* e)
	{
		AfxMessageBox(e->m_strDescription);
		e->Delete();
	}
}

void CAxisMediaParserEvents::OnAudioSample(LONG lCookieID, LONG lSampleType, LONG lSampleFlags, UINT64 dw64StartTime, UINT64 dw64StopTime, VARIANT &SampleArray)
{
	try
	{
		// Let viewer render audio sample
		m_pLiveViewDlg->m_viewer.RenderAudioSample(lSampleFlags, dw64StartTime, dw64StopTime, SampleArray);
	}
	catch (COleDispatchException* e)
	{
		AfxMessageBox(e->m_strDescription);
		e->Delete();
	}
}
