// Our live view dialog which contains the live video view media content

// LiveViewDlg.cpp : implementation file
//

#include "stdafx.h"
#include "LiveViewPlayer.h"
#include "LiveViewDlg.h"
#include <afxctl.h>


#define CONTROL_SPACE_Y 80


// CLiveViewDlg dialog

IMPLEMENT_DYNAMIC(CLiveViewDlg, CDialog)

CLiveViewDlg::CLiveViewDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CLiveViewDlg::IDD, pParent)
{
	// Initialize all class member variables
	m_dwNumFrames = 0;
	m_strResolution = "";
	m_strTriggerData = "";
}

CLiveViewDlg::~CLiveViewDlg()
{
}

void CLiveViewDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_NUM_FRAMES, m_dwNumFrames);
	DDX_Text(pDX, IDC_RESOLUTION, m_strResolution);
	DDX_Text(pDX, IDC_TRIGGER_DATA, m_strTriggerData);
}


BEGIN_MESSAGE_MAP(CLiveViewDlg, CDialog)
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_PLAY, &CLiveViewDlg::OnBnClickedPlay)
	ON_BN_CLICKED(IDC_STOP, &CLiveViewDlg::OnBnClickedStop)
	ON_MESSAGE(WM_MY_UPDATE, OnMyUpdate)
END_MESSAGE_MAP()


// CLiveViewDlg message handlers

LRESULT CLiveViewDlg::OnMyUpdate(WPARAM wParam, LPARAM lParam)
{
	// Update dialog controls
	UpdateData(false);

	return 0;
}

BOOL CLiveViewDlg::Setup()
{
	// Define local variables
	VARIANT varMediaType;
	LONG lConnectionCookie;
	LONG lNumberOfStreams;
	CRect rcWnd;
	CRect rcClient;
	CSize sizeVideo;

	// Create the AXIS Media Parser COM object
	if (!m_parser.CreateDispatch("AxisMediaParserLib.AxisMediaParser"))
	{
		AfxMessageBox("Failed to create dispatch for AxisMediaParser!");
		return false;
	}

	// Create the AXIS Media Viewer COM object
	if (!m_viewer.CreateDispatch("AxisMediaViewerLib.AxisMediaViewer"))
	{
		AfxMessageBox("Failed to create dispatch for AxisMediaViewer!");
		return false;
	}

	// Get a pointer to IUnknown for our event handler class
	IUnknown* pUnkCallback = m_events.GetIDispatch(false);

	// Establish a connection between parser and event handlers
	AfxConnectionAdvise(m_parser.m_lpDispatch, __uuidof(IAxisMediaParserEvents), pUnkCallback, false, &m_dwCallbackCookie);

	// Setup our AXIS Media Parser COM object properties
	m_parser.SetMediaURL(m_strMediaURL);
	m_parser.SetMediaUsername(m_strMediaUsername);
	m_parser.SetMediaPassword(m_strMediaPassword);

	// Setup our AXIS Media Viewer COM object properties
	m_viewer.SetVMR9(false);
	m_viewer.SetColorSpace(AMV_CS_RGB32);
	m_viewer.SetPlayOptions(AMV_PO_VIDEO | AMV_PO_AUDIO);

	try
	{
		// Connect to our Axis camera
		m_parser.Connect(&lConnectionCookie, &lNumberOfStreams, &varMediaType);

		// Initialize our viewer
		m_viewer.Init(0, varMediaType, (INT64) GetSafeHwnd());

		// Set this pointer to event handler class (will be used to update dialog control variables)
		m_events.SetLiveViewDlg(this);

		// Get video size in pixels from our viewer
		m_viewer.GetVideoSize(&sizeVideo.cx, &sizeVideo.cy);

		// Update resolution string in dialog control variable and update dialog
		m_strResolution.Format("%dx%d", sizeVideo.cx, sizeVideo.cy);
		UpdateData(false);

		// Adjust size of dialog to fit video size and center it on screen
		GetWindowRect(&rcWnd);
		GetClientRect(&rcClient);
		MoveWindow(0, 0,
			rcWnd.Width() - rcClient.Width() + sizeVideo.cx,
			rcWnd.Height() - rcClient.Height() + sizeVideo.cy + CONTROL_SPACE_Y, FALSE);
		CenterWindow();

		// Specify where to draw our video frames (will be resized if different from original)
		m_viewer.SetVideoPosition(0, CONTROL_SPACE_Y, sizeVideo.cx, sizeVideo.cy + CONTROL_SPACE_Y);
	}
	catch (COleDispatchException* e)
	{
		AfxMessageBox(e->m_strDescription);
		e->Delete();
		return false;
	}

	return true;
}

BOOL CLiveViewDlg::Start()
{
	try
	{
		// Start viewer and then parser
		m_viewer.Start();
		m_parser.Start();
	}
	catch (COleDispatchException* e)
	{
		AfxMessageBox(e->m_strDescription);
		e->Delete();
		return false;
	}

	return true;
}

BOOL CLiveViewDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Setup our parser and viewer
	if (!Setup())
	{
		EndDialog(IDCANCEL);
		return true;
	}

	// Start our parser and viewer
	if (!Start())
	{
		EndDialog(IDCANCEL);
		return true;
	}

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

void CLiveViewDlg::OnDestroy()
{
	// Stop our parser and viewer
	try
	{
		if (m_parser.GetStatus() & AMP_STATUS_RUNNING) {
			m_parser.Stop();
		}
		if (m_viewer.GetStatus() & AMV_STATUS_RUNNING) {
			m_viewer.Stop();
		}
	}
	catch (COleDispatchException* e)
	{
		AfxMessageBox(e->m_strDescription);
		e->Delete();
	}

	// Get a pointer to IUnknown for our event handler class
	IUnknown* pUnkCallback = m_events.GetIDispatch(false);

	// Terminate the connection between parser and event handlers
	if (m_parser.m_lpDispatch)
	{
		AfxConnectionUnadvise(m_parser.m_lpDispatch, __uuidof(IAxisMediaParserEvents), pUnkCallback, false, m_dwCallbackCookie);
	}

	CDialog::OnDestroy();
}

void CLiveViewDlg::OnBnClickedPlay()
{
	try
	{
		// Start parser (viewer is always started)
		if (m_parser.GetStatus() & AMP_STATUS_IDLE) {
			m_parser.Start();
		}
	}
	catch (COleDispatchException* e)
	{
		AfxMessageBox(e->m_strDescription);
		e->Delete();
	}
}

void CLiveViewDlg::OnBnClickedStop()
{
	try
	{
		// Stop parser (viewer is always started)
		if (m_parser.GetStatus() & AMP_STATUS_RUNNING) {
			m_parser.Stop();
		}
	}
	catch (COleDispatchException* e)
	{
		AfxMessageBox(e->m_strDescription);
		e->Delete();
	}
}
