// Our live view dialog which contains the live video view media content

#pragma once

#include "AxisMediaParserEvents.h"

// CLiveViewDlg dialog

class CLiveViewDlg : public CDialog
{
	DECLARE_DYNAMIC(CLiveViewDlg)

private:
	// Our class member variables
	CAxisMediaParser m_parser;
	CAxisMediaViewer m_viewer;
	CAxisMediaParserEvents m_events;
	DWORD m_dwCallbackCookie;

	CString m_strMediaURL;
	CString m_strMediaUsername;
	CString m_strMediaPassword;

	friend CAxisMediaParserEvents;

public:
	CLiveViewDlg(CWnd* pParent = NULL);   // standard constructor
	virtual ~CLiveViewDlg();

	void SetMediaURL(LPCTSTR lpszMediaURL) { m_strMediaURL = lpszMediaURL; }
	void SetMediaUsername(LPCTSTR lpszMediaUsername) { m_strMediaUsername = lpszMediaUsername; }
	void SetMediaPassword(LPCTSTR lpszMediaPassword) { m_strMediaPassword = lpszMediaPassword; }

	BOOL Setup();
	BOOL Start();

// Dialog Data
	enum { IDD = IDD_LIVEVIEW_DIALOG };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

	DECLARE_MESSAGE_MAP()

public:
	// Our dialog control variables
	DWORD m_dwNumFrames;
	CString m_strResolution;
	CString m_strTriggerData;

public:
	virtual BOOL OnInitDialog();
	afx_msg void OnDestroy();
	afx_msg void OnBnClickedPlay();
	afx_msg void OnBnClickedStop();
	afx_msg LRESULT OnMyUpdate(WPARAM wParam, LPARAM lParam);
};
