##----------------------------------------------------------------------------
## Copyright (c) Axis Communications AB, SWEDEN. All rights reserved.
##----------------------------------------------------------------------------

<#
    .SYNOPSIS
     Add component string constants to this file.
     Update this template if you are adding to this repo.
     This file should be placed in the solution root.
#>

# Version constants for the component
$ComponentVersions = @{
    axisBuildBootstrapVersion = "4.0.0"
    nugetScriptVersion        = "5.0.1"

    # bundled    = "1.1.0"
    # notBundled = "0.1.0"
    # legacy     = "1.0.0"
    componentBaseVersion      = "0.1.0"
}

# Name of script nuget
$NugetScriptConstants = @{
    nugetName                 = "Axis.Component.Scripts"
    nugetScriptsPath          = "BuildScripts"
    nugetRestoreUri           = "https://artifacts.se.axis.com/artifactory/api/nuget/v3/vms-nuget-all-se/index.json"
    nugetModulesDirectoryName = "Tools"
    nugetLoadModulesFileName  = "Load-ScriptModules.ps1"
}

# Solution specific constants
$SolutionConstants = [ordered]@{
    componentSolutionPath                = ($componentSolutionPath = $PSScriptRoot)
    projectName                          = ($projectName = "BWC.In.Car")
    projectPath                          = ($projectPath = Join-Path $componentSolutionPath $projectName)
    metadataFilePath                     = Join-Path $projectPath "metadata.json"
    metadataId                           = "axiseventbridgeforonlogic" # Should not change between versions
    metadataIdCamelCase                  = "AxisEventBridgeForOnlogic" # For naming conventions
    metaDataName                         = "AXIS Event Bridge for OnLogic"
    solutionName                         = ($solutionName = "BWC.In.Car")
    stringConstantsFilePath              = Join-Path $componentSolutionPath "StringConstants.ps1" # Place in solution root
    solutionFilePath                     = "$(Join-Path $componentSolutionPath $solutionName).sln"
    componentCsprojFilePath              = "$(Join-Path $projectPath $projectName).csproj"
    componentFilesToIncludeInPackagePath = Join-Path $componentSolutionPath "ComponentFilesToZip"
    packageJsonPath                      = Join-Path $projectPath "wwwroot\package.json"
    acsScriptsDirectoryPath              = Join-Path $projectPath "AcsScripts"

    binaryFile                           = "BWC.In.Car.exe" # improve
}

# Component nuget constants
$componentNugetConstants = [ordered]@{
    # Nuget-package naming conventions https://confluence.se.axis.com/pages/viewpage.action?spaceKey=MS&title=How+to+create+a+component+NuGet-package
    nuspecId                 = ($nuspecId = "Axis.Acs.Component.$($SolutionConstants.metadataIdCamelCase)")
    description              = "AXIS Event Bridge for OnLogic."
    signedComponentFileName  = "Signed$($SolutionConstants.metadataIdCamelCase).zip"
    nuspecFileName           = ($nuspecFileName = "$nuspecId.nuspec")
    targetsFileName          = ($targetsFileName = "$nuspecId.targets")
    nuspecFilePath           = Join-Path $SolutionConstants.projectPath $nuspecFileName
    targetsFilePath          = Join-Path $SolutionConstants.projectPath $targetsFileName

    # Each ACS component's SBOM file shall be named <ComponentName>_sbom.<format>.json (component name in pascal case and rest in lower case, format being e.g. "cyclonedx" or "spdx")  
    sbomFileBackEndName      = ($sbomFileBackEndName = "$($SolutionConstants.metadataIdCamelCase)_service_sbom.cyclonedx.json")
    sbomFileFrontEndName     = ($sbomFileFrontEndName = "$($SolutionConstants.metadataIdCamelCase)_ui_sbom.cyclonedx.json")
    sbomFileBackEndFilePath  = Join-Path $SolutionConstants.componentFilesToIncludeInPackagePath $sbomFileBackEndName
    sbomFileFrontEndFilePath = Join-Path $SolutionConstants.componentFilesToIncludeInPackagePath $sbomFileFrontEndName
}

# Service Specific Constants
$ServiceConstants = @{
    serviceName        = "AXISCameraStationEventBridgeForOnLogicService"
    serviceDisplayName = "AXIS Camera Station Event Bridge for OnLogic Service"
    serviceStartupType = "Manual"
    serviceDescription = "AXIS Camera Station Event Bridge for OnLogic Service"
}

# Constants used for packing and publishing
$componentPublishConstants = [ordered]@{
    componentSignUri        = "https://acs-plugin-sign.se.axis.com/sign"
    componentSignHeader     = "Bearer ${env:BearerToken}"
    zippedComponentFilePath = ($zippedComponentFilePath = "$(Join-Path $SolutionConstants.componentSolutionPath $SolutionConstants.metadataIdCamelCase).zip")
    componentSignFormData   = "plugin=@$zippedComponentFilePath"
    signedComponentFilePath = Join-Path $SolutionConstants.componentFilesToIncludeInPackagePath $componentNugetConstants.signedComponentFileName
    nugetPackageExePath     = "$env:SATOOLS\nuget6.exe"
}

# Third party specific constants
$ThirdPartyLicenseConstants = [ordered]@{
    licenseName                   = ($licenseName = "third-party-licenses")
    licenseFileName               = ($licenseFileName = "$licenseName.txt")
    thirdPartyLicenseTxtFilePath  = Join-Path $SolutionConstants.componentSolutionPath $licenseFileName
    thirdPartyLicenseJsonFilePath = Join-Path $SolutionConstants.componentSolutionPath "$licenseName.json"
}

$fileStructureConstants = @{
    dataDirPathName = "Data"
    logDirPathName  = "Logs"
    scriptLogName   = "scripts.log"
}

# Project GUIDs  to exclude from the SBOM
#
# Each project is declared with the following syntax in the solution file:
#
# Project("{<project type GUID>}") = "<project name>", "<project file location>", "{<project GUID>}"
# EndProject
$projectIdsToExclude = @(
    "5704B248-CB26-4EB6-98B9-79DCFF46175D" # TestProj
)
# SIG # Begin signature block
# MIIoHAYJKoZIhvcNAQcCoIIoDTCCKAkCAQExDzANBglghkgBZQMEAgEFADB5Bgor
# BgEEAYI3AgEEoGswaTA0BgorBgEEAYI3AgEeMCYCAwEAAAQQH8w7YFlLCE63JNLG
# KX7zUQIBAAIBAAIBAAIBAAIBADAxMA0GCWCGSAFlAwQCAQUABCBVm9uWaGiVCwqq
# b5at4DvLx30j4ldeN9aF7KtyY92gb6CCDY4wggawMIIEmKADAgECAhAIrUCyYNKc
# TJ9ezam9k67ZMA0GCSqGSIb3DQEBDAUAMGIxCzAJBgNVBAYTAlVTMRUwEwYDVQQK
# EwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xITAfBgNV
# BAMTGERpZ2lDZXJ0IFRydXN0ZWQgUm9vdCBHNDAeFw0yMTA0MjkwMDAwMDBaFw0z
# NjA0MjgyMzU5NTlaMGkxCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5EaWdpQ2VydCwg
# SW5jLjFBMD8GA1UEAxM4RGlnaUNlcnQgVHJ1c3RlZCBHNCBDb2RlIFNpZ25pbmcg
# UlNBNDA5NiBTSEEzODQgMjAyMSBDQTEwggIiMA0GCSqGSIb3DQEBAQUAA4ICDwAw
# ggIKAoICAQDVtC9C0CiteLdd1TlZG7GIQvUzjOs9gZdwxbvEhSYwn6SOaNhc9es0
# JAfhS0/TeEP0F9ce2vnS1WcaUk8OoVf8iJnBkcyBAz5NcCRks43iCH00fUyAVxJr
# Q5qZ8sU7H/Lvy0daE6ZMswEgJfMQ04uy+wjwiuCdCcBlp/qYgEk1hz1RGeiQIXhF
# LqGfLOEYwhrMxe6TSXBCMo/7xuoc82VokaJNTIIRSFJo3hC9FFdd6BgTZcV/sk+F
# LEikVoQ11vkunKoAFdE3/hoGlMJ8yOobMubKwvSnowMOdKWvObarYBLj6Na59zHh
# 3K3kGKDYwSNHR7OhD26jq22YBoMbt2pnLdK9RBqSEIGPsDsJ18ebMlrC/2pgVItJ
# wZPt4bRc4G/rJvmM1bL5OBDm6s6R9b7T+2+TYTRcvJNFKIM2KmYoX7BzzosmJQay
# g9Rc9hUZTO1i4F4z8ujo7AqnsAMrkbI2eb73rQgedaZlzLvjSFDzd5Ea/ttQokbI
# YViY9XwCFjyDKK05huzUtw1T0PhH5nUwjewwk3YUpltLXXRhTT8SkXbev1jLchAp
# QfDVxW0mdmgRQRNYmtwmKwH0iU1Z23jPgUo+QEdfyYFQc4UQIyFZYIpkVMHMIRro
# OBl8ZhzNeDhFMJlP/2NPTLuqDQhTQXxYPUez+rbsjDIJAsxsPAxWEQIDAQABo4IB
# WTCCAVUwEgYDVR0TAQH/BAgwBgEB/wIBADAdBgNVHQ4EFgQUaDfg67Y7+F8Rhvv+
# YXsIiGX0TkIwHwYDVR0jBBgwFoAU7NfjgtJxXWRM3y5nP+e6mK4cD08wDgYDVR0P
# AQH/BAQDAgGGMBMGA1UdJQQMMAoGCCsGAQUFBwMDMHcGCCsGAQUFBwEBBGswaTAk
# BggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEEGCCsGAQUFBzAC
# hjVodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRUcnVzdGVkUm9v
# dEc0LmNydDBDBgNVHR8EPDA6MDigNqA0hjJodHRwOi8vY3JsMy5kaWdpY2VydC5j
# b20vRGlnaUNlcnRUcnVzdGVkUm9vdEc0LmNybDAcBgNVHSAEFTATMAcGBWeBDAED
# MAgGBmeBDAEEATANBgkqhkiG9w0BAQwFAAOCAgEAOiNEPY0Idu6PvDqZ01bgAhql
# +Eg08yy25nRm95RysQDKr2wwJxMSnpBEn0v9nqN8JtU3vDpdSG2V1T9J9Ce7FoFF
# UP2cvbaF4HZ+N3HLIvdaqpDP9ZNq4+sg0dVQeYiaiorBtr2hSBh+3NiAGhEZGM1h
# mYFW9snjdufE5BtfQ/g+lP92OT2e1JnPSt0o618moZVYSNUa/tcnP/2Q0XaG3Ryw
# YFzzDaju4ImhvTnhOE7abrs2nfvlIVNaw8rpavGiPttDuDPITzgUkpn13c5Ubdld
# AhQfQDN8A+KVssIhdXNSy0bYxDQcoqVLjc1vdjcshT8azibpGL6QB7BDf5WIIIJw
# 8MzK7/0pNVwfiThV9zeKiwmhywvpMRr/LhlcOXHhvpynCgbWJme3kuZOX956rEnP
# LqR0kq3bPKSchh/jwVYbKyP/j7XqiHtwa+aguv06P0WmxOgWkVKLQcBIhEuWTatE
# QOON8BUozu3xGFYHKi8QxAwIZDwzj64ojDzLj4gLDb879M4ee47vtevLt/B3E+bn
# KD+sEq6lLyJsQfmCXBVmzGwOysWGw/YmMwwHS6DTBwJqakAwSEs0qFEgu60bhQji
# WQ1tygVQK+pKHJ6l/aCnHwZ05/LWUpD9r4VIIflXO7ScA+2GRfS0YW6/aOImYIbq
# yK+p/pQd52MbOoZWeE4wggbWMIIEvqADAgECAhAILYwW0nV0JkMDtityXUvoMA0G
# CSqGSIb3DQEBCwUAMGkxCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5EaWdpQ2VydCwg
# SW5jLjFBMD8GA1UEAxM4RGlnaUNlcnQgVHJ1c3RlZCBHNCBDb2RlIFNpZ25pbmcg
# UlNBNDA5NiBTSEEzODQgMjAyMSBDQTEwHhcNMjQwMjEyMDAwMDAwWhcNMjcwMjEx
# MjM1OTU5WjBeMQswCQYDVQQGEwJTRTENMAsGA1UEBxMETHVuZDEfMB0GA1UEChMW
# QXhpcyBDb21tdW5pY2F0aW9ucyBBQjEfMB0GA1UEAxMWQXhpcyBDb21tdW5pY2F0
# aW9ucyBBQjCCAaIwDQYJKoZIhvcNAQEBBQADggGPADCCAYoCggGBAOk0Sr22C6QH
# zDpps6p3+m4c4HrGKW9dju1+awvCWpNnrTrCxxcqC7Fexgt3VVR2GfI+hEHrkSV9
# hq7tCT20No1s4OqGdB/FasUvqq8jCuoXKQQnd5gqFhFz/aL+1ocr2NvtCsxuNihB
# UA3isiFf0R0uXcEIoi+tUiy0vJf5ZstopMEuSSOZlANhdWvwBTd8DL1EBYDp4Z/t
# 1kWLax6NI8fim1MJxi5OaVUd1haFQMbzeBiwDXlMVJCyYcSVH7fuKCRhoem4pX1g
# fdbM3yfhigegJPRui13ai6I69X71GoyRCBnkCgkrw8nUrOHGjrTe90sXLvVSU0Yu
# j3VZzcDkdxN16tHG2SK3NT/7d5EmgrUSwabvS36sTRy0VeSCmop4ByDlTUCljGiP
# cDO5viiyDF9SRbKa0BSuVAB9xtaaqjw9+sWRxiUqHVq8cRPOylBcziOMVFSE4ENc
# aH3A55N2kb2tBalRm0GPfvB1wRzHdow/ArdGYB1FYIrBi2IUcUsgKwIDAQABo4IC
# AzCCAf8wHwYDVR0jBBgwFoAUaDfg67Y7+F8Rhvv+YXsIiGX0TkIwHQYDVR0OBBYE
# FCCITo81URSaUaiF+AwqLquw/5UcMD4GA1UdIAQ3MDUwMwYGZ4EMAQQBMCkwJwYI
# KwYBBQUHAgEWG2h0dHA6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAOBgNVHQ8BAf8E
# BAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMwgbUGA1UdHwSBrTCBqjBToFGgT4ZN
# aHR0cDovL2NybDMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0VHJ1c3RlZEc0Q29kZVNp
# Z25pbmdSU0E0MDk2U0hBMzg0MjAyMUNBMS5jcmwwU6BRoE+GTWh0dHA6Ly9jcmw0
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNENvZGVTaWduaW5nUlNBNDA5
# NlNIQTM4NDIwMjFDQTEuY3JsMIGUBggrBgEFBQcBAQSBhzCBhDAkBggrBgEFBQcw
# AYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29tMFwGCCsGAQUFBzAChlBodHRwOi8v
# Y2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRUcnVzdGVkRzRDb2RlU2lnbmlu
# Z1JTQTQwOTZTSEEzODQyMDIxQ0ExLmNydDAJBgNVHRMEAjAAMA0GCSqGSIb3DQEB
# CwUAA4ICAQBTl/rp/1EMC6RXuNwZmY8QNQpzSOODOmLbFU1hMlHq/iipWO+tsAnH
# fB4CnZlrbgkVa64syckD29gWMrYp2PMdTwsL/vHmUI0lZj1pJ3zCvB5E+4CnKkhY
# SIre1yukMyzbHR5y5X2bQ6kVtR0mkKqDTrT+vm6abBMmNcVwc+j5IJ9viHspncAs
# X/t7gnYDmMnHCWTQwR01wNYypEbmpf5ZtF8233I5toy+x2TGBx7PToduYzxWiF9G
# Hd18UNGuyNjsLPnHI0cY3vGNMo5GiaisR9e/CHYUq149MduRRifz9kkq8JA81k0j
# +DEsZb8lOORoA7gte007xnesv35OL4ezbfhjkKYICGjRVSB/Xu8YhH04Xs6AbFWB
# Boqi9/DH9RV3S0LH+JzxNIeDUw8LW7VNYrSOHWuRqPSazmtWll+MQUDV0p4LIUMl
# EjoUNsRBvsDYSMiZSTNizMgyp437XDv25+iO8GMtiKlymsOPuKYALFVn0TJxdIet
# ID0HnXa560C3FysEDxsGbVCI6L1l9j5RCmmF1qUs7o2oczvlDyplesA0sNOSlpJF
# xyTgvlXXloxJCH7Yaz/2ItvhfMt1CZhMtyp38Y1yWlgMqSTrlJVxAcXHOXzu/mEM
# aNvDTqF/zGnW5todKFHL092hQqm+8xGNOjL0C8G+ByZ2tzSh3y1R7jGCGeQwghng
# AgEBMH0waTELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMuMUEw
# PwYDVQQDEzhEaWdpQ2VydCBUcnVzdGVkIEc0IENvZGUgU2lnbmluZyBSU0E0MDk2
# IFNIQTM4NCAyMDIxIENBMQIQCC2MFtJ1dCZDA7Yrcl1L6DANBglghkgBZQMEAgEF
# AKB8MBAGCisGAQQBgjcCAQwxAjAAMBkGCSqGSIb3DQEJAzEMBgorBgEEAYI3AgEE
# MBwGCisGAQQBgjcCAQsxDjAMBgorBgEEAYI3AgEVMC8GCSqGSIb3DQEJBDEiBCDh
# o9ekpfekSYOWGI0U9fKoHM91KAO/GvFCKNzcui8CnzANBgkqhkiG9w0BAQEFAASC
# AYAxk0eVzPNmnMdsCts6XZt0PeMW7s47t729Xe4bW/Jd8SFjErm6qVXiSqaKin0X
# mC/jTbbD6rd5B29Z6ErYgoMffou2eyRhXwkqxowSMTWh25MO5jzqkKNBYqC+pCS8
# I9PmYU07nszVU4S85vHcoSVI4Jx8rhojq7U4ne/aF2HorUEzflaGifDKGcMailXs
# wX4UAeOyxj/qazUeRdKe/zU3qwu6cgnZ9W6gHP4f3kALjaDapc7k++LNJAOZKmeC
# 0/Pi2LWP/YlfSa0qagis1h4q3/22KuuW9ZkZQUL9X1ghLwcnHwLjTudM/Qz5W6RR
# XHTtSfkDrVvrgQFZFTLJCMhjbuN5XT5DQ2GK5Ksq10m9EUcmGnpljdMN5GuOJ6E+
# nTQEWNcyWQAqbPQLZ0xOTWQCrdYvHJocSFK2QZVbuOoijEBlJiMsDtjsOIy5AlsU
# RiZt35MeuOw4lus6SpGlZZAvUqbqpM92FXMlc/hwkorOWXnTAplkjsOtg140rYEZ
# 0Yuhghc6MIIXNgYKKwYBBAGCNwMDATGCFyYwghciBgkqhkiG9w0BBwKgghcTMIIX
# DwIBAzEPMA0GCWCGSAFlAwQCAQUAMHgGCyqGSIb3DQEJEAEEoGkEZzBlAgEBBglg
# hkgBhv1sBwEwMTANBglghkgBZQMEAgEFAAQgdDUk3nOI6ewDk7zqVSfrwAT5PXH9
# Bi5OLEsvW66YFMMCEQCbgkBVkodN8ioMkW7Lb4TlGA8yMDI0MTAxNDEyMzczMlqg
# ghMDMIIGvDCCBKSgAwIBAgIQC65mvFq6f5WHxvnpBOMzBDANBgkqhkiG9w0BAQsF
# ADBjMQswCQYDVQQGEwJVUzEXMBUGA1UEChMORGlnaUNlcnQsIEluYy4xOzA5BgNV
# BAMTMkRpZ2lDZXJ0IFRydXN0ZWQgRzQgUlNBNDA5NiBTSEEyNTYgVGltZVN0YW1w
# aW5nIENBMB4XDTI0MDkyNjAwMDAwMFoXDTM1MTEyNTIzNTk1OVowQjELMAkGA1UE
# BhMCVVMxETAPBgNVBAoTCERpZ2lDZXJ0MSAwHgYDVQQDExdEaWdpQ2VydCBUaW1l
# c3RhbXAgMjAyNDCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIBAL5qc5/2
# lSGrljC6W23mWaO16P2RHxjEiDtqmeOlwf0KMCBDEr4IxHRGd7+L660x5XltSVhh
# K64zi9CeC9B6lUdXM0s71EOcRe8+CEJp+3R2O8oo76EO7o5tLuslxdr9Qq82aKcp
# A9O//X6QE+AcaU/byaCagLD/GLoUb35SfWHh43rOH3bpLEx7pZ7avVnpUVmPvkxT
# 8c2a2yC0WMp8hMu60tZR0ChaV76Nhnj37DEYTX9ReNZ8hIOYe4jl7/r419CvEYVI
# rH6sN00yx49boUuumF9i2T8UuKGn9966fR5X6kgXj3o5WHhHVO+NBikDO0mlUh90
# 2wS/Eeh8F/UFaRp1z5SnROHwSJ+QQRZ1fisD8UTVDSupWJNstVkiqLq+ISTdEjJK
# GjVfIcsgA4l9cbk8Smlzddh4EfvFrpVNnes4c16Jidj5XiPVdsn5n10jxmGpxoMc
# 6iPkoaDhi6JjHd5ibfdp5uzIXp4P0wXkgNs+CO/CacBqU0R4k+8h6gYldp4FCMgr
# XdKWfM4N0u25OEAuEa3JyidxW48jwBqIJqImd93NRxvd1aepSeNeREXAu2xUDEW8
# aqzFQDYmr9ZONuc2MhTMizchNULpUEoA6Vva7b1XCB+1rxvbKmLqfY/M/SdV6mwW
# TyeVy5Z/JkvMFpnQy5wR14GJcv6dQ4aEKOX5AgMBAAGjggGLMIIBhzAOBgNVHQ8B
# Af8EBAMCB4AwDAYDVR0TAQH/BAIwADAWBgNVHSUBAf8EDDAKBggrBgEFBQcDCDAg
# BgNVHSAEGTAXMAgGBmeBDAEEAjALBglghkgBhv1sBwEwHwYDVR0jBBgwFoAUuhbZ
# bU2FL3MpdpovdYxqII+eyG8wHQYDVR0OBBYEFJ9XLAN3DigVkGalY17uT5IfdqBb
# MFoGA1UdHwRTMFEwT6BNoEuGSWh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdp
# Q2VydFRydXN0ZWRHNFJTQTQwOTZTSEEyNTZUaW1lU3RhbXBpbmdDQS5jcmwwgZAG
# CCsGAQUFBwEBBIGDMIGAMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2Vy
# dC5jb20wWAYIKwYBBQUHMAKGTGh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9E
# aWdpQ2VydFRydXN0ZWRHNFJTQTQwOTZTSEEyNTZUaW1lU3RhbXBpbmdDQS5jcnQw
# DQYJKoZIhvcNAQELBQADggIBAD2tHh92mVvjOIQSR9lDkfYR25tOCB3RKE/P09x7
# gUsmXqt40ouRl3lj+8QioVYq3igpwrPvBmZdrlWBb0HvqT00nFSXgmUrDKNSQqGT
# dpjHsPy+LaalTW0qVjvUBhcHzBMutB6HzeledbDCzFzUy34VarPnvIWrqVogK0qM
# 8gJhh/+qDEAIdO/KkYesLyTVOoJ4eTq7gj9UFAL1UruJKlTnCVaM2UeUUW/8z3fv
# jxhN6hdT98Vr2FYlCS7Mbb4Hv5swO+aAXxWUm3WpByXtgVQxiBlTVYzqfLDbe9Pp
# BKDBfk+rabTFDZXoUke7zPgtd7/fvWTlCs30VAGEsshJmLbJ6ZbQ/xll/HjO9JbN
# VekBv2Tgem+mLptR7yIrpaidRJXrI+UzB6vAlk/8a1u7cIqV0yef4uaZFORNekUg
# QHTqddmsPCEIYQP7xGxZBIhdmm4bhYsVA6G2WgNFYagLDBzpmk9104WQzYuVNsxy
# oVLObhx3RugaEGru+SojW4dHPoWrUhftNpFC5H7QEY7MhKRyrBe7ucykW7eaCuWB
# sBb4HOKRFVDcrZgdwaSIqMDiCLg4D+TPVgKx2EgEdeoHNHT9l3ZDBD+XgbF+23/z
# BjeCtxz+dL/9NWR6P2eZRi7zcEO1xwcdcqJsyz/JceENc2Sg8h3KeFUCS7tpFk7C
# rDqkMIIGrjCCBJagAwIBAgIQBzY3tyRUfNhHrP0oZipeWzANBgkqhkiG9w0BAQsF
# ADBiMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQL
# ExB3d3cuZGlnaWNlcnQuY29tMSEwHwYDVQQDExhEaWdpQ2VydCBUcnVzdGVkIFJv
# b3QgRzQwHhcNMjIwMzIzMDAwMDAwWhcNMzcwMzIyMjM1OTU5WjBjMQswCQYDVQQG
# EwJVUzEXMBUGA1UEChMORGlnaUNlcnQsIEluYy4xOzA5BgNVBAMTMkRpZ2lDZXJ0
# IFRydXN0ZWQgRzQgUlNBNDA5NiBTSEEyNTYgVGltZVN0YW1waW5nIENBMIICIjAN
# BgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAxoY1BkmzwT1ySVFVxyUDxPKRN6mX
# UaHW0oPRnkyibaCwzIP5WvYRoUQVQl+kiPNo+n3znIkLf50fng8zH1ATCyZzlm34
# V6gCff1DtITaEfFzsbPuK4CEiiIY3+vaPcQXf6sZKz5C3GeO6lE98NZW1OcoLevT
# sbV15x8GZY2UKdPZ7Gnf2ZCHRgB720RBidx8ald68Dd5n12sy+iEZLRS8nZH92GD
# Gd1ftFQLIWhuNyG7QKxfst5Kfc71ORJn7w6lY2zkpsUdzTYNXNXmG6jBZHRAp8By
# xbpOH7G1WE15/tePc5OsLDnipUjW8LAxE6lXKZYnLvWHpo9OdhVVJnCYJn+gGkcg
# Q+NDY4B7dW4nJZCYOjgRs/b2nuY7W+yB3iIU2YIqx5K/oN7jPqJz+ucfWmyU8lKV
# EStYdEAoq3NDzt9KoRxrOMUp88qqlnNCaJ+2RrOdOqPVA+C/8KI8ykLcGEh/FDTP
# 0kyr75s9/g64ZCr6dSgkQe1CvwWcZklSUPRR8zZJTYsg0ixXNXkrqPNFYLwjjVj3
# 3GHek/45wPmyMKVM1+mYSlg+0wOI/rOP015LdhJRk8mMDDtbiiKowSYI+RQQEgN9
# XyO7ZONj4KbhPvbCdLI/Hgl27KtdRnXiYKNYCQEoAA6EVO7O6V3IXjASvUaetdN2
# udIOa5kM0jO0zbECAwEAAaOCAV0wggFZMBIGA1UdEwEB/wQIMAYBAf8CAQAwHQYD
# VR0OBBYEFLoW2W1NhS9zKXaaL3WMaiCPnshvMB8GA1UdIwQYMBaAFOzX44LScV1k
# TN8uZz/nupiuHA9PMA4GA1UdDwEB/wQEAwIBhjATBgNVHSUEDDAKBggrBgEFBQcD
# CDB3BggrBgEFBQcBAQRrMGkwJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2lj
# ZXJ0LmNvbTBBBggrBgEFBQcwAoY1aHR0cDovL2NhY2VydHMuZGlnaWNlcnQuY29t
# L0RpZ2lDZXJ0VHJ1c3RlZFJvb3RHNC5jcnQwQwYDVR0fBDwwOjA4oDagNIYyaHR0
# cDovL2NybDMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0VHJ1c3RlZFJvb3RHNC5jcmww
# IAYDVR0gBBkwFzAIBgZngQwBBAIwCwYJYIZIAYb9bAcBMA0GCSqGSIb3DQEBCwUA
# A4ICAQB9WY7Ak7ZvmKlEIgF+ZtbYIULhsBguEE0TzzBTzr8Y+8dQXeJLKftwig2q
# KWn8acHPHQfpPmDI2AvlXFvXbYf6hCAlNDFnzbYSlm/EUExiHQwIgqgWvalWzxVz
# jQEiJc6VaT9Hd/tydBTX/6tPiix6q4XNQ1/tYLaqT5Fmniye4Iqs5f2MvGQmh2yS
# vZ180HAKfO+ovHVPulr3qRCyXen/KFSJ8NWKcXZl2szwcqMj+sAngkSumScbqyQe
# JsG33irr9p6xeZmBo1aGqwpFyd/EjaDnmPv7pp1yr8THwcFqcdnGE4AJxLafzYeH
# JLtPo0m5d2aR8XKc6UsCUqc3fpNTrDsdCEkPlM05et3/JWOZJyw9P2un8WbDQc1P
# tkCbISFA0LcTJM3cHXg65J6t5TRxktcma+Q4c6umAU+9Pzt4rUyt+8SVe+0KXzM5
# h0F4ejjpnOHdI/0dKNPH+ejxmF/7K9h+8kaddSweJywm228Vex4Ziza4k9Tm8heZ
# Wcpw8De/mADfIBZPJ/tgZxahZrrdVcA6KYawmKAr7ZVBtzrVFZgxtGIJDwq9gdkT
# /r+k0fNX2bwE+oLeMt8EifAAzV3C+dAjfwAL5HYCJtnwZXZCpimHCUcr5n8apIUP
# /JiW9lVUKx+A+sDyDivl1vupL0QVSucTDh3bNzgaoSv27dZ8/DCCBY0wggR1oAMC
# AQICEA6bGI750C3n79tQ4ghAGFowDQYJKoZIhvcNAQEMBQAwZTELMAkGA1UEBhMC
# VVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0
# LmNvbTEkMCIGA1UEAxMbRGlnaUNlcnQgQXNzdXJlZCBJRCBSb290IENBMB4XDTIy
# MDgwMTAwMDAwMFoXDTMxMTEwOTIzNTk1OVowYjELMAkGA1UEBhMCVVMxFTATBgNV
# BAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTEhMB8G
# A1UEAxMYRGlnaUNlcnQgVHJ1c3RlZCBSb290IEc0MIICIjANBgkqhkiG9w0BAQEF
# AAOCAg8AMIICCgKCAgEAv+aQc2jeu+RdSjwwIjBpM+zCpyUuySE98orYWcLhKac9
# WKt2ms2uexuEDcQwH/MbpDgW61bGl20dq7J58soR0uRf1gU8Ug9SH8aeFaV+vp+p
# VxZZVXKvaJNwwrK6dZlqczKU0RBEEC7fgvMHhOZ0O21x4i0MG+4g1ckgHWMpLc7s
# Xk7Ik/ghYZs06wXGXuxbGrzryc/NrDRAX7F6Zu53yEioZldXn1RYjgwrt0+nMNlW
# 7sp7XeOtyU9e5TXnMcvak17cjo+A2raRmECQecN4x7axxLVqGDgDEI3Y1DekLgV9
# iPWCPhCRcKtVgkEy19sEcypukQF8IUzUvK4bA3VdeGbZOjFEmjNAvwjXWkmkwuap
# oGfdpCe8oU85tRFYF/ckXEaPZPfBaYh2mHY9WV1CdoeJl2l6SPDgohIbZpp0yt5L
# HucOY67m1O+SkjqePdwA5EUlibaaRBkrfsCUtNJhbesz2cXfSwQAzH0clcOP9yGy
# shG3u3/y1YxwLEFgqrFjGESVGnZifvaAsPvoZKYz0YkH4b235kOkGLimdwHhD5QM
# IR2yVCkliWzlDlJRR3S+Jqy2QXXeeqxfjT/JvNNBERJb5RBQ6zHFynIWIgnffEx1
# P2PsIV/EIFFrb7GrhotPwtZFX50g/KEexcCPorF+CiaZ9eRpL5gdLfXZqbId5RsC
# AwEAAaOCATowggE2MA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0OBBYEFOzX44LScV1k
# TN8uZz/nupiuHA9PMB8GA1UdIwQYMBaAFEXroq/0ksuCMS1Ri6enIZ3zbcgPMA4G
# A1UdDwEB/wQEAwIBhjB5BggrBgEFBQcBAQRtMGswJAYIKwYBBQUHMAGGGGh0dHA6
# Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBDBggrBgEFBQcwAoY3aHR0cDovL2NhY2VydHMu
# ZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNydDBFBgNVHR8E
# PjA8MDqgOKA2hjRodHRwOi8vY3JsMy5kaWdpY2VydC5jb20vRGlnaUNlcnRBc3N1
# cmVkSURSb290Q0EuY3JsMBEGA1UdIAQKMAgwBgYEVR0gADANBgkqhkiG9w0BAQwF
# AAOCAQEAcKC/Q1xV5zhfoKN0Gz22Ftf3v1cHvZqsoYcs7IVeqRq7IviHGmlUIu2k
# iHdtvRoU9BNKei8ttzjv9P+Aufih9/Jy3iS8UgPITtAq3votVs/59PesMHqai7Je
# 1M/RQ0SbQyHrlnKhSLSZy51PpwYDE3cnRNTnf+hZqPC/Lwum6fI0POz3A8eHqNJM
# QBk1RmppVLC4oVaO7KTVPeix3P0c2PR3WlxUjG/voVA9/HYJaISfb8rbII01YBwC
# A8sgsKxYoA5AY8WYIsGyWfVVa88nq2x2zm8jLfR+cWojayL/ErhULSd+2DrZ8LaH
# lv1b0VysGMNNn3O3AamfV6peKOK5lDGCA3YwggNyAgEBMHcwYzELMAkGA1UEBhMC
# VVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMuMTswOQYDVQQDEzJEaWdpQ2VydCBU
# cnVzdGVkIEc0IFJTQTQwOTYgU0hBMjU2IFRpbWVTdGFtcGluZyBDQQIQC65mvFq6
# f5WHxvnpBOMzBDANBglghkgBZQMEAgEFAKCB0TAaBgkqhkiG9w0BCQMxDQYLKoZI
# hvcNAQkQAQQwHAYJKoZIhvcNAQkFMQ8XDTI0MTAxNDEyMzczMlowKwYLKoZIhvcN
# AQkQAgwxHDAaMBgwFgQU29OF7mLb0j575PZxSFCHJNWGW0UwLwYJKoZIhvcNAQkE
# MSIEIOjH53gR3xp5iHzCkQbaKlF2LQwE3x884orpv6U7DWxWMDcGCyqGSIb3DQEJ
# EAIvMSgwJjAkMCIEIHZ2n6jyYy8fQws6IzCu1lZ1/tdz2wXWZbkFk5hDj5rbMA0G
# CSqGSIb3DQEBAQUABIICAJ4eqnUlmUAeag+AkXX/OpfodphWS8ddMZGMZrzMCGnB
# tTp4c1VEsJEdPkiqqFTPYSfanZpNM3vNo/eTbWDa9arhGVF2Csh9Pam3GD0aWW8r
# P5PESTHyBnblfsZWxMLF/W40a9b4JZOVDiy2QbQfPKjPNKQ2jWhxch/lm/xBkgPU
# jALP46lb/olyDQiPe0T6DJuaMrAzS9LX7zR8xR0xn2iO13Cri2tJTvDZ6Jr/L3Ef
# V7fbj1K0BpDZr0EROPHdnTvUsJq7+3UzDEk4xfoktXFCC99ixLUoV6CcjswGC5C7
# IZAb1bcDTLxFjo9mxXYLWr5GVz5i6lLSYVMzsTPakYAezrqtLNhYHOC7ZbGx3ryG
# m7dr+Q11tbP/EY4DkWJFWuqc/ZKBIC0FFSQwNh8ZrF8UCWg0moru864YOfczg1lE
# 2v0ErhWlsjtt3wtODhDmClcIExf4cVF4UEOheuate5LQygd1XCXsVR/s0G0VNaNr
# 1ySAol4J5i6sgKRT5sEIa40sc69IxThhqSOdCYxatII2+Zt7nEHcXyTSZjpHJqRQ
# +ySWulQKRnJvmljTGQx8fDT2VQh4oTPGoxk0dYfnc+x5mgtsJ8WsaWzlVxVVO6NT
# Hgj4hR4DerT3QDU/0OpdWB32hKhdN1Jl1JFdLzMaX/XWgZwmmsWR8wpIxSgaGEzR
# SIG # End signature block
