//---------------------------------------------------------------------------- 
// Copyright 2010 (c) Axis Communications AB, SWEDEN. All rights reserved.
//----------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Text;

namespace MediaParserFileSourceDecodeCSharp
{
  public static class AxisDmoClsid
  {
    public static readonly Guid H264 = new Guid(0x7340F0E4, 0xAEDA, 0x47C6,
      0x89, 0x71, 0x9D, 0xB3, 0x14, 0x3, 0xB, 0xD7);
    public static readonly Guid MPEG4 = new Guid(0xC32FE9F1, 0XA857, 0X48B0,
      0XB7, 0XBF, 0X6, 0X5B, 0X57, 0X92, 0XF2, 0X8D);
    public static readonly Guid MJPEG = new Guid(0X29020FE0, 0X3833, 0X4BE2,
      0XA7, 0XF0, 0X42, 0X84, 0X1D, 0X4B, 0X45, 0XF0);
    public static readonly Guid G7xx = new Guid(0xD1F283E1, 0xDF6F, 0x41e4,
      0xAE, 0xD1, 0xEB, 0x1D, 0x6B, 0x4B, 0x0A, 0xE1); // Audio.dll
    public static readonly Guid AAC = new Guid(0XBA7A56EB, 0XD1B9, 0X443B,
      0X96, 0XE9, 0X8, 0X65, 0X32, 0XA3, 0X78, 0XF1);
  }

  public static class CustomMediaSubType
  {
    public static readonly Guid DX50 = new Guid(0x30355844, 0x0000, 0x0010,
      0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);
    public static readonly Guid AAC = new Guid(0x000000ff, 0x0000, 0x0010,
      0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);
    public static readonly Guid G711 = new Guid(0x00000007, 0x0000, 0x0010,
      0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71); //preferred
    public static readonly Guid G726_32 = new Guid(0x00000014, 0x0000, 0x0010,
      0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71); //preferred
    public static readonly Guid G726_24 = new Guid(0x00000040, 0x0000, 0x0010,
      0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71); //preferred
    public static readonly Guid G711_ALT = new Guid(0x000001ef, 0x0000, 0x0010,
      0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71);
    public static readonly Guid G721 = new Guid(0x000002ef, 0x0000, 0x0010,
      0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71); //equivalent to G726_32
    public static readonly Guid G723 = new Guid(0x000003ef, 0x0000, 0x0010,
      0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71); //equivalent to G726_24
  }
}
