//---------------------------------------------------------------------------- 
// Copyright 2010 (c) Axis Communications AB, SWEDEN. All rights reserved.
//----------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Text;
using DirectShowLib.DMO;
using System.Runtime.InteropServices;

namespace MediaParserFileSourceDecodeCSharp
{
  class MediaBuffer : IMediaBuffer, IDisposable
  {
    private int length;
    private int maxLength;
    private IntPtr dataPtr;

    public MediaBuffer(int maxLength)
    {
      this.maxLength = maxLength;
      this.length = 0;
      this.dataPtr = Marshal.AllocHGlobal((int)this.maxLength);
    }
  
    #region IDisposable Members

    public void  Dispose()
    {
      if(this.dataPtr != IntPtr.Zero)
      {
        Marshal.FreeHGlobal(this.dataPtr);
      }
    }

    #endregion

    #region IMediaBuffer Members

    public int GetBufferAndLength(out IntPtr buffer, out int length)
    {
      buffer = this.dataPtr;
      length = this.length;
      return 0;
    }

    public int GetMaxLength(out int maxLength)
    {
      maxLength = this.maxLength;
      return 0;
    }

    public int SetLength(int length)
    {
      if (length > this.maxLength)
      {
        return unchecked ((int)0x80070057); // E_INVALIDARG
      }
      this.length = length;
      return 0;
    }

    #endregion
  }
}
