// Retrieves input from user to be used when instantiating COM objects

// LiveViewPlayerDlg.cpp : implementation file
//

#include "stdafx.h"
#include "LiveViewPlayer.h"
#include "LiveViewPlayerDlg.h"
#include "LiveViewDlg.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// Contains custom protocols for Axis cameras
LPCTSTR URL_TYPES[] = {
	_T("axrtpm"),					// MPEG-4,H264,MJPEG 
	_T("axrtpu"),					// MPEG-4,H264,MJPEG
	_T("axrtsp"),					// MPEG-4,H264,MJPEG
	_T("axrtsphttp"),			// MPEG-4,H264,MJPEG
	_T("axrtsphttps"),		// MPEG-4,H264,MJPEG
	_T("axmphttp")				// MJPEG
};

// Contains mediatypes for Axis cameras
LPCTSTR URL_MEDIATYPES[] = {
	_T("MJPEG"),					
	_T("MPEG4"),					
	_T("H264"),	
};


// CLiveViewPlayerDlg dialog

CLiveViewPlayerDlg::CLiveViewPlayerDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CLiveViewPlayerDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	// Initialize all class member variables
	m_strServerAddress = "10.85.11.2";
	m_strCameraNumber = "1";
	m_strMediaUsername = "root";
	m_strMediaPassword = "pass";
	m_strMediaURL = "";
	m_strVideoFormat = "";
}

void CLiveViewPlayerDlg::DoDataExchange(CDataExchange* pDX)
{
  CDialog::DoDataExchange(pDX);
  DDX_Control(pDX, IDC_CONNTYPE, m_ConnTypeCtrl);
  DDX_Text(pDX, IDC_ADDRESS, m_strServerAddress);
  DDX_CBString(pDX, IDC_CAMERANUM, m_strCameraNumber);
  DDX_Text(pDX, IDC_USERNAME, m_strMediaUsername);
  DDX_Text(pDX, IDC_PASSWORD, m_strMediaPassword);
  DDX_Text(pDX, IDC_MEDIAURL, m_strMediaURL);
  DDX_Text(pDX, IDC_VIDEOFORMAT, m_strVideoFormat);
  DDX_Control(pDX, IDC_MEDIATYPE, m_MediaTypeCtrl);
}

BEGIN_MESSAGE_MAP(CLiveViewPlayerDlg, CDialog)
	//}}AFX_MSG_MAP
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_EN_CHANGE(IDC_ADDRESS, &CLiveViewPlayerDlg::OnEnChangeAddress)
	ON_CBN_SELENDOK(IDC_CAMERANUM, &CLiveViewPlayerDlg::OnCbnSelendokCameranum)
	ON_CBN_SELENDOK(IDC_CONNTYPE, &CLiveViewPlayerDlg::OnCbnSelendokConntype)
	ON_BN_CLICKED(IDC_PLAY, &CLiveViewPlayerDlg::OnBnClickedPlay)
ON_CBN_SELENDOK(IDC_MEDIATYPE, &CLiveViewPlayerDlg::OnCbnSelendokMediaType)
END_MESSAGE_MAP()


void CLiveViewPlayerDlg::UpdateURL()
{
	// Refresh class member control variables
	UpdateData(true);

	// Get index to selected connection type
	int nConnSelection = m_ConnTypeCtrl.GetCurSel();
  int nMediaTypeSelection = m_MediaTypeCtrl.GetCurSel();

	// Handle MJPEG connection
	if (strcmp(URL_TYPES[nConnSelection], "axmphttp") == 0)
	{
		m_strMediaURL.Format("%s://%s/axis-cgi/mjpg/video.cgi?camera=%s",
			URL_TYPES[nConnSelection], m_strServerAddress, m_strCameraNumber);
		m_strVideoFormat = "MJPEG";
	}
	// Handle MPEG-4 connection
	else if (strcmp(URL_MEDIATYPES[nMediaTypeSelection], "MPEG4") == 0)
	{
		m_strMediaURL.Format("%s://%s/mpeg4/%s/media.amp",
			URL_TYPES[nConnSelection], m_strServerAddress, m_strCameraNumber);
		m_strVideoFormat = "MPEG-4";
	}
  // Handle MPEG-4 connection
	else if (strcmp(URL_MEDIATYPES[nMediaTypeSelection], "H264") == 0)
	{
		m_strMediaURL.Format("%s://%s/axis-media/media.amp?camera=%s&videocodec=h264",
			URL_TYPES[nConnSelection], m_strServerAddress, m_strCameraNumber);
		m_strVideoFormat = "H264";
	}
  else if (strcmp(URL_MEDIATYPES[nMediaTypeSelection], "MJPEG") == 0)
	{
		m_strMediaURL.Format("%s://%s/axis-media/media.amp?camera=%s&videocodec=jpeg",
			URL_TYPES[nConnSelection], m_strServerAddress, m_strCameraNumber);
		m_strVideoFormat = "MJPEG";
	}

	// Update dialog controls with new values
	UpdateData(false);
}

// CLiveViewPlayerDlg message handlers

BOOL CLiveViewPlayerDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// View "MJPEG" as default
	m_ConnTypeCtrl.SetCurSel(5);
  m_MediaTypeCtrl.SetCurSel(0);
  m_MediaTypeCtrl.EnableWindow(false);
	UpdateURL();

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CLiveViewPlayerDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CLiveViewPlayerDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}


void CLiveViewPlayerDlg::OnEnChangeAddress()
{
	UpdateURL();
}

void CLiveViewPlayerDlg::OnCbnSelendokCameranum()
{
	UpdateURL();
}

void CLiveViewPlayerDlg::OnCbnSelendokConntype()
{
   // Get index to selected connection type
	int nSelection = m_ConnTypeCtrl.GetCurSel();

  // Set mediatype to MJPEG and disable mediatype selection if HTTP is selected.
	if (strcmp(URL_TYPES[nSelection], "axmphttp") == 0)
	{
		m_MediaTypeCtrl.SetCurSel(0);
    m_MediaTypeCtrl.EnableWindow(false);
	}
  else
  {
    m_MediaTypeCtrl.EnableWindow(true);
  }
	UpdateURL();
}
void CLiveViewPlayerDlg::OnCbnSelendokMediaType()
{
  UpdateURL();
}

void CLiveViewPlayerDlg::OnBnClickedPlay()
{
	// Define local variables
	CLiveViewDlg LiveViewDlg;

	// Refresh class member control variables
	UpdateData(true);

	// Setup live view dialog
	LiveViewDlg.SetMediaURL(m_strMediaURL);
	LiveViewDlg.SetMediaUsername(m_strMediaUsername);
	LiveViewDlg.SetMediaPassword(m_strMediaPassword);

	// Display live view dialog and start video
	LiveViewDlg.DoModal();
}