/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.ParserFactory;

class XMLParser
extends HandlerBase {
    public static boolean DEBUG_INFO = false;
    public static final String SAX_DRIVER = "com.ibm.xml.parser.SAXDriver";
    private Hashtable myAxisSitesDict;
    private Hashtable myBoxTypes;
    private BoxType myActiveBoxType;
    private BoxModel myActiveBoxModel;
    private Hashtable myRegularExpressionCache = new Hashtable();
    private String myBIOSDetectionString = null;

    XMLParser() {
    }

    protected static String getParameter(AttributeList attributeList, String string) {
        for (int i = 0; i < attributeList.getLength(); ++i) {
            String string2 = attributeList.getName(i);
            if (!string2.equals(string)) continue;
            return attributeList.getValue(i);
        }
        return null;
    }

    protected String getBIOSDetectionString() {
        return this.myBIOSDetectionString;
    }

    @Override
    public void startDocument() throws SAXException {
        this.myAxisSitesDict = new Hashtable();
        this.myBoxTypes = new Hashtable();
    }

    @Override
    public void startElement(String string, AttributeList attributeList) {
        if (string.equals("site")) {
            this.myAxisSitesDict.put(XMLParser.getParameter(attributeList, "name"), XMLParser.getParameter(attributeList, "url"));
        } else if (string.equals("biosstate")) {
            this.myBIOSDetectionString = XMLParser.getParameter(attributeList, "detectionstring");
        } else if (string.equals("boxtype")) {
            String string2 = XMLParser.getParameter(attributeList, "name");
            this.myActiveBoxType = new BoxType(string2);
            this.myBoxTypes.put(string2, this.myActiveBoxType);
        } else if (string.equals("boxmodel")) {
            this.myActiveBoxModel = new BoxModel(XMLParser.getParameter(attributeList, "name"), XMLParser.getParameter(attributeList, "nohttp").toUpperCase().equals("TRUE"), XMLParser.getParameter(attributeList, "noflashload").toUpperCase().equals("TRUE"), XMLParser.getParameter(attributeList, "detectionstring"), XMLParser.getParameter(attributeList, "htmldetectionstring"), XMLParser.getParameter(attributeList, "detectionstring2"));
            this.myActiveBoxType.addBoxModel(this.myActiveBoxModel);
        } else if (string.equals("software")) {
            Firmware firmware = new Firmware(this.myActiveBoxType.getName(), this.myActiveBoxModel.getName(), XMLParser.getParameter(attributeList, "revision"), XMLParser.getParameter(attributeList, "altrevision"), XMLParser.getParameter(attributeList, "fileurl"), XMLParser.getParameter(attributeList, "alternativefileurl"), XMLParser.getParameter(attributeList, "release"), "");
            this.myActiveBoxModel.addFirmware(firmware);
        }
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        if (DEBUG_INFO) {
            System.err.println("Error :" + sAXParseException);
        }
        throw sAXParseException;
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        if (DEBUG_INFO) {
            System.err.println("Fatal error :" + sAXParseException);
        }
        throw sAXParseException;
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
        if (DEBUG_INFO) {
            System.err.println("Warning :" + sAXParseException);
        }
        throw sAXParseException;
    }

    public void parseDocument(String string) throws IOException, SAXException {
        try {
            Parser parser = ParserFactory.makeParser(SAX_DRIVER);
            parser.setDocumentHandler(this);
            parser.setErrorHandler(this);
            parser.parse(string);
        }
        catch (SAXException sAXException) {
            throw sAXException;
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    protected Hashtable getAxisSitesDict() {
        return this.myAxisSitesDict;
    }

    protected Hashtable getBoxTypes() {
        return this.myBoxTypes;
    }

    protected static class BoxModel {
        Vector myFirmware = new Vector();
        String myName;
        boolean myNoHTTP;
        boolean myNoFlashload;
        String myDetectionString;
        String myHTMLDetectionString;
        String myDetectionString2;
        String myDetectionString3;

        public BoxModel(String string, boolean bl, boolean bl2, String string2, String string3, String string4) {
            this.myName = string;
            this.myNoHTTP = bl;
            this.myNoFlashload = bl2;
            this.myDetectionString = string2;
            this.myHTMLDetectionString = string3;
            this.myDetectionString2 = string4;
        }

        public String getName() {
            return this.myName;
        }

        public boolean getNoHTTP() {
            return this.myNoHTTP;
        }

        public boolean getNoFlashload() {
            return this.myNoFlashload;
        }

        public String getDetectionString() {
            return this.myDetectionString;
        }

        public String getDetectionString2() {
            return this.myDetectionString2;
        }

        public String getHTMLDetectionString() {
            return this.myHTMLDetectionString;
        }

        public void addFirmware(Firmware firmware) {
            this.myFirmware.addElement(firmware);
        }

        Vector getFirmware() {
            return this.myFirmware;
        }

        public String toString() {
            return "(BoxModel: " + this.myName + ")";
        }
    }

    protected static class BoxType {
        String myName;
        Vector myBoxModels = new Vector();

        public BoxType(String string) {
            this.myName = string;
        }

        public void addBoxModel(BoxModel boxModel) {
            this.myBoxModels.addElement(boxModel);
        }

        public Vector getBoxModels() {
            return this.myBoxModels;
        }

        public String getName() {
            return this.myName;
        }

        public String toString() {
            return "(BoxType: " + this.myName + ")";
        }
    }
}

