/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.parser;

import com.ibm.xml.parser.Child;
import com.ibm.xml.parser.ExternalID;
import com.ibm.xml.parser.Parser;
import com.ibm.xml.parser.Source;
import com.ibm.xml.parser.Token;
import com.ibm.xml.parser.Visitor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;

public class Entity
extends Child {
    String name;
    boolean isParameter = false;
    String value;
    ExternalID externalID;
    String ndata;
    byte[] rawByteStream;
    String encoding;
    char[] rawCharStream;

    public Entity(String string, String string2, boolean bl) {
        this.name = string;
        this.value = string2;
        this.isParameter = bl;
    }

    public Entity(String string, ExternalID externalID, boolean bl, String string2) {
        this.name = string;
        this.externalID = externalID;
        this.isParameter = bl;
        this.ndata = string2;
    }

    public synchronized Object clone() {
        this.checkFactory();
        Entity entity = this.factory.createEntity(this.name, this.value, this.isParameter);
        entity.setFactory(this.getFactory());
        entity.externalID = this.externalID;
        entity.ndata = this.ndata;
        entity.rawByteStream = this.rawByteStream;
        entity.rawCharStream = this.rawCharStream;
        entity.encoding = this.encoding;
        return entity;
    }

    public int getNodeType() {
        return 15;
    }

    public String getName() {
        return this.name;
    }

    public boolean isParameter() {
        return this.isParameter;
    }

    public String getValue() {
        return this.value;
    }

    public ExternalID getExternalID() {
        return this.externalID;
    }

    public boolean isExternal() {
        return this.externalID != null;
    }

    public String getNDATAType() {
        return this.ndata;
    }

    public boolean isNDATA() {
        return this.ndata != null;
    }

    public void acceptPre(Visitor visitor) throws Exception {
        visitor.visitEntityPre(this);
    }

    public void acceptPost(Visitor visitor) throws Exception {
        visitor.visitEntityPost(this);
    }

    void load(Parser parser) throws IOException {
        if (this.getExternalID() != null && (this.rawByteStream == null || this.rawCharStream == null)) {
            try {
                int n;
                Source source = parser.streamProducer.getInputStream(this.name, this.externalID.getPubidLiteral(), this.externalID.getSystemLiteral());
                if (source.getInputStream() != null) {
                    int n2;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    InputStream inputStream = source.getInputStream();
                    while ((n2 = inputStream.read()) >= 0) {
                        byteArrayOutputStream.write(n2);
                    }
                    inputStream.close();
                    ((OutputStream)byteArrayOutputStream).close();
                    this.rawByteStream = byteArrayOutputStream.toByteArray();
                    this.encoding = source.getEncoding();
                    return;
                }
                CharArrayWriter charArrayWriter = new CharArrayWriter();
                Reader reader = source.getReader();
                while ((n = reader.read()) >= 0) {
                    charArrayWriter.write(n);
                }
                reader.close();
                charArrayWriter.close();
                this.rawCharStream = charArrayWriter.toCharArray();
                return;
            }
            catch (IOException iOException) {
                this.rawByteStream = new byte[0];
                this.rawCharStream = new char[0];
                throw iOException;
            }
        }
    }

    Source getInputStream() {
        if (this.rawByteStream != null) {
            return new Source(new ByteArrayInputStream(this.rawByteStream), this.encoding);
        }
        return new Source(new CharArrayReader(this.rawCharStream));
    }

    void setValue(String string) {
        this.value = string;
    }

    Token createToken(Parser parser, Token token) throws IOException {
        Token token2;
        if (this.getExternalID() != null) {
            try {
                this.load(parser);
            }
            catch (FileNotFoundException fileNotFoundException) {
                parser.format1(token, "E_IO0", this.getExternalID().getSystemLiteral());
            }
            token2 = new Token(parser, this.getExternalID().getSystemLiteral(), this.getInputStream());
        } else {
            token2 = new Token(parser, this.getValue());
            token2.getReading().setNext(token.getReading());
            token2.m_follow = false;
        }
        return token2;
    }
}

