/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.parser;

import com.ibm.xml.parser.Attlist;
import com.ibm.xml.parser.Child;
import com.ibm.xml.parser.DTD;
import com.ibm.xml.parser.ElementDecl;
import com.ibm.xml.parser.Entity;
import com.ibm.xml.parser.TXCDATASection;
import com.ibm.xml.parser.TXComment;
import com.ibm.xml.parser.TXDocument;
import com.ibm.xml.parser.TXElement;
import com.ibm.xml.parser.TXNotation;
import com.ibm.xml.parser.TXPI;
import com.ibm.xml.parser.TXText;
import com.ibm.xml.parser.ToXMLStringVisitor;
import com.ibm.xml.parser.Util;
import com.ibm.xml.parser.Visitor;
import java.io.IOException;
import java.io.Writer;
import java.util.Stack;
import org.w3c.dom.CDATASection;

public class FormatPrintVisitor
extends ToXMLStringVisitor
implements Visitor {
    protected int currentIndent;
    protected int indent = 2;
    protected boolean ispreserve = false;
    protected Stack preserves = new Stack();
    protected boolean isprevtext = false;

    public FormatPrintVisitor(Writer writer, String string, int n) {
        super(writer, string);
        this.indent = n;
    }

    public FormatPrintVisitor(Writer writer, String string) {
        this(writer, string, 2);
    }

    public FormatPrintVisitor(Writer writer) {
        this(writer, null, 2);
    }

    public void visitDocumentPost(TXDocument tXDocument) throws IOException {
        this.writer.write(10);
        super.visitDocumentPost(tXDocument);
    }

    public void visitElementPre(TXElement tXElement) throws IOException {
        Object object;
        if (!this.ispreserve && !this.isprevtext) {
            object = this.writer;
            int n = this.currentIndent;
            ((Writer)object).write("\n");
            Util.printSpace((Writer)object, n);
        }
        super.visitElementPre(tXElement);
        this.currentIndent += this.indent;
        if (tXElement.hasChildNodes()) {
            Object object2;
            object = (Child)tXElement.getFirstChild();
            this.preserves.push(new Boolean(this.ispreserve));
            this.ispreserve = tXElement.children.getLength() == 1 && !((object2 = object) instanceof TXCDATASection) && (object2 instanceof TXText || false) ? true : tXElement.isPreserveSpace();
        }
        this.isprevtext = false;
    }

    public void visitElementPost(TXElement tXElement) throws IOException {
        this.currentIndent -= this.indent;
        if (tXElement.hasChildNodes()) {
            if (!this.ispreserve && !this.isprevtext) {
                Writer writer = this.writer;
                int n = this.currentIndent;
                writer.write("\n");
                Util.printSpace(writer, n);
            }
            this.writer.write("</" + tXElement.getTagName() + ">");
            this.ispreserve = (Boolean)this.preserves.pop();
        }
        this.isprevtext = false;
    }

    public void visitPIPre(TXPI tXPI) throws IOException {
        if (!this.ispreserve && !this.isprevtext) {
            Writer writer = this.writer;
            int n = this.currentIndent;
            writer.write("\n");
            Util.printSpace(writer, n);
        }
        super.visitPIPre(tXPI);
    }

    public void visitCommentPre(TXComment tXComment) throws IOException {
        if (!this.ispreserve && !this.isprevtext) {
            Writer writer = this.writer;
            int n = this.currentIndent;
            writer.write("\n");
            Util.printSpace(writer, n);
        }
        super.visitCommentPre(tXComment);
    }

    public void visitTextPre(TXText tXText) throws IOException {
        if (!this.ispreserve && tXText.getIsIgnorableWhitespace()) {
            this.isprevtext = false;
            return;
        }
        if (tXText instanceof CDATASection) {
            if (!this.ispreserve && !this.isprevtext) {
                Writer writer = this.writer;
                int n = this.currentIndent;
                writer.write("\n");
                Util.printSpace(writer, n);
            }
            this.writer.write("<![CDATA[" + tXText.getData() + "]]>");
            return;
        }
        this.writer.write(Util.backReference(tXText.getData(), this.encoding));
        this.isprevtext = true;
    }

    public void visitDTDPre(DTD dTD) throws IOException {
        Object object = this.writer;
        int n = this.currentIndent;
        ((Writer)object).write("\n");
        Util.printSpace((Writer)object, n);
        this.writer.write("<!DOCTYPE " + dTD.getName() + " ");
        if (dTD.getExternalID() != null) {
            this.writer.write(String.valueOf(dTD.getExternalID()) + " ");
        }
        if (dTD.isPrintInternalDTD() && dTD.getInternalSize() > 0) {
            this.writer.write("[");
            object = dTD.internalElements();
            while (object.hasMoreElements()) {
                ((Child)object.nextElement()).toXMLString(this.writer, this.encoding);
            }
            this.writer.write("]");
        }
        this.currentIndent += this.indent;
    }

    public void visitDTDPost(DTD dTD) throws IOException {
        this.currentIndent -= this.indent;
        if (dTD.isPrintInternalDTD() && dTD.getInternalSize() > 0) {
            this.writer.write("]");
        }
        this.writer.write(">");
    }

    public void visitElementDeclPre(ElementDecl elementDecl) throws IOException {
        Util.printSpace(this.writer, this.currentIndent);
        super.visitElementDeclPre(elementDecl);
        this.writer.write(10);
    }

    public void visitAttlistPre(Attlist attlist) throws IOException {
        Util.printSpace(this.writer, this.currentIndent);
        super.visitAttlistPre(attlist);
        this.writer.write(10);
    }

    public void visitEntityPre(Entity entity) throws IOException {
        Util.printSpace(this.writer, this.currentIndent);
        super.visitEntityPre(entity);
        this.writer.write(10);
    }

    public void visitNotationPre(TXNotation tXNotation) throws IOException {
        Util.printSpace(this.writer, this.currentIndent);
        super.visitNotationPre(tXNotation);
        this.writer.write(10);
    }
}

