/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.parser;

import com.ibm.xml.parser.Child;
import com.ibm.xml.parser.TXNodeList;
import java.util.Enumeration;
import org.w3c.dom.NoSuchNodeException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeIterator;
import org.w3c.dom.NotMyChildException;

public abstract class Parent
extends Child {
    TXNodeList children = new TXNodeList();

    public NodeIterator getChildNodes() {
        return this.children.getIterator();
    }

    public boolean hasChildNodes() {
        return this.children.getLength() > 0;
    }

    public Enumeration elements() {
        return this.children.elements();
    }

    public Child[] getChildrenArray() {
        Child[] childArray = new Child[this.children.getLength()];
        int n = 0;
        while (n < this.children.getLength()) {
            childArray[n] = this.children.item(n);
            ++n;
        }
        return childArray;
    }

    public Node getFirstChild() {
        if (this.children.getLength() > 0) {
            return this.children.item(0);
        }
        return null;
    }

    public void insert(Child child, int n) throws NoSuchNodeException {
        this.children.insert(n, child);
        child.setParent(this);
        this.clearDigest();
    }

    public Node insertBefore(Node node, Node node2) throws NotMyChildException {
        if (node2 == null) {
            this.insert((Child)node, this.children.getLength());
        } else {
            int n = this.children.indexOf(node2);
            if (n < 0) {
                throw new NotMyChildException();
            }
            this.insert((Child)node, n);
        }
        return node;
    }

    public Node insertAfter(Node node, Node node2) throws NotMyChildException {
        if (node2 == null) {
            this.insert((Child)node, 0);
        } else {
            this.insertBefore(node, node2.getPreviousSibling());
        }
        return node;
    }

    public Node insertFirst(Node node) {
        this.insert((Child)node, 0);
        return node;
    }

    public Node insertLast(Node node) {
        this.insert((Child)node, this.children.getLength());
        return node;
    }

    public void addElement(Child child) {
        if (child != null) {
            this.insert(child, this.children.getLength());
        }
    }

    public Node replaceChild(Node node, Node node2) throws NotMyChildException {
        int n = this.children.indexOf(node2);
        if (n < 0) {
            throw new NotMyChildException();
        }
        Child child = (Child)node;
        this.children.replace(n, child);
        child.setParent(this);
        this.clearDigest();
        return node2;
    }

    public Node removeChild(Node node) throws NotMyChildException {
        int n = this.children.indexOf(node);
        if (n < 0) {
            throw new NotMyChildException();
        }
        this.children.remove(n);
        this.clearDigest();
        return node;
    }
}

