/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.parser;

import com.ibm.xml.parser.AttDef;
import com.ibm.xml.parser.DTD;
import com.ibm.xml.parser.DefaultElementFactory;
import com.ibm.xml.parser.Entity;
import com.ibm.xml.parser.ErrorListener;
import com.ibm.xml.parser.ExternalID;
import com.ibm.xml.parser.NamespacePI;
import com.ibm.xml.parser.Parser;
import com.ibm.xml.parser.Source;
import com.ibm.xml.parser.StreamProducer;
import com.ibm.xml.parser.StylesheetPI;
import com.ibm.xml.parser.TXAttribute;
import com.ibm.xml.parser.TXCDATASection;
import com.ibm.xml.parser.TXElement;
import com.ibm.xml.parser.TXNotation;
import com.ibm.xml.parser.TXPI;
import com.ibm.xml.parser.TXText;
import com.ibm.xml.parser.TagHandler;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.Stack;
import org.xml.sax.AttributeList;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;

public class SAXDriver
extends DefaultElementFactory
implements org.xml.sax.Parser,
AttributeList,
ErrorListener,
TagHandler,
StreamProducer {
    static HandlerBase s_defaulthandler = new HandlerBase();
    Parser parser;
    Locale locale;
    EntityResolver entityHandler = s_defaulthandler;
    DTDHandler dtdHandler = s_defaulthandler;
    DocumentHandler documentHandler = s_defaulthandler;
    ErrorHandler errorHandler = s_defaulthandler;
    TXAttribute[] attributes;
    DTD dtd;
    String currentSystemID;
    Stack stack = new Stack();
    int depth;

    public void setLocale(Locale locale) throws SAXException {
        this.locale = locale;
        if (this.parser != null) {
            this.parser.setLocale(locale);
        }
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityHandler = entityResolver;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.dtdHandler = dTDHandler;
    }

    public void setDocumentHandler(DocumentHandler documentHandler) {
        this.documentHandler = documentHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void parse(InputSource inputSource) throws SAXException {
        this.currentSystemID = inputSource.getSystemId();
        this.documentHandler.startDocument();
        try {
            this.parser = new Parser(this.currentSystemID, this, this);
            if (this.locale != null) {
                this.parser.setLocale(this.locale);
            }
            this.parser.setElementFactory(this);
            this.parser.setTagHandler(this);
            this.stack.push(this.currentSystemID);
            if (inputSource.getByteStream() != null) {
                this.parser.readStream(inputSource.getByteStream());
            } else if (inputSource.getCharacterStream() != null) {
                this.parser.readStream(inputSource.getCharacterStream());
            } else {
                this.parser.readStream(this.getInputStream(this.currentSystemID, null, this.currentSystemID));
            }
        }
        catch (ExceptionWrapper exceptionWrapper) {
            this.parser = null;
            throw exceptionWrapper.wrapped;
        }
        catch (Exception exception) {
            this.parser = null;
            throw new SAXException(exception);
        }
        this.documentHandler.endDocument();
        this.parser = null;
        this.locale = null;
        this.entityHandler = null;
        this.dtdHandler = null;
        this.documentHandler = null;
        this.errorHandler = null;
        this.attributes = null;
        this.dtd = null;
        this.currentSystemID = null;
        this.stack = null;
    }

    public void parse(String string) throws SAXException {
        this.parse(new InputSource(string));
    }

    public int getLength() {
        return this.attributes.length;
    }

    public String getName(int n) {
        return this.attributes[n].getName();
    }

    public String getType(int n) {
        int n2 = this.attributes[n].getType();
        if (n2 == 0) {
            n2 = 1;
        }
        return AttDef.S_TYPESTR[n2];
    }

    public String getType(String string) {
        int n = this.searchAttribute(string);
        if (n < 0) {
            return null;
        }
        return this.getType(n);
    }

    public String getValue(int n) {
        return this.attributes[n].getValue();
    }

    public String getValue(String string) {
        int n = this.searchAttribute(string);
        if (n < 0) {
            return null;
        }
        return this.getValue(n);
    }

    public Source getInputStream(String string, String string2, String string3) throws IOException, RuntimeException {
        if (string3 == null) {
            return null;
        }
        try {
            InputSource inputSource = this.entityHandler.resolveEntity(string2, string3);
            URL uRL = new URL(new URL(this.currentSystemID), string3);
            this.currentSystemID = uRL.toString();
            this.stack.push(this.currentSystemID);
            if (inputSource == null || inputSource.getSystemId() != null) {
                return new Source(uRL.openStream());
            }
            if (inputSource.getByteStream() != null) {
                return new Source(inputSource.getByteStream());
            }
            return new Source(inputSource.getCharacterStream());
        }
        catch (MalformedURLException malformedURLException) {
            return new Source(new FileInputStream(string3));
        }
        catch (SAXException sAXException) {
            throw new ExceptionWrapper(sAXException);
        }
    }

    public void closeInputStream(Source source) {
        try {
            this.currentSystemID = (String)this.stack.pop();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void loadCatalog(Reader reader) throws IOException {
    }

    public void error(String string, int n, int n2, Object object, String string2) throws RuntimeException {
        LocatorImpl locatorImpl = new LocatorImpl();
        locatorImpl.setSystemId(string);
        locatorImpl.setLineNumber(n);
        locatorImpl.setColumnNumber(n2);
        SAXParseException sAXParseException = new SAXParseException(string2, locatorImpl);
        try {
            if (object instanceof String && ((String)object).startsWith("W_")) {
                this.errorHandler.warning(sAXParseException);
                return;
            }
            this.errorHandler.error(sAXParseException);
            return;
        }
        catch (SAXException sAXException) {
            throw new ExceptionWrapper(sAXException);
        }
    }

    public void handleStartTag(TXElement tXElement, boolean bl) throws RuntimeException {
        ++this.depth;
        this.attributes = tXElement.getAttributeArray();
        try {
            this.documentHandler.startElement(tXElement.getName(), this);
        }
        catch (SAXException sAXException) {
            throw new ExceptionWrapper(sAXException);
        }
        this.attributes = null;
    }

    public void handleEndTag(TXElement tXElement, boolean bl) throws RuntimeException {
        --this.depth;
        try {
            this.documentHandler.endElement(tXElement.getName());
            return;
        }
        catch (SAXException sAXException) {
            throw new ExceptionWrapper(sAXException);
        }
    }

    public DTD createDTD(String string, ExternalID externalID) {
        this.dtd = super.createDTD(string, externalID);
        return this.dtd;
    }

    public Entity createEntity(String string, ExternalID externalID, boolean bl, String string2) throws RuntimeException {
        if (string2 != null) {
            try {
                this.dtdHandler.unparsedEntityDecl(string, externalID.getPubidLiteral(), externalID.getSystemLiteral(), string2);
            }
            catch (SAXException sAXException) {
                throw new ExceptionWrapper(sAXException);
            }
        }
        return super.createEntity(string, externalID, bl, string2);
    }

    public TXNotation createNotation(String string, ExternalID externalID) throws RuntimeException {
        try {
            this.dtdHandler.notationDecl(string, externalID.getPubidLiteral(), externalID.getSystemLiteral());
        }
        catch (SAXException sAXException) {
            throw new ExceptionWrapper(sAXException);
        }
        return super.createNotation(string, externalID);
    }

    public TXText createText(char[] cArray, int n, int n2, boolean bl) throws RuntimeException {
        if (this.depth > 0) {
            try {
                if (bl) {
                    this.documentHandler.ignorableWhitespace(cArray, n, n2);
                } else {
                    this.documentHandler.characters(cArray, n, n2);
                }
            }
            catch (SAXException sAXException) {
                throw new ExceptionWrapper(sAXException);
            }
        }
        return null;
    }

    public TXCDATASection createCDATA(String string) throws RuntimeException {
        try {
            char[] cArray = string.toCharArray();
            this.documentHandler.characters(cArray, 0, cArray.length);
        }
        catch (SAXException sAXException) {
            throw new ExceptionWrapper(sAXException);
        }
        return super.createCDATA(string);
    }

    public TXPI createPI(String string, String string2) throws RuntimeException {
        try {
            this.documentHandler.processingInstruction(string, string2);
        }
        catch (SAXException sAXException) {
            throw new ExceptionWrapper(sAXException);
        }
        return null;
    }

    public NamespacePI createNamespacePI(String string, String string2, String string3, String string4, String string5) throws RuntimeException {
        try {
            this.documentHandler.processingInstruction(string, string2);
        }
        catch (SAXException sAXException) {
            throw new ExceptionWrapper(sAXException);
        }
        return null;
    }

    public StylesheetPI createStylesheetPI(String string, String string2, String string3, String string4, String string5) throws RuntimeException {
        try {
            this.documentHandler.processingInstruction(string, string2);
        }
        catch (SAXException sAXException) {
            throw new ExceptionWrapper(sAXException);
        }
        return null;
    }

    private int searchAttribute(String string) {
        int n = 0;
        while (n < this.attributes.length) {
            if (string.equals(this.attributes[n].getName())) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    class ExceptionWrapper
    extends RuntimeException {
        SAXException wrapped;

        ExceptionWrapper(SAXException sAXException) {
            super(sAXException.getMessage());
            SAXDriver.this = SAXDriver.this;
            this.wrapped = sAXException;
        }

        public String getMessage() {
            return this.wrapped.getMessage();
        }
    }
}

