/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.parser;

import com.ibm.xml.parser.Child;
import com.ibm.xml.parser.DTD;
import com.ibm.xml.parser.FormatPrintVisitor;
import com.ibm.xml.parser.LibraryException;
import com.ibm.xml.parser.Namespace;
import com.ibm.xml.parser.NamespacePI;
import com.ibm.xml.parser.NonRecursivePreorderTreeTraversal;
import com.ibm.xml.parser.Parent;
import com.ibm.xml.parser.TXAttribute;
import com.ibm.xml.parser.TXAttributeList;
import com.ibm.xml.parser.TXComment;
import com.ibm.xml.parser.TXDocumentContext;
import com.ibm.xml.parser.TXElement;
import com.ibm.xml.parser.TXPI;
import com.ibm.xml.parser.TXText;
import com.ibm.xml.parser.VectorNodeIterator;
import com.ibm.xml.parser.Visitor;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.dom.Attribute;
import org.w3c.dom.AttributeList;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeIterator;
import org.w3c.dom.PI;
import org.w3c.dom.Text;
import org.w3c.dom.TreeIterator;

public class TXDocument
extends Parent
implements Document {
    DocumentContext documentContext;
    TXElement rootElement;
    DTD doctype;
    String standalone;
    String xmlVersion;
    String xmlEncoding;
    Hashtable nsHash = new Hashtable();

    public TXDocument() {
        this.addNamespace(new NamespacePI("", "xml"));
    }

    public synchronized Object clone() {
        this.checkFactory();
        TXDocument tXDocument = this.factory.createDocument();
        tXDocument.setFactory(this.getFactory());
        tXDocument.standalone = this.standalone;
        tXDocument.xmlVersion = this.xmlVersion;
        tXDocument.xmlEncoding = this.xmlEncoding;
        tXDocument.documentContext = this.documentContext;
        tXDocument.children.ensureCapacity(this.children.getLength());
        int n = 0;
        while (n < this.children.getLength()) {
            tXDocument.addElement((Child)this.children.item(n).clone());
            ++n;
        }
        return tXDocument;
    }

    public int getNodeType() {
        return 1;
    }

    public DocumentContext getContextInfo() {
        return this.documentContext;
    }

    public void setContextInfo(DocumentContext documentContext) {
        this.documentContext = documentContext;
    }

    public Element getDocumentElement() {
        return this.rootElement;
    }

    public void setDocumentElement(Element element) {
        this.rootElement = (TXElement)element;
    }

    public String getRootName() {
        if (this.rootElement == null) {
            return null;
        }
        return this.rootElement.getTagName();
    }

    public NodeIterator getElementsByTagName(String string) {
        if (this.rootElement != null) {
            return this.rootElement.getElementsByTagName(string);
        }
        return VectorNodeIterator.emptyIterator;
    }

    public Node getDocumentType() {
        return this.doctype;
    }

    public DTD getDTD() {
        return this.doctype;
    }

    public void setDocumentType(Node node) {
        this.doctype = (DTD)node;
    }

    public boolean isApplySyntax() {
        return this.doctype != null;
    }

    public String getStandalone() {
        return this.standalone;
    }

    public boolean isStandalone() {
        if (this.standalone == null) {
            return false;
        }
        return "yes".equals(this.standalone);
    }

    public void setStandalone(String string) {
        this.standalone = string;
        if (this.xmlVersion == null) {
            this.xmlVersion = "1.0";
        }
    }

    public String getVersion() {
        return this.xmlVersion;
    }

    public void setVersion(String string) {
        this.xmlVersion = string;
    }

    public String getEncoding() {
        return this.xmlEncoding;
    }

    public void setEncoding(String string) {
        this.xmlEncoding = string;
        if (this.xmlVersion == null) {
            this.xmlVersion = "1.0";
        }
    }

    public NamespacePI getNamespaceFor(String string) {
        return (NamespacePI)this.nsHash.get(string);
    }

    public Enumeration getNamespaces() {
        return this.nsHash.elements();
    }

    public void addNamespace(NamespacePI namespacePI) {
        this.nsHash.put(namespacePI.getPrefix(), namespacePI);
    }

    public String setNamespaceParameters(Namespace namespace) {
        String string = null;
        String string2 = namespace.getName();
        int n = string2.indexOf(58);
        if (n > 0) {
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            namespace.setNSLocalName(string4);
            NamespacePI namespacePI = this.getNamespaceFor(string3);
            if (namespacePI != null) {
                namespace.setNSName(namespacePI.getNs());
            } else {
                string = "E_TAGf";
            }
            if (string4.indexOf(58) >= 0) {
                string = "E_TAGe";
            }
        } else {
            namespace.setNSLocalName(string2);
            namespace.setNSName(null);
        }
        return string;
    }

    public void insert(Child child, int n) throws LibraryException {
        super.insert(child, n);
        if (child instanceof DTD) {
            if (this.doctype != null) {
                this.removeChild(this.doctype);
            }
            this.doctype = (DTD)child;
            return;
        }
        if (child instanceof TXElement) {
            if (this.rootElement != null) {
                throw new LibraryException("com.ibm.xml.parser.TXDocument#insert(): Document root Element was set twice.");
            }
            this.setDocumentElement((Element)((Object)child));
            return;
        }
        if (child instanceof NamespacePI) {
            this.addNamespace((NamespacePI)child);
        }
    }

    public void printWithFormat(Writer writer) throws IOException, LibraryException {
        this.printWithFormat(writer, null, 2);
    }

    public void printWithFormat(Writer writer, String string) throws IOException, LibraryException {
        this.printWithFormat(writer, string, 2);
    }

    public void printWithFormat(Writer writer, String string, int n) throws IOException, LibraryException {
        try {
            FormatPrintVisitor formatPrintVisitor = new FormatPrintVisitor(writer, string, n);
            new NonRecursivePreorderTreeTraversal(formatPrintVisitor).traverse(this);
            return;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new LibraryException("com.ibm.xml.parser.TXDocument#printWithFormat(): Unexpected Exception: " + exception.toString());
        }
    }

    public void setPrintInternalDTD(boolean bl) {
        if (this.doctype != null) {
            this.doctype.setPrintInternalDTD(bl);
        }
    }

    public String getText() {
        if (this.rootElement != null) {
            return this.rootElement.getText();
        }
        return "";
    }

    public Document getMasterDoc() {
        return null;
    }

    public void setMasterDoc(Document document) {
    }

    public DocumentContext createDocumentContext() {
        return new TXDocumentContext();
    }

    public Element createElement(String string, AttributeList attributeList) {
        TXElement tXElement = new TXElement(string);
        tXElement.setAttributes(attributeList);
        return tXElement;
    }

    public Text createTextNode(String string) {
        return new TXText(string);
    }

    public Comment createComment(String string) {
        return new TXComment(string);
    }

    public PI createPI(String string, String string2) {
        return new TXPI(string, string2);
    }

    public Attribute createAttribute(String string, Node node) {
        TXAttribute tXAttribute = new TXAttribute(string, "");
        return tXAttribute;
    }

    public AttributeList createAttributeList() {
        return new TXAttributeList();
    }

    public TreeIterator createTreeIterator(Node node) {
        return null;
    }

    public void acceptPre(Visitor visitor) throws Exception {
        visitor.visitDocumentPre(this);
    }

    public void acceptPost(Visitor visitor) throws Exception {
        visitor.visitDocumentPost(this);
    }
}

