/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.parser;

import com.ibm.xml.parser.Child;
import com.ibm.xml.parser.LibraryException;
import com.ibm.xml.parser.Match;
import com.ibm.xml.parser.Namespace;
import com.ibm.xml.parser.NamespacePI;
import com.ibm.xml.parser.Parent;
import com.ibm.xml.parser.TXAttribute;
import com.ibm.xml.parser.TXAttributeList;
import com.ibm.xml.parser.TXCDATASection;
import com.ibm.xml.parser.TXDocument;
import com.ibm.xml.parser.TXNodeList;
import com.ibm.xml.parser.TXText;
import com.ibm.xml.parser.VectorNodeIterator;
import com.ibm.xml.parser.Visitor;
import java.util.Enumeration;
import java.util.Vector;
import org.w3c.dom.Attribute;
import org.w3c.dom.AttributeList;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Element;
import org.w3c.dom.NoSuchAttributeException;
import org.w3c.dom.NoSuchNodeException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeIterator;
import org.w3c.dom.Text;

public class TXElement
extends Parent
implements Element,
Namespace {
    String name;
    TXAttributeList attributes;
    boolean isPreserveSpace = false;
    String language;
    String nsLocalName;
    String nsURI;

    public TXElement(String string) {
        this.setTagName(string);
    }

    public TXElement(TXDocument tXDocument, String string, String string2) {
        this.nsLocalName = string2;
        if (string != null) {
            NamespacePI namespacePI = tXDocument.getNamespaceFor(string);
            if (namespacePI == null) {
                throw new LibraryException("com.ibm.xml.parser.TXElement: no namespace for prefix: " + string);
            }
            this.nsURI = namespacePI.getNs();
            this.name = String.valueOf(string) + ":" + string2;
        }
    }

    public synchronized Object clone() {
        TXElement tXElement = this.cloneWithoutChildren();
        tXElement.children.ensureCapacity(this.children.getLength());
        int n = 0;
        while (n < this.children.getLength()) {
            tXElement.insertBefore((Node)this.children.item(n).clone(), null);
            ++n;
        }
        return tXElement;
    }

    public synchronized TXElement cloneWithoutChildren() {
        this.checkFactory();
        TXElement tXElement = this.factory.createElement(this.getTagName());
        tXElement.setFactory(this.getFactory());
        tXElement.setNSLocalName(this.getNSLocalName());
        tXElement.setNSName(this.getNSName());
        tXElement.setPreserveSpace(this.isPreserveSpace);
        if (this.attributes != null) {
            tXElement.setAttributes((TXAttributeList)this.attributes.clone());
        }
        return tXElement;
    }

    public int getNodeType() {
        return 2;
    }

    public String getTagName() {
        return this.name;
    }

    public String getName() {
        return this.getTagName();
    }

    public void setTagName(String string) {
        this.name = string;
        this.clearDigest();
    }

    public String getAttribute(String string) {
        if (this.attributes != null) {
            TXAttribute tXAttribute = (TXAttribute)this.attributes.getAttribute(string);
            if (tXAttribute == null) {
                return null;
            }
            return tXAttribute.getValue();
        }
        return null;
    }

    public Attribute getAttributeNode(String string) {
        if (this.attributes != null) {
            return this.attributes.getAttribute(string);
        }
        return null;
    }

    public void setAttribute(String string, String string2) {
        this.checkFactory();
        this.setAttribute(this.factory.createAttribute(string, string2));
    }

    public void setAttribute(TXAttribute tXAttribute) {
        this.makeAttributeList();
        this.attributes.setAttribute(tXAttribute);
        if ("xml:lang".equals(tXAttribute.getName())) {
            this.language = tXAttribute.getValue();
        }
    }

    public void setAttributeNode(Attribute attribute) {
        this.makeAttributeList();
        this.attributes.setAttribute(attribute);
        if ("xml:lang".equals(attribute.getName())) {
            this.language = this.getAttribute("xml:lang");
        }
    }

    public void removeAttribute(String string) throws NoSuchAttributeException {
        if (this.attributes != null) {
            this.attributes.remove(string);
        }
    }

    public void removeAttributeNode(Attribute attribute) throws NoSuchAttributeException {
        String string;
        if (this.attributes != null && (string = this.getAttribute(attribute.getName())) != null && string.equals(attribute.getValue())) {
            this.attributes.remove(attribute.getName());
        }
    }

    public NodeIterator getAttributes() {
        this.makeAttributeList();
        return new VectorNodeIterator(this.attributes);
    }

    public TXAttribute[] getAttributeArray() {
        if (this.attributes == null) {
            return new TXAttribute[0];
        }
        return this.attributes.makeArray();
    }

    public Enumeration attributeElements() {
        this.makeAttributeList();
        return this.attributes.elements();
    }

    public void setAttributes(AttributeList attributeList) throws NoSuchNodeException {
        if (attributeList instanceof TXAttributeList) {
            this.attributes = (TXAttributeList)attributeList;
            this.attributes.setParent(this);
        } else {
            this.attributes.clear();
            AttributeList attributeList2 = attributeList;
            synchronized (attributeList2) {
                try {
                    int n = 0;
                    while (n < attributeList.getLength()) {
                        this.attributes.setAttribute(attributeList.item(n));
                        ++n;
                    }
                }
                catch (NoSuchNodeException noSuchNodeException) {
                    throw new LibraryException("com.ibm.xml.parser.TXElement#setAttributes(): Internet Error: " + noSuchNodeException.toString());
                }
            }
        }
        this.clearDigest();
    }

    public String getNSLocalName() {
        return this.nsLocalName;
    }

    public void setNSLocalName(String string) {
        this.nsLocalName = string;
    }

    public String getNSName() {
        return this.nsURI;
    }

    public void setNSName(String string) {
        this.nsURI = string;
    }

    public String getUniversalName() {
        if (this.getNSName() == null) {
            return this.getNSLocalName();
        }
        return String.valueOf(this.getNSName()) + ":" + this.getNSLocalName();
    }

    public boolean isEmpty() {
        return this.children.getLength() == 0;
    }

    public int size() {
        return this.children.getLength();
    }

    public Child elementAt(int n) throws NoSuchNodeException {
        return this.children.item(n);
    }

    public boolean isPreserveSpace() {
        return this.isPreserveSpace;
    }

    public void setPreserveSpace(boolean bl) {
        this.isPreserveSpace = bl;
    }

    public String getText() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        TXNodeList tXNodeList = this.children;
        synchronized (tXNodeList) {
            int n = this.children.getLength();
            int n2 = 0;
            while (n2 < n) {
                Child child = this.children.item(n2);
                stringBuffer.append(child.getText());
                ++n2;
            }
        }
        return stringBuffer.toString();
    }

    public String getLanguage() {
        if (this.language != null) {
            return this.language;
        }
        if (this.parent != null && this.parent instanceof TXElement) {
            return ((TXElement)this.parent).getLanguage();
        }
        return null;
    }

    public void normalize() {
    }

    public void addTextElement(TXText tXText) {
        if (tXText == null) {
            return;
        }
        if (tXText instanceof CDATASection) {
            this.addElement(tXText);
            return;
        }
        NodeIterator nodeIterator = this.getChildNodes();
        if (nodeIterator.getLength() == 0) {
            this.addElement(tXText);
            return;
        }
        Node node = nodeIterator.toLastNode();
        Node node2 = node;
        if (!(node2 instanceof TXCDATASection) && (node2 instanceof TXText || false)) {
            ((Text)node).append(tXText.getData());
            if (!tXText.getIsIgnorableWhitespace() || !((TXText)node).getIsIgnorableWhitespace()) {
                ((TXText)node).setIsIgnorableWhitespace(false);
            }
            return;
        }
        this.addElement(tXText);
    }

    public TXElement searchDescendants(String string) {
        return this.searchDescendants(0, null, string);
    }

    public TXElement searchDescendants(int n, String string, String string2) {
        Child child;
        NodeIterator nodeIterator = this.getChildNodes();
        while ((child = (Child)nodeIterator.toNextNode()) != null) {
            if (!(child instanceof TXElement)) continue;
            if (Match.matchName((TXElement)child, n, string, string2)) {
                return (TXElement)child;
            }
            TXElement tXElement = ((TXElement)child).searchDescendants(n, string, string2);
            if (tXElement == null) continue;
            return tXElement;
        }
        return null;
    }

    public TXElement getElementNamed(String string) {
        return this.getNthElementNamed(0, 0, null, string);
    }

    public TXElement getElementNamed(String string, String string2) {
        return this.getNthElementNamed(0, 2, string, string2);
    }

    public TXElement getElementNamed(int n, String string, String string2) {
        return this.getNthElementNamed(0, n, string, string2);
    }

    public TXElement getNthElementNamed(int n, String string) {
        return this.getNthElementNamed(n, 0, null, string);
    }

    public TXElement getNthElementNamed(int n, String string, String string2) {
        return this.getNthElementNamed(n, 2, string, string2);
    }

    public TXElement getNthElementNamed(int n, int n2, String string, String string2) {
        Node node;
        NodeIterator nodeIterator = this.getChildNodes();
        while ((node = nodeIterator.toNextNode()) != null) {
            TXElement tXElement;
            if (!(node instanceof TXElement) || !Match.matchName(tXElement = (TXElement)node, n2, string, string2)) continue;
            if (n == 0) {
                return tXElement;
            }
            --n;
        }
        return null;
    }

    public TXElement[] searchChildrenAll(String string) {
        Node node;
        Vector<Node> vector = new Vector<Node>();
        NodeIterator nodeIterator = this.getChildNodes();
        while ((node = nodeIterator.toNextNode()) != null) {
            if (!(node instanceof Element) || !Match.matchName((Namespace)((Object)node), 0, null, string)) continue;
            vector.addElement(node);
        }
        Object[] objectArray = new TXElement[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public NodeIterator getElementsByTagName(String string) {
        Vector vector = new Vector();
        this.searchDescendantsAll(vector, 0, null, string);
        return new VectorNodeIterator(vector);
    }

    public TXElement[] searchDescendantsAll(String string) {
        return this.searchDescendantsAll(0, null, string);
    }

    public TXElement[] searchDescendantsAll(int n, String string, String string2) {
        Vector vector = new Vector();
        this.searchDescendantsAll(vector, n, string, string2);
        Object[] objectArray = new TXElement[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public NodeIterator getElementsNamed(String string) {
        return this.getElementsNamed(0, null, string);
    }

    public NodeIterator getElementsNamed(String string, String string2) {
        return this.getElementsNamed(2, string, string2);
    }

    public NodeIterator getElementsNamed(int n, String string, String string2) {
        Node node;
        Vector<Node> vector = new Vector<Node>();
        NodeIterator nodeIterator = this.getChildNodes();
        while ((node = nodeIterator.toNextNode()) != null) {
            if (!(node instanceof Element) || !Match.matchName((Namespace)((Object)node), n, string, string2)) continue;
            vector.addElement(node);
        }
        return new VectorNodeIterator(vector);
    }

    public void acceptPre(Visitor visitor) throws Exception {
        visitor.visitElementPre(this);
    }

    public void acceptPost(Visitor visitor) throws Exception {
        visitor.visitElementPost(this);
    }

    private void searchDescendantsAll(Vector vector, int n, String string, String string2) {
        Child child;
        NodeIterator nodeIterator = this.getChildNodes();
        while ((child = (Child)nodeIterator.toNextNode()) != null) {
            if (!(child instanceof Element)) continue;
            if (Match.matchName((TXElement)child, n, string, string2)) {
                vector.addElement(child);
            }
            ((TXElement)child).searchDescendantsAll(vector, n, string, string2);
        }
    }

    private void makeAttributeList() {
        if (this.attributes == null) {
            this.checkFactory();
            this.attributes = this.factory.createAttributeList();
            this.attributes.setParent(this);
        }
    }
}

