/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.parser;

import com.ibm.xml.parser.AttDef;
import com.ibm.xml.parser.Attlist;
import com.ibm.xml.parser.Child;
import com.ibm.xml.parser.DTD;
import com.ibm.xml.parser.ElementDecl;
import com.ibm.xml.parser.Entity;
import com.ibm.xml.parser.GeneralReference;
import com.ibm.xml.parser.NOOPVisitor;
import com.ibm.xml.parser.PseudoNode;
import com.ibm.xml.parser.TXAttribute;
import com.ibm.xml.parser.TXComment;
import com.ibm.xml.parser.TXDocument;
import com.ibm.xml.parser.TXElement;
import com.ibm.xml.parser.TXNotation;
import com.ibm.xml.parser.TXPI;
import com.ibm.xml.parser.TXText;
import com.ibm.xml.parser.Util;
import com.ibm.xml.parser.Visitor;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import org.w3c.dom.CDATASection;

public class ToXMLStringVisitor
extends NOOPVisitor
implements Visitor {
    protected Writer writer;
    protected String encoding;

    public ToXMLStringVisitor(Writer writer, String string) {
        this.writer = writer;
        this.encoding = string;
    }

    public ToXMLStringVisitor(Writer writer) {
        this(writer, null);
    }

    public void visitDocumentPre(TXDocument tXDocument) throws IOException {
        if (tXDocument.getVersion() != null) {
            this.writer.write("<?xml version=\"" + tXDocument.getVersion() + "\"");
            if (tXDocument.getEncoding() != null) {
                this.writer.write(" encoding=\"" + tXDocument.getEncoding() + "\"");
            }
            if (tXDocument.getStandalone() != null) {
                this.writer.write(" standalone=\"" + tXDocument.getStandalone() + "\"");
            }
            this.writer.write("?>");
        }
        if (tXDocument.rootElement == null) {
            this.writer.write("<!-- The document has no root element. -->\n");
        }
    }

    public void visitDocumentPost(TXDocument tXDocument) throws IOException {
        this.writer.flush();
    }

    public void visitElementPre(TXElement tXElement) throws IOException {
        this.writer.write("<" + tXElement.getTagName());
        TXAttribute[] tXAttributeArray = tXElement.getAttributeArray();
        int n = 0;
        while (n < tXAttributeArray.length) {
            this.visitAttributePre(tXAttributeArray[n]);
            ++n;
        }
        if (tXElement.hasChildNodes()) {
            this.writer.write(">");
            return;
        }
        this.writer.write("/>");
    }

    public void visitElementPost(TXElement tXElement) throws IOException {
        if (tXElement.hasChildNodes()) {
            this.writer.write("</" + tXElement.getTagName() + ">");
        }
    }

    public void visitAttributePre(TXAttribute tXAttribute) throws IOException {
        this.writer.write(" " + tXAttribute.getName() + "=\"" + Util.backReferenceForEntity(tXAttribute.getValue(), this.encoding) + "\"");
    }

    public void visitPIPre(TXPI tXPI) throws IOException {
        this.writer.write("<?" + tXPI.getName() + tXPI.getData() + "?>");
    }

    public void visitCommentPre(TXComment tXComment) throws IOException {
        this.writer.write("<!--" + tXComment.getData() + "-->");
    }

    public void visitTextPre(TXText tXText) throws IOException {
        if (tXText instanceof CDATASection) {
            this.writer.write("<![CDATA[" + tXText.getData() + "]]>");
            return;
        }
        this.writer.write(Util.backReference(tXText.getData(), this.encoding));
    }

    public void visitDTDPre(DTD dTD) throws IOException {
        this.writer.write("<!DOCTYPE " + dTD.getName() + " ");
        if (dTD.getExternalID() != null) {
            this.writer.write(String.valueOf(dTD.getExternalID()) + " ");
        }
        if (dTD.isPrintInternalDTD() && dTD.getInternalSize() > 0) {
            this.writer.write("[");
            Enumeration enumeration = dTD.internalElements();
            while (enumeration.hasMoreElements()) {
                ((Child)enumeration.nextElement()).toXMLString(this.writer, this.encoding);
            }
            this.writer.write("]");
        }
        this.writer.write(">");
    }

    public void visitElementDeclPre(ElementDecl elementDecl) throws IOException {
        this.writer.write("<!ELEMENT " + elementDecl.getName() + " " + elementDecl.getXML4JContentModel() + ">");
    }

    public void visitAttlistPre(Attlist attlist) throws IOException {
        this.writer.write("<!ATTLIST " + attlist.getName());
        int n = attlist.size();
        if (n <= 0) {
            this.writer.write(" >");
            return;
        }
        if (n == 1) {
            this.visitAttDefPre(attlist.elementAt(0));
            this.writer.write(62);
            return;
        }
        this.writer.write("\n");
        int n2 = 0;
        while (n2 < n) {
            Util.printSpace(this.writer, 4);
            this.visitAttDefPre(attlist.elementAt(n2));
            if (n2 == n - 1) {
                this.writer.write(">");
            } else {
                this.writer.write("\n");
            }
            ++n2;
        }
    }

    public void visitAttDefPre(AttDef attDef) throws IOException {
        int n;
        this.writer.write(String.valueOf(' ') + attDef.getName() + ' ');
        int n2 = attDef.getDeclaredType();
        if (n2 != 10) {
            this.writer.write(String.valueOf(AttDef.S_TYPESTR[attDef.getDeclaredType()]) + ' ');
        }
        if (n2 == 9 || n2 == 10) {
            this.writer.write(String.valueOf('(') + attDef.elementAt(0));
            n = 1;
            while (n < attDef.size()) {
                this.writer.write(String.valueOf('|') + attDef.elementAt(n));
                ++n;
            }
            this.writer.write(") ");
        }
        if ((n = attDef.getDefaultType()) == 2) {
            this.writer.write("#REQUIRED");
            return;
        }
        if (n == 3) {
            this.writer.write("#IMPLIED");
            return;
        }
        if (n == 1) {
            this.writer.write("#FIXED \"");
            this.writer.write(attDef.getDefaultStringValue() == null ? "(null)" : Util.backReferenceForEntity(attDef.getDefaultStringValue(), this.encoding));
            this.writer.write(34);
            return;
        }
        if (n == -1) {
            this.writer.write(34);
            this.writer.write(attDef.getDefaultStringValue() == null ? "(null)" : Util.backReferenceForEntity(attDef.getDefaultStringValue(), this.encoding));
            this.writer.write(34);
        }
    }

    public void visitEntityPre(Entity entity) throws IOException {
        this.writer.write("<!ENTITY ");
        if (entity.isParameter()) {
            this.writer.write("% ");
        }
        this.writer.write(String.valueOf(entity.getName()) + " ");
        if (entity.getValue() != null) {
            this.writer.write("\"" + Util.backReferenceForEntity(entity.getValue(), this.encoding) + "\">");
            return;
        }
        this.writer.write(entity.getExternalID().toString());
        if (entity.getNDATAType() != null) {
            this.writer.write(" NDATA " + entity.getNDATAType());
        }
        this.writer.write(">");
    }

    public void visitNotationPre(TXNotation tXNotation) throws IOException {
        this.writer.write("<!NOTATION " + tXNotation.getName() + " " + tXNotation.getExternalID() + ">");
    }

    public void visitGeneralReferencePre(GeneralReference generalReference) throws IOException {
        this.writer.write(String.valueOf('&') + generalReference.getName() + ';');
    }

    public void visitPseudoNodePre(PseudoNode pseudoNode) throws IOException {
        this.writer.write(pseudoNode.getData());
    }
}

