/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.parser;

import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.NodeIterator;

class VectorNodeIterator
implements NodeIterator {
    static final Vector emptyVector = new Vector(0);
    static final VectorNodeIterator emptyIterator = new VectorNodeIterator(null);
    Vector nodes;
    int currentPos;

    public VectorNodeIterator(Vector vector) {
        this.nodes = vector == null ? emptyVector : vector;
    }

    public int getLength() {
        return this.nodes.size();
    }

    public int getCurrentPos() {
        return this.currentPos;
    }

    public boolean atFirst() {
        return this.currentPos == 0;
    }

    public boolean atLast() {
        return this.getLength() <= this.currentPos;
    }

    public Node toNextNode() {
        if (this.nodes.size() <= this.currentPos) {
            return null;
        }
        return (Node)this.nodes.elementAt(this.currentPos++);
    }

    public Node toPrevNode() {
        if (this.currentPos > 0) {
            return (Node)this.nodes.elementAt(--this.currentPos);
        }
        return null;
    }

    public Node toFirstNode() {
        this.currentPos = 0;
        if (this.nodes.size() == 0) {
            return null;
        }
        return (Node)this.nodes.elementAt(0);
    }

    public Node toLastNode() {
        this.currentPos = this.nodes.size();
        if (this.currentPos == 0) {
            return null;
        }
        return (Node)this.nodes.elementAt(this.currentPos - 1);
    }

    public Node moveTo(int n) {
        this.currentPos = n;
        if (n >= 0 && n < this.nodes.size()) {
            return (Node)this.nodes.elementAt(this.currentPos);
        }
        return null;
    }
}

