/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.parser;

import com.ibm.xml.parser.InvalidEncodingException;
import com.ibm.xml.parser.MIME2Java;
import com.ibm.xml.parser.Parser;
import com.ibm.xml.parser.Reading;
import com.ibm.xml.parser.Source;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.io.UTFDataFormatException;
import java.io.UnsupportedEncodingException;

final class XMLReader
extends Reader
implements Reading {
    private Parser m_pc;
    static final int E_UCS4B = 0;
    static final int E_UCS4L = 1;
    static final int E_UCS2B = 2;
    static final int E_UCS2L = 3;
    static final int E_UCS2B_NOBOM = 4;
    static final int E_UCS2L_NOBOM = 5;
    static final int E_ASCIICOMPAT = 6;
    static final int E_UTF8_NOXMLDECL = 7;
    private static final String classname = "com.ibm.xml.parser.XMLReader";
    private String eofmessage;
    private int m_encoding;
    private InputStream m_is;
    private Reader m_rr;
    private Source m_source;
    private String m_head;
    private String tail;
    private int m_linenumber = 1;
    private int m_charlocation;
    private int m_linenumber_pre = 1;
    private int m_charlocation_pre;
    private int m_lastchar = -1;
    private boolean m_resetline = false;
    int position = 0;
    int state;
    int paren;
    boolean ltgt = false;
    int m_nextchar = -1;
    Reading m_nextr;
    private String m_fname;

    public XMLReader(Parser parser, String string, Source source) throws InvalidEncodingException, IOException {
        this(parser, string, source, null);
    }

    public XMLReader(Parser parser, String string, Source source, String string2) throws InvalidEncodingException, IOException {
        this.m_head = string2;
        this.m_source = source;
        this.m_fname = string;
        this.m_pc = parser;
        this.eofmessage = "com.ibm.xml.parser.XMLReader#read: " + this.m_pc.getString("E_EOF");
        if (source.getReader() != null) {
            this.m_rr = this.makeReader(source.getReader());
            this.m_nextchar = this.read();
            return;
        }
        if (source.getEncoding() != null) {
            this.m_rr = this.makeReader(new InputStreamReader(source.getInputStream(), source.getEncoding()));
            this.m_nextchar = this.read();
            return;
        }
        InputStream inputStream = source.getInputStream();
        byte[] byArray = new byte[4];
        int n = 0;
        int n2 = inputStream.read();
        if (n2 >= 0) {
            byArray[n++] = (byte)n2;
        }
        if ((n2 = inputStream.read()) >= 0) {
            byArray[n++] = (byte)n2;
        }
        if ((n2 = inputStream.read()) >= 0) {
            byArray[n++] = (byte)n2;
        }
        if ((n2 = inputStream.read()) >= 0) {
            byArray[n++] = (byte)n2;
        }
        if (n == 4 && byArray[0] == 0 && byArray[1] == 0 && byArray[2] == 0 && byArray[3] == 60) {
            this.m_encoding = 0;
            this.m_head = "<";
            this.m_rr = this.makeReader(new UCSReader(inputStream, this.m_encoding));
        } else if (n == 4 && byArray[0] == 60 && byArray[1] == 0 && byArray[2] == 0 && byArray[3] == 0) {
            this.m_encoding = 1;
            this.m_head = "<";
            this.m_rr = this.makeReader(new UCSReader(inputStream, this.m_encoding));
        } else if (n >= 2 && byArray[0] == -2 && byArray[1] == -1) {
            this.m_encoding = 2;
            if (n == 3) {
                new InvalidEncodingException(this.m_pc.getString("E_INVENC0"));
            }
            if (n == 4) {
                char[] cArray = new char[]{(char)((byArray[2] << 8 & 0xFF00) + byArray[3])};
                this.m_head = new String(cArray);
            }
            this.m_rr = this.makeReader(new UCSReader(inputStream, this.m_encoding));
        } else if (n >= 2 && byArray[0] == -1 && byArray[1] == -2) {
            this.m_encoding = 3;
            if (n == 3) {
                new InvalidEncodingException(this.m_pc.getString("E_INVENC0"));
            }
            if (n == 4) {
                char[] cArray = new char[]{(char)((byArray[3] << 8 & 0xFF00) + byArray[2])};
                this.m_head = new String(cArray);
            }
            this.m_rr = this.makeReader(new UCSReader(inputStream, this.m_encoding));
        } else if (n == 4 && byArray[0] == 0 && byArray[1] == 60 && byArray[2] == 0 && byArray[3] == 63) {
            if (this.m_pc.isErrorNoByteMark()) {
                throw new InvalidEncodingException("com.ibm.xml.parser.XMLReader#constructor: " + this.m_pc.getString("E_INVENC0"));
            }
            this.m_encoding = 4;
            this.m_head = "<?";
            this.m_rr = this.makeReader(new UCSReader(inputStream, this.m_encoding));
        } else if (n == 4 && byArray[0] == 60 && byArray[1] == 0 && byArray[2] == 63 && byArray[3] == 0) {
            if (this.m_pc.isErrorNoByteMark()) {
                throw new InvalidEncodingException("com.ibm.xml.parser.XMLReader#constructor: " + this.m_pc.getString("E_INVENC1"));
            }
            this.m_encoding = 5;
            this.m_head = "<?";
            this.m_rr = this.makeReader(new UCSReader(inputStream, this.m_encoding));
        } else if (n == 4 && byArray[0] == 60 && byArray[1] == 63 && byArray[2] == 120 && byArray[3] == 109) {
            this.m_encoding = 6;
            this.m_head = "<?xm";
        } else {
            this.m_encoding = 7;
            try {
                if (n == 0) {
                    this.m_head = null;
                } else if (n > 0 && n < 4) {
                    this.m_head = new String(byArray, 0, n, "UTF8");
                } else {
                    PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 4);
                    pushbackInputStream.unread(byArray);
                    inputStream = pushbackInputStream;
                    this.m_head = null;
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
            if (this.m_head != null && this.m_head.length() == 0) {
                this.m_head = null;
            }
            this.m_rr = this.makeReader(new UTF8Reader(inputStream));
        }
        this.m_is = inputStream;
        this.m_nextchar = this.read();
    }

    private Reader makeReader(Reader reader) {
        int n = this.m_pc.getReaderBufferSize();
        if (n > 0) {
            return new BufferedReader(reader, n);
        }
        return reader;
    }

    public void setEncoding(String string) throws UnsupportedEncodingException {
        this.setEncoding(string, false);
    }

    public void setEncoding(String string, boolean bl) throws UnsupportedEncodingException {
        if (this.m_rr != null) {
            return;
        }
        if ("ISO-10646-UCS-2".equals(string = string.toUpperCase())) {
            return;
        }
        if ("ISO-10646-UCS-4".equals(string)) {
            return;
        }
        if ("UTF-16".equals(string)) {
            return;
        }
        String string2 = MIME2Java.convert(string);
        if (string2 == null) {
            if (bl) {
                string2 = string;
            } else {
                throw new UnsupportedEncodingException("com.ibm.xml.parser.XMLReader#setEncoding: " + this.m_pc.format1("E_ENC0", string));
            }
        }
        try {
            if ("UTF-8".equalsIgnoreCase(string2) || "UTF8".equalsIgnoreCase(string2)) {
                this.m_rr = this.makeReader(new UTF8Reader(this.m_is));
                return;
            }
            this.m_rr = this.makeReader(new InputStreamReader(this.m_is, string2));
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw unsupportedEncodingException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3 = 0;
        Object object = this.lock;
        synchronized (object) {
            while (n3 < n2) {
                int n4 = this.read();
                if (n4 < 0) break;
                cArray[n + n3] = (char)n4;
                ++n3;
            }
        }
        if (n3 <= 0) {
            return -1;
        }
        return n3;
    }

    public void addTail(String string) {
        if (this.tail == null) {
            this.tail = string;
            return;
        }
        this.tail = String.valueOf(this.tail) + string;
    }

    public int read() throws IOException {
        int n = -1;
        if (this.m_head != null) {
            n = this.m_head.charAt(0);
            this.m_head = this.m_head.length() == 1 ? null : this.m_head.substring(1);
        } else {
            n = this.m_rr != null ? this.m_rr.read() : (this.m_is != null ? this.m_is.read() : -1);
            if (n < 0) {
                if (this.tail != null) {
                    n = this.tail.charAt(0);
                    this.tail = this.tail.length() == 1 ? null : this.tail.substring(1);
                } else {
                    return n;
                }
            }
        }
        this.m_linenumber_pre = this.m_linenumber++;
        this.m_charlocation_pre = this.m_charlocation;
        if (this.m_resetline) {
            this.m_charlocation = 0;
            this.m_resetline = false;
        }
        ++this.m_charlocation;
        if (n == 13 || n == 10 && this.m_lastchar != 13) {
            this.m_resetline = true;
        }
        this.m_lastchar = n;
        return n;
    }

    public void close() throws IOException {
        if (this.m_rr != null) {
            this.m_rr.close();
            this.m_rr = null;
            this.m_is = null;
        } else if (this.m_is != null) {
            this.m_is.close();
            this.m_is = null;
        }
        if (this.m_pc != null) {
            this.m_pc.closeInputStream(this.m_source);
        }
        this.m_pc = null;
        this.m_source = null;
    }

    public int getLineNumber() {
        return this.m_linenumber_pre;
    }

    public int getCharLocation() {
        return this.m_charlocation_pre;
    }

    public int getChar() throws IOException {
        int n = this.m_nextchar;
        this.m_nextchar = this.read();
        if (this.position != 0 && this.position != 4) {
            if (this.position == 1 || this.position == 2) {
                if (this.state != 0) {
                    if (this.state == n) {
                        this.state = 0;
                    }
                } else if (n == 60) {
                    ++this.paren;
                } else if (n == 62) {
                    --this.paren;
                } else if (n == 34 || n == 39) {
                    this.state = n;
                }
            } else if (this.state != 0) {
                if (this.state == n) {
                    this.state = 0;
                }
            } else if (n == 40) {
                ++this.paren;
            } else if (n == 41) {
                --this.paren;
            } else if (n == 62 || n == 60) {
                this.ltgt = true;
            } else if (n == 34 || n == 39) {
                this.state = n;
            }
        }
        return n;
    }

    public String getFileName() {
        return this.m_fname;
    }

    public void setNext(Reading reading) {
        this.m_nextr = reading;
    }

    public Reading getNext() {
        return this.m_nextr;
    }

    public int readNext() {
        return this.m_nextchar;
    }

    public void setChecking(int n) {
        this.position = n;
    }

    public String getErrorKey() {
        String string = null;
        if (this.ltgt) {
            string = "E_PEREF9";
        } else if (this.paren != 0 && this.position == 5) {
            string = "E_PEREF7";
        } else if (this.paren != 0) {
            string = "E_PEREF9";
        }
        return string;
    }

    static /* synthetic */ String access$0(XMLReader xMLReader) {
        return xMLReader.eofmessage;
    }

    static /* synthetic */ String access$1() {
        return classname;
    }

    static /* synthetic */ Parser access$2(XMLReader xMLReader) {
        return xMLReader.m_pc;
    }

    class UCSReader
    extends Reader {
        InputStream m_is;
        int m_encoding;
        int m_prevchar = -1;
        int m_nextchar = -1;

        UCSReader(InputStream inputStream, int n) {
            XMLReader.this = XMLReader.this;
            this.m_is = inputStream;
            this.m_encoding = n;
        }

        public int read(char[] cArray, int n, int n2) throws IOException {
            int n3 = 0;
            Object object = this.lock;
            synchronized (object) {
                int n4 = 0;
                while (n4 < n2) {
                    if (this.m_nextchar >= 0) {
                        cArray[n + n4] = (char)this.m_nextchar;
                        this.m_nextchar = -1;
                        ++n3;
                    } else {
                        int n5 = -1;
                        int n6 = this.m_is.read();
                        if (n6 < 0 && n4 == 0) {
                            n3 = -1;
                            break;
                        }
                        switch (this.m_encoding) {
                            case 0: {
                                if (n6 < 0) break;
                                int n7 = this.m_is.read();
                                if (n7 < 0) {
                                    XMLReader xMLReader = XMLReader.this;
                                    throw new EOFException(xMLReader.eofmessage);
                                }
                                int n8 = this.m_is.read();
                                if (n8 < 0) {
                                    XMLReader xMLReader = XMLReader.this;
                                    throw new EOFException(xMLReader.eofmessage);
                                }
                                int n9 = this.m_is.read();
                                if (n9 < 0) {
                                    XMLReader xMLReader = XMLReader.this;
                                    throw new EOFException(xMLReader.eofmessage);
                                }
                                n5 = (n6 << 24) + (n7 << 16) + (n8 << 8) + n9;
                                if (n5 > 0x10FFFF) {
                                    XMLReader xMLReader = XMLReader.this;
                                    throw new UTFDataFormatException("com.ibm.xml.parser.XMLReader#read: " + xMLReader.m_pc.format1("E_ENC1", Integer.toHexString(n5)));
                                }
                                if (n5 < 65536) break;
                                int n10 = (n5 - 65536 >> 10) + 55296;
                                int n11 = (n5 - 65536 & 0x3FF) + 56320;
                                n5 = n10;
                                this.m_nextchar = n11;
                                break;
                            }
                            case 1: {
                                if (n6 < 0) break;
                                int n7 = this.m_is.read();
                                if (n7 < 0) {
                                    XMLReader xMLReader = XMLReader.this;
                                    throw new EOFException(xMLReader.eofmessage);
                                }
                                int n8 = this.m_is.read();
                                if (n8 < 0) {
                                    XMLReader xMLReader = XMLReader.this;
                                    throw new EOFException(xMLReader.eofmessage);
                                }
                                int n9 = this.m_is.read();
                                if (n9 < 0) {
                                    XMLReader xMLReader = XMLReader.this;
                                    throw new EOFException(xMLReader.eofmessage);
                                }
                                n5 = (n9 << 24) + (n8 << 16) + (n7 << 8) + n6;
                                if (n5 > 0x10FFFF) {
                                    XMLReader xMLReader = XMLReader.this;
                                    throw new UTFDataFormatException("com.ibm.xml.parser.XMLReader#read: " + xMLReader.m_pc.format1("E_ENC1", Integer.toHexString(n5)));
                                }
                                if (n5 < 65536) break;
                                int n10 = (n5 - 65536 >> 10) + 55296;
                                int n11 = (n5 - 65536 & 0x3FF) + 56320;
                                n5 = n10;
                                this.m_nextchar = n11;
                                break;
                            }
                            case 2: 
                            case 4: {
                                if (n6 < 0) break;
                                int n7 = this.m_is.read();
                                if (n7 < 0) {
                                    XMLReader xMLReader = XMLReader.this;
                                    throw new EOFException(xMLReader.eofmessage);
                                }
                                n5 = (n6 << 8) + n7;
                                if (this.m_prevchar >= 0) {
                                    if (n5 < 56320 || n5 >= 57344) {
                                        XMLReader xMLReader = XMLReader.this;
                                        throw new UTFDataFormatException("com.ibm.xml.parser.XMLReader#read: " + xMLReader.m_pc.format2("E_ENC2", Integer.toHexString(this.m_prevchar), Integer.toHexString(n5)));
                                    }
                                    this.m_prevchar = -1;
                                }
                                if (n5 >= 55296 && n5 < 56320) {
                                    this.m_prevchar = n5;
                                    break;
                                }
                                if (n5 < 56320 || n5 >= 57344) break;
                                XMLReader xMLReader = XMLReader.this;
                                throw new UTFDataFormatException("com.ibm.xml.parser.XMLReader#read: " + xMLReader.m_pc.format1("E_ENC3", Integer.toHexString(n5)));
                            }
                            case 3: 
                            case 5: {
                                if (n6 < 0) break;
                                int n7 = this.m_is.read();
                                if (n7 < 0) {
                                    XMLReader xMLReader = XMLReader.this;
                                    throw new EOFException(xMLReader.eofmessage);
                                }
                                n5 = (n7 << 8) + n6;
                                if (this.m_prevchar >= 0) {
                                    if (n5 < 56320 || n5 >= 57344) {
                                        XMLReader xMLReader = XMLReader.this;
                                        throw new UTFDataFormatException("com.ibm.xml.parser.XMLReader#read: " + xMLReader.m_pc.format2("E_ENC2", Integer.toHexString(this.m_prevchar), Integer.toHexString(n5)));
                                    }
                                    this.m_prevchar = -1;
                                }
                                if (n5 >= 55296 && n5 < 56320) {
                                    this.m_prevchar = n5;
                                    break;
                                }
                                if (n5 < 56320 || n5 >= 57344) break;
                                XMLReader xMLReader = XMLReader.this;
                                throw new UTFDataFormatException("com.ibm.xml.parser.XMLReader#read: " + xMLReader.m_pc.format1("E_ENC3", Integer.toHexString(n5)));
                            }
                        }
                        if (n5 < 0) break;
                        cArray[n + n4] = (char)n5;
                        ++n3;
                    }
                    ++n4;
                }
            }
            return n3;
        }

        public void close() throws IOException {
            this.m_is.close();
            this.m_is = null;
        }
    }

    class UTF8Reader
    extends Reader {
        InputStream m_is;
        int m_prevchar = -1;
        int m_nextchar = -1;

        UTF8Reader(InputStream inputStream) {
            XMLReader.this = XMLReader.this;
            this.m_is = inputStream;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int read(char[] cArray, int n, int n2) throws IOException {
            int n3 = 0;
            Object object = this.lock;
            synchronized (object) {
                int n4 = 0;
                while (n4 < n2) {
                    block23: {
                        int n5;
                        block26: {
                            block24: {
                                int n6;
                                int n7;
                                int n8;
                                block28: {
                                    block27: {
                                        block25: {
                                            block22: {
                                                if (this.m_nextchar < 0) break block22;
                                                cArray[n + n4] = (char)this.m_nextchar;
                                                this.m_prevchar = -1;
                                                this.m_nextchar = -1;
                                                ++n3;
                                                break block23;
                                            }
                                            n5 = -1;
                                            n8 = this.m_is.read();
                                            if (n8 < 0) break block24;
                                            if ((0x80 & n8) != 0) break block25;
                                            n5 = n8;
                                            break block26;
                                        }
                                        n7 = this.m_is.read();
                                        if (n7 < 0) {
                                            XMLReader xMLReader = XMLReader.this;
                                            throw new EOFException(xMLReader.eofmessage);
                                        }
                                        if ((0xC0 & n7) != 128) {
                                            XMLReader xMLReader = XMLReader.this;
                                            throw new UTFDataFormatException("com.ibm.xml.parser.XMLReader#read: " + xMLReader.m_pc.format2("E_ENC5", Integer.toHexString(n8), Integer.toHexString(n7)));
                                        }
                                        if ((0xE0 & n8) != 192) break block27;
                                        n5 = ((0x1F & n8) << 6) + (0x3F & n7);
                                        break block26;
                                    }
                                    if ((0xF0 & n8) != 224) break block28;
                                    n6 = this.m_is.read();
                                    if (n6 < 0) {
                                        XMLReader xMLReader = XMLReader.this;
                                        throw new EOFException(xMLReader.eofmessage);
                                    }
                                    if ((0xC0 & n6) != 128) {
                                        XMLReader xMLReader = XMLReader.this;
                                        throw new UTFDataFormatException("com.ibm.xml.parser.XMLReader#read: " + xMLReader.m_pc.format3("E_ENC6", Integer.toHexString(n8), Integer.toHexString(n7), Integer.toHexString(n6)));
                                    }
                                    n5 = ((0xF & n8) << 12) + ((0x3F & n7) << 6) + (0x3F & n6);
                                    break block26;
                                }
                                if ((0xF8 & n8) == 240) {
                                    n6 = this.m_is.read();
                                    if (n6 < 0) {
                                        XMLReader xMLReader = XMLReader.this;
                                        throw new EOFException(xMLReader.eofmessage);
                                    }
                                    if ((0xC0 & n6) != 128) {
                                        XMLReader xMLReader = XMLReader.this;
                                        throw new UTFDataFormatException("com.ibm.xml.parser.XMLReader#read: " + xMLReader.m_pc.format3("E_ENC6", Integer.toHexString(n8), Integer.toHexString(n7), Integer.toHexString(n6)));
                                    }
                                    int n9 = this.m_is.read();
                                    if (n9 < 0) {
                                        XMLReader xMLReader = XMLReader.this;
                                        throw new EOFException(xMLReader.eofmessage);
                                    }
                                    if ((0xC0 & n9) != 128) {
                                        XMLReader xMLReader = XMLReader.this;
                                        throw new UTFDataFormatException("com.ibm.xml.parser.XMLReader#read: " + xMLReader.m_pc.format4("E_ENC7", Integer.toHexString(n8), Integer.toHexString(n7), Integer.toHexString(n6), Integer.toHexString(n9)));
                                    }
                                    n5 = ((0xF & n8) << 18) + ((0x3F & n7) << 12) + ((0x3F & n6) << 6) + (0x3F & n9);
                                    if (n5 >= 65536) {
                                        int n10 = (n5 - 65536 >> 10) + 55296;
                                        int n11 = (n5 - 65536 & 0x3FF) + 56320;
                                        n5 = n10;
                                        this.m_nextchar = n11;
                                    }
                                    break block26;
                                } else {
                                    if ((0xFC & n8) == 248) {
                                        XMLReader xMLReader = XMLReader.this;
                                        throw new UTFDataFormatException("com.ibm.xml.parser.XMLReader#read: " + xMLReader.m_pc.format1("E_ENC4", Integer.toHexString(n8)));
                                    }
                                    if ((0xFE & n8) == 252) {
                                        XMLReader xMLReader = XMLReader.this;
                                        throw new UTFDataFormatException("com.ibm.xml.parser.XMLReader#read: " + xMLReader.m_pc.format1("E_ENC4", Integer.toHexString(n8)));
                                    }
                                    XMLReader xMLReader = XMLReader.this;
                                    throw new UTFDataFormatException("com.ibm.xml.parser.XMLReader#read: " + xMLReader.m_pc.format1("E_ENC4", Integer.toHexString(n8)));
                                }
                            }
                            if (n4 != 0) return n3;
                            return -1;
                        }
                        if (this.m_prevchar >= 0) {
                            if (n5 < 56320 || n5 >= 57344) {
                                XMLReader xMLReader = XMLReader.this;
                                throw new UTFDataFormatException("com.ibm.xml.parser.XMLReader#read: " + xMLReader.m_pc.format2("E_ENC2", Integer.toHexString(this.m_prevchar), Integer.toHexString(n5)));
                            }
                            this.m_prevchar = -1;
                        }
                        if (n5 >= 55296 && n5 < 56320) {
                            this.m_prevchar = n5;
                        } else if (n5 >= 56320 && n5 < 57344) {
                            XMLReader xMLReader = XMLReader.this;
                            throw new UTFDataFormatException("com.ibm.xml.parser.XMLReader#read: " + xMLReader.m_pc.format1("E_ENC3", Integer.toHexString(n5)));
                        }
                        cArray[n + n4] = (char)n5;
                        ++n3;
                    }
                    ++n4;
                }
                return n3;
            }
        }

        public void close() throws IOException {
            this.m_is.close();
            this.m_is = null;
        }
    }
}

