/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.parser.util;

import com.ibm.xml.parser.AttDef;
import com.ibm.xml.parser.Attlist;
import com.ibm.xml.parser.DTD;
import com.ibm.xml.parser.ElementDecl;
import com.ibm.xml.parser.Entity;
import com.ibm.xml.parser.TXAttribute;
import com.ibm.xml.parser.TXCDATASection;
import com.ibm.xml.parser.TXDocument;
import com.ibm.xml.parser.TXElement;
import com.ibm.xml.parser.TXNotation;
import com.ibm.xml.parser.TXPI;
import com.ibm.xml.parser.TXText;
import com.ibm.xml.parser.ToXMLStringVisitor;
import com.ibm.xml.parser.Util;
import java.io.IOException;
import java.io.Writer;

public class HTMLPrintVisitor
extends ToXMLStringVisitor {
    protected int level;
    protected String doctype;

    public HTMLPrintVisitor(Writer writer, String string, String string2) {
        super(writer, string);
        this.doctype = string2;
    }

    public HTMLPrintVisitor(Writer writer, String string) {
        this(writer, string, null);
    }

    public HTMLPrintVisitor(Writer writer) {
        this(writer, null, null);
    }

    public void visitDocumentPre(TXDocument tXDocument) throws IOException {
        if (this.doctype != null) {
            this.writer.write(this.doctype);
        }
    }

    public void visitDocumentPost(TXDocument tXDocument) throws IOException {
        this.writer.flush();
    }

    public void visitElementPre(TXElement tXElement) throws IOException {
        ++this.level;
        this.writer.write("<" + tXElement.getTagName().toUpperCase());
        TXAttribute[] tXAttributeArray = tXElement.getAttributeArray();
        int n = 0;
        while (n < tXAttributeArray.length) {
            this.visitAttributePre(tXAttributeArray[n]);
            ++n;
        }
        this.writer.write(">");
    }

    public void visitElementPost(TXElement tXElement) throws IOException {
        if (tXElement.hasChildNodes()) {
            this.writer.write("</" + tXElement.getTagName().toUpperCase() + ">");
        }
        if (--this.level == 0) {
            this.writer.write("\n");
        }
    }

    public void visitAttributePre(TXAttribute tXAttribute) throws IOException {
        this.writer.write(" " + tXAttribute.getName().toLowerCase() + "=\"" + Util.backReferenceForEntity(tXAttribute.getValue(), this.encoding) + "\"");
    }

    public void visitPIPre(TXPI tXPI) throws IOException {
    }

    public void visitTextPre(TXText tXText) throws IOException {
        if (this.level > 0) {
            if (tXText instanceof TXCDATASection) {
                this.writer.write(tXText.getData());
                return;
            }
            this.writer.write(Util.backReference(tXText.getData(), this.encoding));
        }
    }

    public void visitDTDPre(DTD dTD) throws IOException {
    }

    public void visitElementDeclPre(ElementDecl elementDecl) throws IOException {
    }

    public void visitAttlistPre(Attlist attlist) throws IOException {
    }

    public void visitAttDefPre(AttDef attDef) throws IOException {
    }

    public void visitEntityPre(Entity entity) throws IOException {
    }

    public void visitNotationPre(TXNotation tXNotation) throws IOException {
    }
}

