
/*
 *
 *  File Name:      ras_modules.h
 *
 *
 *
 *  Description:
 *
 *  This file contains the Module IDs that software uses to call the RAS 
 *  Subsystems (LOG, TRACE). Each module defines a Module ID that
 *  it uses for calls to both LOG and TRACE.
 *
 *  The Module ID should identify a "functional subsystem".  Examples include:
 *  "Fabric Watch", "Condor ASIC Driver", "Name Server", etc...
 *
 *
 *  LOG:
 *  
 *  Software using the LOG Subsystem places its Module ID into the "Module ID"
 *  field of its message definitions.  This marks the software as the message
 *  originator when the messages are processed and displayed.
 *
 *  <Module ID="xxx" ...
 *
 *
 *  TRACE:
 *
 *	Callers place the module ID in the trace buffer creation call to "tag" the
 *  buffer as its own.  The ID appears in the dump and will be used to 
 *  associate the dump with the software.
 *
 *
 *  ******************** ADDING A NEW MODULE ID ********************
 *
 *  1.  Add new #define to end of ID list.  Do not re-use existing numbers.
 *      Add to the end to the list using a value one more (+1) than
 *      the last entry in the list.
 *
 *  2.  Change the value of RAS_MODULE_ID_MAX to be the new ID just added.
 *
 *  3.  Add a RAS Module ID string to the end of the ID string array.
 *
 *
 *
 *  Warnings:
 *
 *  DO NOT CHANGE EXISTING MODULE ID DEFINITIONS.  
 *  Changing existing definitions can break backward compatibility with 
 *  software in the field and Brocade's internal utilities.
 *
 *
 *
 *
 *  Copyright (C) 2003-2005 Brocade Communications
 *  All rights reserved.
 *
 *  These coded instructions and statements contain unpublished trade
 *  secrets and proprietary information.  They are protected by federal
 *  copyright law and by trade secret law, and may not be disclosed to
 *  third parties or used, copied, or duplicated in any form, in whole
 *  or in part, without the prior written consent of Brocade Communications.
 *
 *
 *
 *
 *
 *  Change History:
 *
 *  Date        Author      Description
 *
 *  09/10/03    J. Chen     Initial Version
 *  09/11/03    S. Stolper  Use #defines instead of Enums
 *  11/10/03	S. Stolper	Added string array and macro
 *
 */


        /*  Avoid Duplication
         */
#ifndef	__RAS_MODULES_H__
#define	__RAS_MODULES_H__

#define RAS_CAT_NAME		"FOS"

		/*  Module ID List
		 *
		 *  TO CREATE A NEW MODULE ID:
		 *
		 *  Add a #define at the end of the list below.  Select a value for your
		 *  definition so that it is one (1) greater than the previous 
		 *  definition.  Modify the definition of RAS_MODULE_ID_MAX to become
		 *  your new definition.  If you do not modify RAS_MODULE_ID_MAX, your
		 *  definition will not be accepted by the RAS Subsystems.
 *  If the module ID will be used by RAS-LOG the MODULE_ID has to match with "Module ID"
 *  defined in XML file.
 *  For example:
 *  If the module ID defined in XML file is "ABC" i.e.
 *  <Module ID="ABC" IncludeFile="raslog_xx.h">, the module ID define in
 *  this file has to be RAS_ABC_ID
 */
#define RAS_UNKN_ID		(0)			/*  UNKNOWN MODULE */
#define RAS_KT_ID		(1)			/*  Kernel Test ID */
#define RAS_UT_ID		(2)			/*  User Test ID */
#define RAS_TRCE_ID		(3)			/*  TRACE Subsystem */
#define RAS_KTRC_ID		(4)			/*  kernel TRACE module */
#define RAS_LOG_ID		(5)			/*  RASLOG module */
#define RAS_CDR_ID		(6)			/*  Condor ASIC driver */
#define RAS_BLPU_ID		(7)			/*	Pulsar Blade driver */
#define RAS_PISP_ID		(8)			/*	Spectrum PIC driver */
#define RAS_PIXE_ID		(9)			/*	Xena PIC driver */
#define RAS_EGR_ID		(10)		/*  Egret ASIC driver */
#define RAS_BL_ID		(11)		/*  Generic Blade driver */
#define RAS_PIC_ID		(12)		/*  Generic PIC driver */
#define RAS_PS_ID		(13)		/*  Advanced Performance Monitoring ID */
#define RAS_RTE_ID		(14)		/*  Routing Module ID */
#define RAS_AS_ID		(15)
#define RAS_AUTH_ID		(16)
#define RAS_BLDE_ID		(17)
#define RAS_BLM_ID		(18)
#define RAS_BPRT_ID		(19)
#define RAS_CER_ID		(20)
#define RAS_CFLD_ID		(21)
#define RAS_CFMN_ID		(22)
#define RAS_CHPS_ID		(23)
#define RAS_CONF_ID		(24)
#define RAS_CPT_ID		(25)
#define RAS_DIAG_ID		(26)
#define RAS_EM_ID		(27)
#define RAS_ERRL_ID		(28)
#define RAS_FABR_ID		(29)
#define RAS_FABS_ID		(30)
#define RAS_FCIU_ID		(31)
#define RAS_FCMC_ID		(32)
#define RAS_FCPD_ID		(33)
#define RAS_FCPH_ID		(34)
#define RAS_FICU_ID		(35)
#define RAS_FILB_ID		(36)
#define RAS_FKLB_ID		(37)
#define RAS_FLOD_ID		(38)
#define RAS_FSPF_ID		(39)
#define RAS_FSS_ID		(40)
#define RAS_FSSM_ID		(41)
#define RAS_FW_ID		(42)
#define RAS_HAM_ID		(43)
#define RAS_HAMK_ID		(44)
#define RAS_HIL_ID		(45)
#define RAS_HLO_ID		(46)
#define RAS_HMON_ID		(47)
#define RAS_HTTP_ID		(48)
#define RAS_LOOM_ID		(49)
#define RAS_LSDB_ID		(50)
#define RAS_MCST_ID		(51)
#define RAS_MFIC_ID		(52)
#define RAS_MPTH_ID		(53)
#define RAS_MQ_ID		(54)
#define RAS_MS_ID		(55)
#define RAS_NBFS_ID		(56)
#define RAS_NS_ID		(57)
#define RAS_OLMP_ID		(58)
#define RAS_PANI_ID		(59)
#define RAS_PDM_ID		(60)
#define RAS_PDTR_ID		(61)
#define RAS_PLAT_ID		(62)
#define RAS_PORT_ID		(63)
#define RAS_PSWP_ID		(64)
#define RAS_RAS_ID		(65)
#define RAS_RCS_ID		(66)
#define RAS_RTWR_ID		(67)
#define RAS_SCN_ID		(68)
#define RAS_SEMA_ID		(69)
#define RAS_SULB_ID		(70)
#define RAS_SWCH_ID		(71)
#define RAS_SYSC_ID		(72)	    /* sysctrld */
#define RAS_SYSM_ID		(73)
#define RAS_TRCK_ID		(74)
#define RAS_TS_ID		(75)
#define RAS_UCST_ID		(76)
#define RAS_UPTH_ID		(77)
#define RAS_WEBD_ID		(78)
#define RAS_ZOLB_ID		(79)
#define RAS_ZONE_ID		(80)
#define RAS_KSWD_ID		(81)
#define RAS_USWD_ID		(82)
#define RAS_SNMP_ID		(83)
#define RAS_RPCD_ID		(84)
#define RAS_BLL_ID		(85)
#define RAS_SEC_ID		(86)
#define RAS_EVMD_ID		(87)
#define RAS_NS_TRACE_ID		(88)
#define RAS_SS_ID		(89)
#define RAS_DGD_ID		(90)
#define RAS_XTCF_ID		(91)		/*  Extended Config Library */
#define RAS_BM_ID		(92)		/*  Blade Manager */
#define RAS_FPC_ID		(93)		/*  Forte Port Controller   */
#define RAS_FBC_ID		(94)		/*  Forte Blade Controller  */
#define RAS_FUP_ID		(95)
#define RAS_SB_ID		(96)		/*  Forte Switch Board */
#define RAS_CSCN_ID		(97)		/*  Forte CSCN library */
#define RAS_ARM_ID		(98)		/*  Forte per port processors */
#define RAS_BLPE_ID		(99)	/* PEN blade driver */
#define RAS_FSSL_ID		(100)
#define RAS_IPC_ID		(101)
#define RAS_CAL_ID		(102)
#define RAS_RT_ID		(103)	/* RT in fc module */
#define RAS_PBL_ID		(104)
#define RAS_FCIP_ID		(105)	/* Marathon FCIP (1250/4350(&9630/flipper)) */
#define RAS_IPS_ID		(106)	/* Marathon IPS Daemon */
#define RAS_BLMA_ID		(107)	/* MARATHON blade driver */
#define RAS_FCR_ID		(108)	/* FC router */
#define RAS_RPM_ID		(109)	/* platform RPM module */
#define RAS_MSELS_ID		(110)
#define RAS_ARR_ID		(111)
#define RAS_MPC_ID		(112)	/* Marathon Port Controller (in bfos) */
#define RAS_MBD_ID		(113)	/* Marathon Blade driver (in bfos) */
#define RAS_BC_ID		(114)	/* Marathon Blade Controller (in bfos)	*/
#define RAS_HIFN_ID		(115)	/* Marathon Hifn (in bfos)	*/
#define RAS_BPDL_ID		(116)	/* Marathon 1250 download driver (in bfos)	*/
#define RAS_SAPI_ID		(117)	/* Marathon Blade Controller (in bfos)	*/
#define RAS_BKSW_ID		(118)	/* Blade SWD kernel driver				*/   
#define RAS_BUSW_ID		(119)	/* Blade User space SWD daemon			*/
#define RAS_BSWL_ID		(120)	/* Blade SWD library	daemon			*/

#define RAS_ICPD_ID		(121)	/* iSCSI daemon on CP */
#define RAS_IBPD_ID		(122)	/* iSCSI daemon on BP */
#define RAS_ISCSI_PORT_ID	(123)	/* iSCSI Port entities (1125H/iFlipper/etc.,) */
#define RAS_ISNS_ID		(124)	/* iSNS client daemon on CP */
#define RAS_ISCS_ID		(125)	/* iSCSI BP asic driver */

#define RAS_IBD_ID		(126)	/* Ironman Blade Driver */
#define RAS_IMPC_ID		(127)	/* Ironman Port Controller(in bfos) */
#define RAS_CBD_ID		(128)	/* Common BP Blade Driver*/
#define RAS_ULPVELS_ID 	(129)	/* FC VELS ulp module */
#define RAS_PMSG_ID     (130)	/* Port msg driver */
#define RAS_SYSDRV_ID	(131)	/* System driver */
#define RAS_SAS_ID		(132)   /* Scimitar CPSAS ASIC Driver */
#define RAS_MM_ID		(133)
#define RAS_IPAD_ID		(134)	/* IP Admin */
#define RAS_CH_ID		(135)	/* Command History */
#define RAS_ELOG_ID		(136)   /* EVENT LOG */
#define RAS_FCRM_ID		(137)
#define RAS_WEBL_ID		(138)		/* Weblinker module */
#define RAS_AG_ID		(139)
#define RAS_SCPD_ID		(140)		/* for SCPD Daemon*/
#define RAS_SASSVR_ID	(141)		/* for SAS Server (SASR) Trace */
#define RAS_SAC_ID	    (142)		/* for SAS SAC RAS Log */
#define RAS_SBP_ID 		(143)   /* FOR SBP LIB */
#define RAS_C2_ID		(144)
#define RAS_FICN_ID		(145)
#define RAS_SCIM_ID		(146)    /* Scimitar blade id */
#define RAS_ESS_ID		(147)	/* Exchange Switch Support */
#define RAS_EXCH_ID		(148)
#define RAS_ELS_ID		(149)
#define RAS_MODULE_ID_MIN	(RAS_KT_ID)
#define RAS_MODULE_ID_MAX	(RAS_ELS_ID)	/*** CHANGE ME WITH NEW MODULE ***/
#endif  /*  __RAS_MODULES_H__ */   

#ifdef __RAS_INTERNAL_USER__

		/*  Module ID String Array
		 *
		 *  TO CREATE A NEW MODULE ID:
		 *
		 *  Add a new string (MAX 4 CHARACTERS) to the end of this array.
		 *  DO NOT FORGET TO ADD A COMMA AFTER THE PREVIOUS ENTRY.
		 *  Each array entry is NULL terminated.
		 *  ---
		 *  To use these strings for formatted output, please include
		 *  "ras_module_strings.h" in your code.  This header file
		 *  contains a complete explanation of how to use these strings.
		 */
static unsigned char trace_id_string_array[RAS_MODULE_ID_MAX + 1][8] =
{
			/*
			 *  *** REMEMBER THAT MAX SIZE IS - 4 - CHARACTERS ***
			 */
	"UNKN",		/*  Unknown Module */
	"KT",		/*  Kernel Test ID */
	"UT",		/*  User Test ID */
	"TRCE",		/*  Trace Subsystem (User) */
	"KTRC",		/*  Trace Subsystem (Kernel) */
	"LOG",		/*  RASLOG module */
	"CDR",		/*  Condor ASIC driver */
	"BLPU",		/*  Pulsar Blade driver */
	"PISP",		/*  Spectrum PIC driver */
	"PIXE",		/*  Xena PIC driver */
	"EGR",		/*  Egret ASIC driver */
	"BL",		/*  Generic Blade driver */
	"PIC",		/*  Generic PIC driver */
	"PS",		/*  Advanced Performance Monitoring */
	"RTE",		/*  Routing */
	"AS",
	"AUTH",
	"BLDE",
	"BLM",
	"BPRT",
	"CER",
	"CFLD",
	"CFMN",
	"CHPS",
	"CONF",
	"CPT",
	"DIAG",
	"EM",
	"ERRL",
	"FABR",
	"FABS",
	"FCIU",
	"FCMC",
	"FCPD",
	"FCPH",
	"FICU",
	"FILB",
	"FKLB",
	"FLOD",
	"FSPF",
	"FSS",
	"FSSM",
	"FW",
	"HAM",
	"HAMK",
	"HIL",
	"HLO",
	"HMON",
	"HTTP",
	"LOOM",
	"LSDB",
	"MCST",
	"MFIC",
	"MPTH",
	"MQ",
	"MS",
	"NBFS",
	"NS",
	"OLMP",
	"PANI",
	"PDM",
	"PDTR",
	"PLAT",
	"PORT",
	"PSWP",
	"RAS",
	"RCS",
	"RTWR",
	"SCN",
	"SEMA",
	"SULB",
	"SWCH",
	"SYSC",
	"SYSM",
	"TRCK",
	"TS",
	"UCST",
	"UPTH",
	"WEBD",
	"ZOLB",
	"ZONE",
	"KSWD",
	"USWD",
	"SNMP",
	"RPCD",
	"BLL",
	"SEC",
	"EVMD",
	"NST",
	"SS",
	"DGD",
	"XTCF",		/*  Extended Configuration Library */
	"BM",		/*  Blade Manager            */
	"FPC",		/*  Forte Port Controller          */
	"FBC",		/*  Forte Blade Controller          */
	"FUP",		/*  Forte Upgrade Library	*/
	"SB",		/*  Forte Switch Board		*/
	"CSCN",		/*  Forte CSCN library		*/
	"ARM",		/*  Forte per port processors */
	"BLPU",		/*  PEN Blade driver */
	"FSSL",
	"IPC",
	"CAL",
	"RT",		/* RT in fc driver */
	"PBL",		/* Pinball ASIC driver */
	"FCIP",		/* Marathon FCIP ASIC Driver (1250/4350(&9630/flipper)) */
	"IPS",		/* Marathon IPS Daemon */
	"BLMA",		/*  Marathon Blade driver */
	"FCR",		/* FC router */
	"RPM",
	"MSELS",
	"ARR",
	"MPC",		/* Marathon Port Controller */
	"MBD",		/* Marathon BP blade driver */
	"BC",		/* BP blade controller		*/
	"HIFN",		/* Hifn		*/
	"BPDL",		/* Marathon BP 1250 download driver */
	"SAPI",
	"BKSW",		/* Blade SWD kernel driver				*/
	"BSWD",		/* Blade SWD user space daemon			*/
	"BSWL",		/* Blade SWD library					*/
	"ICPD",		/* iSCSI CP Daemon */
	"IBPD",		/* iSCSI BP Daemon */
	"ISCP",		/* iSCSI Port entities (1125H/iFlipper/etc.,) */
	"ISNS",		/* iSNS client CP Daemon */
	"ISCS",	    /* ISCSI BP asic driver */
	"IBD",		/* Ironman BP Blade driver */
	"IMPC",		/* Ironman PC */
	"CBD",		/* BP Common Blade Driver*/
	"VELS",		/* FC VELS ulp module */
	"PMSG",		/* Port msg driver */
	"SYSD",		/* System Driver */
	"SAS",		/* Scimitar CPSAS driver */
	"MM",
	"IPAD",		/* IP Admin */
	"CH",		/* Command History */
	"ELOG",		/* event log */
	"FCRM",      /* FCR major event */
	"WEBL",      /* WEBL module (weblinker) */
	"AG", 		/* Access Gateway */
	"SCPD",		/* SCPD daemon"	*/
	"SASR",	    /* SAS Server daemon"	*/
	"SAC",	    /* SAS SAC 	*/
	"SBP",  /* For sbplib */
	"C2",		/* Condor2 driver */
	"FICN",      /* FICON module (1250) */
	"SCIM",	/* Scimitar blade driver */
	"ESS",		/* Exchange Switch Support */
	"EXCH",		/* Exchange manager */
	"ELS"		/* FCPH ELS driver */
};

		/*  Macro to convert from Module ID to string.
		 *
		 *  This macro returns a pointer to a string containing the module
		 *  ID string.  If the module is invalid, it returns unknown module.
		 */
#define RAS_MODULE_STRING(x)	( ( (x) <= 0) || ( (x) > RAS_MODULE_ID_MAX) ) ?\
								trace_id_string_array[0] : \
								trace_id_string_array[x]

#endif	/*  __RAS_INTERNAL_USER__ */



