/*
 *
 *  Copyright (C) 2003 - 2004 Brocade Communications
 *  All rights reserved.
 *
 *  Description:
 *  This file include the data definitation of Message Object
 *  A Message Object will be created by raslog Logging library when raslog()
 *  function is called by application to generate a message. The Message Object
 *  provides the interface to retrieve the message object information. Message
 *  object information will be set up by different raslog object while
 *  traveling from Logging Library to message receiver. The information such
 *  as service_id, instance, comp_id, msg_id flags, objid and argument list
 *  will be setup by Logging Library. The time_stamp, global_seq and
 *  external_seq will be setup by Incoming Message Queue Object. The repeat
 *  count will be setup by kernel message de-queue thread. And the overflow
 *  count will be setup by Incoming Message Queue Object or by kernel
 *  message de-queue thread. Every message object base on message receiver
 *  filter setting will be delivered to message receiver for future
 *  processing. Each message object is identified by msg_id.
 *  And the msg_id is used to refer to corresponded message entry in Message
 *  Catalog.
 *
 *  These coded instructions and statements contain unpublished trade
 *  secrets and proprietary information.  They are protected by federal
 *  copyright law and by trade secret law, and may not be disclosed to
 *  third parties or used, copied, or duplicated in any form, in whole
 *  or in part, without the prior written consent of Brocade Communications.
 *
 */


#ifndef __RASLOG_MSG_H__
#define __RASLOG_MSG_H__
#include <ras/ras_event.h>	/* RAS event */
#include <raslog/raslog_msgdef.h>	/* raslog_msgdef_t */
#include <raslog/raslog_comm.h>	/* raslog_msg_id_t */


#define RASLOG_WD_SIZE		4

#define RLMO_MSG_ARG_LEN    MSG_ARG_LEN
#define RLMO_MAX_MSG_ARGS   16
#define RLMO_MSG_INFO_LEN   64	/* for internal info, ie file, fn, ln */
#define RLMO_MAX_FILE_LEN   16
#define RLMO_MAX_FUNC_LEN   16

/* type of messages */
#define RASLOG_MSGS_PER_TYPE		1024
#define RASLOG_NUM_TYPES 		2
#define RASLOG_ALL_MSGS 		0
#define RASLOG_INT_MSGS 		1
#define RASLOG_EXT_MSGS 		2

#define RLMO_INTERNAL_START		1000
#define RLMO_INTERNAL_END		4999
#define RLMO_EXTERNAL_START		5000
#define RLMO_EXTERNAL_END		8999

#define RASLOG_ALL_INST			(-1)


/* old msg (pre FabOS 5.1) object structure */
typedef struct raslog_old_msg {
	int service_id;		/* service id, setup by raslog_init */
	int instance ;		/* instance number, setup by raslog_init */
	int comp_id;		/* component id, setup by raslog_init */
	raslog_msg_id_t  msg_id;
	int time_sec;
	int time_usec;
	/* Log specific information */
	int global_seq;		/* raslog global sequence number */
	int external_seq;	/* raslog external sequence number */
	char name[16];		/* switchname/chassisname to display with message */
	short iq_drop;		/* incoming message queue message drop count */
	short rq_drop;		/* receiver message queue message drop count */
	int flags;			/* defined in raslog.h */
	int objid;			/* object ID of event */

	/* Filename/function name/line # where event was generated */
	char file[RLMO_MAX_FILE_LEN];
	char func[RLMO_MAX_FUNC_LEN];
	unsigned int line;

	/* Variable arguments */
	char arg_offset[RLMO_MAX_MSG_ARGS];	/* word offsets of arguments */
	char arg[RLMO_MSG_ARG_LEN];			/* packed arguments */

	/* Static message definition from message catalog */
	rlmd_old_msgdef_t msgdef;
} raslog_old_msg_t;

/* macros to access msg object structure */

/* set service id */
#define RLMO_SET_SVC_ID(mo, value)	((mo)->service_id = value)
/* get service id */
#define RLMO_GET_SVC_ID(mo)		((mo)->service_id)
/* set instnace */
#define RLMO_SET_INSTANCE(mo, value)	((mo)->instance = value)
/* get instance */
#define RLMO_GET_INSTANCE(mo)		((mo)->instance)
/* set component id */
#define RLMO_SET_COMP_ID(mo, value)	((mo)->comp_id = value)
/* get component id */
#define RLMO_GET_COMP_ID(mo)    	((mo)->comp_id)
/* get component name */
#define RLMO_GET_COMP_NAME(mo)    	((mo)->comp_name)
/* set component name */
#define RLMO_SET_COMP_NAME(mo, value)    (strcpy(mo)->comp_name, value)
/* set msg id */
#define RLMO_SET_MSG_ID(mo, value)	((mo)->msg_id = value)
/* get msg id */
#define RLMO_GET_MSG_ID(mo)		((mo)->msg_id)
/* set time second */
#define RLMO_SET_TIMESEC(mo, value)	((mo)->time_sec = value)
/* get time second */
#define RLMO_GET_TIMESEC(mo)		((mo)->time_sec)
/* set time micro second */
#define RLMO_SET_TIMEUSEC(mo, value)	((mo)->time_usec = value)
/* get time micro second */
#define RLMO_GET_TIMEUSEC(mo)		((mo)->time_usec)
/* set global sequence number */
#define RLMO_SET_GSEQ(mo, value)	((mo)->global_seq = value)
/* get global sequence number */
#define RLMO_GET_GSEQ(mo)		((mo)->global_seq)
/* set external sequence number */
#define RLMO_SET_ESEQ(mo, value)	((mo)->external_seq = value)
/* get external sequence number */
#define RLMO_GET_ESEQ(mo)		((mo)->external_seq)
/* set name of switch instance */
#define RLMO_SET_NAME(mo, value)	(strcpy((mo)->name, value))
/* get name of switch instance */
#define RLMO_GET_NAME(mo)		((mo)->name)
/* set incoming msg queue drop count */
#define RLMO_SET_IQDROP(mo, value)	((mo)->iq_drop = value)
/* add incoming msg queue drop count */
#define RLMO_ADD_IQDROP(mo, value)	((mo)->iq_drop += value)
/* get incoming msg queue drop count */
#define RLMO_GET_IQDROP(mo)		((mo)->iq_drop)
/* set receiver msg queue drop count */
#define RLMO_SET_RQDROP(mo, value)	((mo)->rq_drop = value)
/* add receiver msg queue drop count */
#define RLMO_ADD_RQDROP(mo, value)	((mo)->rq_drop += value)
/* get receiver msg queue drop count */
#define RLMO_GET_RQDROP(mo)		((mo)->rq_drop)
/* set flags */
#define RLMO_SET_FLAGS(mo, value)	((mo)->flags = value)
/* get flags */
#define RLMO_GET_FLAGS(mo)		((mo)->flags)
/* set objid */
#define RLMO_SET_OBJID(mo, value)	((mo)->objid = value)
/* get objid */
#define RLMO_GET_OBJID(mo)		((mo)->objid)
/* compare arguemnt content */
#define RLMO_ARG_COMP(mosrc, modest)\
(memcmp((mosrc)->arg, (modest)->arg, RLMO_MSG_ARG_LEN))

/* get the character offset for the argument */
#define RLMO_ARG_OFFSET_GET(mo, number) ((u_int)((mo)->arg_offset[number] * 4))
#define RLMO_ARG_OFFSET_INVALID	0xff

/* set line number */
#define RLMO_SET_LINENUM(mo, value)	((mo)->line = value)
/* get line number */
#define RLMO_GET_LINENUM(mo)		((mo)->line)
/* set filename */
#define RLMO_SET_FILENAME(mo, value) 	(strcpy((mo)->file, value))
/* get filename */
#define RLMO_GET_FILENAME(mo) 			((mo)->file)
/* set func */
#define RLMO_SET_FUNC(mo, value) 	(strcpy((mo)->func, value))
/* get func */
#define RLMO_GET_FUNC(mo) 			((mo)->func)

#define RLMO_COPY_ARG_OFFSET(dest, src) \
        memcpy((dest)->arg_offset, (src)->arg_offset, RLMO_MAX_MSG_ARGS)

#define RLMO_COPY_ARG(dest, src) \
	memcpy((dest)->arg, (src)->arg, RLMO_MSG_ARG_LEN)

/* set msg definition */
#define RLMO_SET_MSGDEF(mo, md) (((mo)->msgdef) = md)
/* get msg definition */
#define RLMO_GET_MSGDEF(mo) (&(mo)->msgdef)


#endif /* __RASLOG_MSG_H__ */
